/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal.safeparcel;

import android.content.Intent;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.Base64Utils;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.ArrayList;

@VisibleForTesting
@KeepForSdk
public final class SafeParcelableSerializer {
    @KeepForSdk
    @RecentlyNonNull
    public static <T extends SafeParcelable> byte[] serializeToBytes(@RecentlyNonNull T t) {
        Parcel parcel = Parcel.obtain();
        t.writeToParcel(parcel, 0);
        byte[] byArray = parcel.marshall();
        parcel.recycle();
        return byArray;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static <T extends SafeParcelable> T deserializeFromBytes(@RecentlyNonNull byte[] byArray, @RecentlyNonNull Parcelable.Creator<T> creator) {
        Preconditions.checkNotNull(creator);
        Parcel parcel = Parcel.obtain();
        parcel.unmarshall(byArray, 0, byArray.length);
        parcel.setDataPosition(0);
        SafeParcelable safeParcelable = (SafeParcelable)creator.createFromParcel(parcel);
        parcel.recycle();
        return (T)safeParcelable;
    }

    public static <T extends SafeParcelable> void serializeIterableToBundle(@RecentlyNonNull Iterable<T> iterable, @RecentlyNonNull Bundle bundle, @RecentlyNonNull String string2) {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        for (SafeParcelable safeParcelable : iterable) {
            arrayList.add(SafeParcelableSerializer.serializeToBytes(safeParcelable));
        }
        bundle.putSerializable(string2, arrayList);
    }

    @RecentlyNullable
    public static <T extends SafeParcelable> ArrayList<T> deserializeIterableFromBundle(@RecentlyNonNull Bundle bundle, @RecentlyNonNull String string2, @RecentlyNonNull Parcelable.Creator<T> creator) {
        ArrayList arrayList = (ArrayList)bundle.getSerializable(string2);
        if (arrayList == null) {
            return null;
        }
        ArrayList<T> arrayList2 = new ArrayList<T>(arrayList.size());
        ArrayList arrayList3 = arrayList;
        int n = arrayList3.size();
        for (int i = 0; i < n; ++i) {
            Object e = arrayList3.get(i);
            byte[] byArray = (byte[])e;
            arrayList2.add(SafeParcelableSerializer.deserializeFromBytes(byArray, creator));
        }
        return arrayList2;
    }

    @KeepForSdk
    @RecentlyNonNull
    public static <T extends SafeParcelable> String serializeToString(@RecentlyNonNull T t) {
        return Base64Utils.encodeUrlSafe(SafeParcelableSerializer.serializeToBytes(t));
    }

    @KeepForSdk
    @RecentlyNonNull
    public static <T extends SafeParcelable> T deserializeFromString(@RecentlyNonNull String string2, @RecentlyNonNull Parcelable.Creator<T> creator) {
        return SafeParcelableSerializer.deserializeFromBytes(Base64Utils.decodeUrlSafe(string2), creator);
    }

    @KeepForSdk
    public static <T extends SafeParcelable> void serializeToIntentExtra(@RecentlyNonNull T t, @RecentlyNonNull Intent intent, @RecentlyNonNull String string2) {
        intent.putExtra(string2, SafeParcelableSerializer.serializeToBytes(t));
    }

    @RecentlyNullable
    @KeepForSdk
    public static <T extends SafeParcelable> T deserializeFromIntentExtra(@RecentlyNonNull Intent intent, @RecentlyNonNull String string2, @RecentlyNonNull Parcelable.Creator<T> creator) {
        byte[] byArray = intent.getByteArrayExtra(string2);
        if (byArray == null) {
            return null;
        }
        return SafeParcelableSerializer.deserializeFromBytes(byArray, creator);
    }

    @KeepForSdk
    public static <T extends SafeParcelable> void serializeIterableToIntentExtra(@RecentlyNonNull Iterable<T> iterable, @RecentlyNonNull Intent intent, @RecentlyNonNull String string2) {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        for (SafeParcelable safeParcelable : iterable) {
            arrayList.add(SafeParcelableSerializer.serializeToBytes(safeParcelable));
        }
        intent.putExtra(string2, arrayList);
    }

    @RecentlyNullable
    @KeepForSdk
    public static <T extends SafeParcelable> ArrayList<T> deserializeIterableFromIntentExtra(@RecentlyNonNull Intent intent, @RecentlyNonNull String string2, @RecentlyNonNull Parcelable.Creator<T> creator) {
        ArrayList arrayList = (ArrayList)intent.getSerializableExtra(string2);
        if (arrayList == null) {
            return null;
        }
        ArrayList<T> arrayList2 = new ArrayList<T>(arrayList.size());
        ArrayList arrayList3 = arrayList;
        int n = arrayList3.size();
        for (int i = 0; i < n; ++i) {
            Object e = arrayList3.get(i);
            byte[] byArray = (byte[])e;
            arrayList2.add(SafeParcelableSerializer.deserializeFromBytes(byArray, creator));
        }
        return arrayList2;
    }
}

