/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.stats;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.util.Log;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zzk;
import com.google.android.gms.common.util.ClientLibraryUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

@KeepForSdk
public class ConnectionTracker {
    private static final Object zza = new Object();
    @Nullable
    private static volatile ConnectionTracker zzb;
    @VisibleForTesting
    private static boolean zzc;
    @VisibleForTesting
    private ConcurrentHashMap<ServiceConnection, ServiceConnection> zzd = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    @RecentlyNonNull
    public static ConnectionTracker getInstance() {
        if (zzb == null) {
            Object object = zza;
            synchronized (object) {
                if (zzb == null) {
                    zzb = new ConnectionTracker();
                }
            }
        }
        return Preconditions.checkNotNull(zzb);
    }

    private ConnectionTracker() {
    }

    @RecentlyNonNull
    public final boolean zza(@RecentlyNonNull Context context, @RecentlyNonNull String string2, @RecentlyNonNull Intent intent, @RecentlyNonNull ServiceConnection serviceConnection, @RecentlyNonNull int n) {
        return this.zza(context, string2, intent, serviceConnection, n, true);
    }

    @SuppressLint(value={"UntrackedBindService"})
    private final boolean zza(Context context, String string2, Intent intent, ServiceConnection serviceConnection, int n, boolean bl) {
        boolean bl2;
        block4: {
            block5: {
                Intent intent2 = intent;
                Context context2 = context;
                ComponentName componentName = intent2.getComponent();
                if (componentName == null ? false : ClientLibraryUtils.zza(context2, componentName.getPackageName())) {
                    Log.w((String)"ConnectionTracker", (String)"Attempted to bind to a service in a STOPPED package.");
                    return false;
                }
                if (!ConnectionTracker.zza(serviceConnection)) break block5;
                ServiceConnection serviceConnection2 = serviceConnection;
                ServiceConnection serviceConnection3 = this.zzd.putIfAbsent(serviceConnection, serviceConnection2);
                if (serviceConnection3 != null && serviceConnection2 != serviceConnection3) {
                    String string3 = String.format("Duplicate binding with the same ServiceConnection: %s, %s, %s.", serviceConnection, string2, intent.getAction());
                    Log.w((String)"ConnectionTracker", (String)string3);
                }
                try {
                    bl2 = context.bindService(intent, serviceConnection2, n);
                    if (bl2) break block4;
                    this.zzd.remove(serviceConnection, serviceConnection2);
                }
                catch (Throwable throwable) {
                    this.zzd.remove(serviceConnection, serviceConnection2);
                    throw throwable;
                }
                break block4;
            }
            bl2 = context.bindService(intent, serviceConnection, n);
        }
        return bl2;
    }

    @KeepForSdk
    @RecentlyNonNull
    public boolean bindService(@RecentlyNonNull Context context, @RecentlyNonNull Intent intent, @RecentlyNonNull ServiceConnection serviceConnection, @RecentlyNonNull int n) {
        return this.zza(context, context.getClass().getName(), intent, serviceConnection, n);
    }

    @SuppressLint(value={"UntrackedBindService"})
    @KeepForSdk
    public void unbindService(@RecentlyNonNull Context context, @RecentlyNonNull ServiceConnection serviceConnection) {
        if (ConnectionTracker.zza(serviceConnection) && this.zzd.containsKey(serviceConnection)) {
            try {
                ServiceConnection serviceConnection2 = this.zzd.get(serviceConnection);
                Context context2 = context;
                try {
                    context2.unbindService(serviceConnection2);
                }
                catch (IllegalArgumentException | IllegalStateException runtimeException) {}
                return;
            }
            finally {
                this.zzd.remove(serviceConnection);
            }
        }
        ServiceConnection serviceConnection3 = serviceConnection;
        Context context3 = context;
        try {
            context3.unbindService(serviceConnection3);
            return;
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {
            return;
        }
    }

    private static boolean zza(ServiceConnection serviceConnection) {
        return !(serviceConnection instanceof zzk);
    }

    @SuppressLint(value={"UntrackedBindService"})
    @KeepForSdk
    public void unbindServiceSafe(@RecentlyNonNull Context context, @RecentlyNonNull ServiceConnection serviceConnection) {
        try {
            this.unbindService(context, serviceConnection);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.w((String)"ConnectionTracker", (String)"Exception thrown while unbinding", (Throwable)illegalArgumentException);
            return;
        }
    }

    static {
        zzc = false;
    }
}

