/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.collection.ArrayMap;
import androidx.collection.ArraySet;
import com.google.android.gms.common.annotation.KeepForSdk;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@KeepForSdk
public final class CollectionUtils {
    private CollectionUtils() {
    }

    @KeepForSdk
    @RecentlyNonNull
    public static boolean isEmpty(@Nullable Collection<?> collection) {
        if (collection == null) {
            return true;
        }
        return collection.isEmpty();
    }

    @Deprecated
    @KeepForSdk
    @RecentlyNonNull
    public static <T> List<T> listOf() {
        return Collections.emptyList();
    }

    @Deprecated
    @KeepForSdk
    @RecentlyNonNull
    public static <T> List<T> listOf(@RecentlyNonNull T t) {
        return Collections.singletonList(t);
    }

    @Deprecated
    @KeepForSdk
    @RecentlyNonNull
    public static <T> List<T> listOf(T ... TArray) {
        switch (TArray.length) {
            case 0: {
                return CollectionUtils.listOf();
            }
            case 1: {
                return CollectionUtils.listOf(TArray[0]);
            }
        }
        return Collections.unmodifiableList(Arrays.asList(TArray));
    }

    private static <T> Set<T> zza(int n, boolean bl) {
        int n2;
        float f = bl ? 0.75f : 1.0f;
        int n3 = n2 = bl ? 128 : 256;
        if (n <= n2) {
            return new ArraySet(n);
        }
        return new HashSet(n, f);
    }

    @Deprecated
    @KeepForSdk
    @RecentlyNonNull
    public static <T> Set<T> setOf(@RecentlyNonNull T t, @RecentlyNonNull T t2, @RecentlyNonNull T t3) {
        Set<T> set = CollectionUtils.zza(3, false);
        set.add(t);
        set.add(t2);
        set.add(t3);
        return Collections.unmodifiableSet(set);
    }

    @Deprecated
    @KeepForSdk
    @RecentlyNonNull
    public static <T> Set<T> setOf(T ... TArray) {
        switch (TArray.length) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(TArray[0]);
            }
            case 2: {
                T t = TArray[1];
                T t2 = TArray[0];
                Set<T> set = CollectionUtils.zza(2, false);
                set.add(t2);
                set.add(t);
                return Collections.unmodifiableSet(set);
            }
            case 3: {
                return CollectionUtils.setOf(TArray[0], TArray[1], TArray[2]);
            }
            case 4: {
                T t = TArray[3];
                T t3 = TArray[2];
                T t4 = TArray[1];
                T t5 = TArray[0];
                Set<T> set = CollectionUtils.zza(4, false);
                set.add(t5);
                set.add(t4);
                set.add(t3);
                set.add(t);
                return Collections.unmodifiableSet(set);
            }
        }
        T[] TArray2 = TArray;
        Set<T> set = CollectionUtils.zza(TArray.length, false);
        Collections.addAll(set, TArray2);
        return Collections.unmodifiableSet(set);
    }

    @KeepForSdk
    @RecentlyNonNull
    public static <T> Set<T> mutableSetOfWithSize(@RecentlyNonNull int n) {
        if (n == 0) {
            return new ArraySet();
        }
        return CollectionUtils.zza(n, true);
    }

    private static <K, V> Map<K, V> zzb(int n, boolean bl) {
        if (n <= 256) {
            return new ArrayMap(n);
        }
        return new HashMap(n, 1.0f);
    }

    @KeepForSdk
    @RecentlyNonNull
    public static <K, V> Map<K, V> mapOf(@RecentlyNonNull K k, @RecentlyNonNull V v, @RecentlyNonNull K k2, @RecentlyNonNull V v2, @RecentlyNonNull K k3, @RecentlyNonNull V v3) {
        Map<K, V> map = CollectionUtils.zzb(3, false);
        map.put(k, v);
        map.put(k2, v2);
        map.put(k3, v3);
        return Collections.unmodifiableMap(map);
    }

    @KeepForSdk
    @RecentlyNonNull
    public static <K, V> Map<K, V> mapOf(@RecentlyNonNull K k, @RecentlyNonNull V v, @RecentlyNonNull K k2, @RecentlyNonNull V v2, @RecentlyNonNull K k3, @RecentlyNonNull V v3, @RecentlyNonNull K k4, @RecentlyNonNull V v4, @RecentlyNonNull K k5, @RecentlyNonNull V v5, @RecentlyNonNull K k6, @RecentlyNonNull V v6) {
        Map<K, V> map = CollectionUtils.zzb(6, false);
        map.put(k, v);
        map.put(k2, v2);
        map.put(k3, v3);
        map.put(k4, v4);
        map.put(k5, v5);
        map.put(k6, v6);
        return Collections.unmodifiableMap(map);
    }

    @KeepForSdk
    @RecentlyNonNull
    public static <K, V> Map<K, V> mapOfKeyValueArrays(@RecentlyNonNull K[] KArray, @RecentlyNonNull V[] VArray) {
        V[] VArray2 = VArray;
        K[] KArray2 = KArray;
        if (KArray.length != VArray2.length) {
            int n = KArray2.length;
            int n2 = VArray2.length;
            throw new IllegalArgumentException(new StringBuilder(66).append("Key and values array lengths not equal: ").append(n).append(" != ").append(n2).toString());
        }
        switch (KArray.length) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                return Collections.singletonMap(KArray[0], VArray[0]);
            }
        }
        V[] VArray3 = VArray;
        K[] KArray3 = KArray;
        Map<K, V> map = CollectionUtils.zzb(KArray.length, false);
        V[] VArray4 = VArray3;
        K[] KArray4 = KArray3;
        Map<K, V> map2 = map;
        for (int i = 0; i < KArray4.length; ++i) {
            map2.put(KArray4[i], VArray4[i]);
        }
        return Collections.unmodifiableMap(map);
    }
}

