/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.os.Process;
import android.os.StrictMode;
import androidx.annotation.RecentlyNullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.IOUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import javax.annotation.Nullable;

@KeepForSdk
public class ProcessUtils {
    @Nullable
    private static String zza = null;
    private static int zzb = 0;

    private ProcessUtils() {
    }

    @RecentlyNullable
    @KeepForSdk
    public static String getMyProcessName() {
        if (zza == null) {
            if (zzb == 0) {
                zzb = Process.myPid();
            }
            zza = ProcessUtils.zza(zzb);
        }
        return zza;
    }

    @Nullable
    private static String zza(int n) {
        if (n <= 0) {
            return null;
        }
        BufferedReader bufferedReader = null;
        String string2 = null;
        try {
            bufferedReader = ProcessUtils.zza(new StringBuilder(25).append("/proc/").append(n).append("/cmdline").toString());
            string2 = Preconditions.checkNotNull(bufferedReader.readLine()).trim();
        }
        catch (IOException iOException) {
            IOUtils.closeQuietly(bufferedReader);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bufferedReader);
            throw throwable;
        }
        IOUtils.closeQuietly(bufferedReader);
        return string2;
    }

    private static BufferedReader zza(String string2) throws IOException {
        BufferedReader bufferedReader;
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        try {
            bufferedReader = new BufferedReader(new FileReader(string2));
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
        return bufferedReader;
    }
}

