/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import javax.annotation.Nullable;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

@KeepForSdk
public final class Asserts {
    private Asserts() {
        Object object = new AssertionError((Object)"Uninstantiable");
        throw object;
    }

    @KeepForSdk
    public static void checkMainThread(@NonNull String errorMessage) {
        if (Looper.getMainLooper().getThread() != Thread.currentThread()) {
            String string2;
            Object object = String.valueOf(Thread.currentThread());
            String string3 = String.valueOf(Looper.getMainLooper().getThread());
            String string4 = String.valueOf(object);
            int n = string4.length();
            String string5 = String.valueOf(string3);
            int n2 = string5.length();
            StringBuilder stringBuilder = new StringBuilder(n + 57 + n2);
            stringBuilder.append("checkMainThread: current thread ");
            stringBuilder.append((String)object);
            stringBuilder.append(" IS NOT the main thread ");
            stringBuilder.append(string3);
            stringBuilder.append("!");
            Log.e((String)"Asserts", (String)stringBuilder.toString());
            object = new IllegalStateException(string2);
            throw object;
        }
    }

    @KeepForSdk
    public static void checkNotMainThread(@NonNull String errorMessage) {
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            String string2;
            Object object = String.valueOf(Thread.currentThread());
            String string3 = String.valueOf(Looper.getMainLooper().getThread());
            String string4 = String.valueOf(object);
            int n = string4.length();
            String string5 = String.valueOf(string3);
            int n2 = string5.length();
            StringBuilder stringBuilder = new StringBuilder(n + 56 + n2);
            stringBuilder.append("checkNotMainThread: current thread ");
            stringBuilder.append((String)object);
            stringBuilder.append(" IS the main thread ");
            stringBuilder.append(string3);
            stringBuilder.append("!");
            Log.e((String)"Asserts", (String)stringBuilder.toString());
            object = new IllegalStateException(string2);
            throw object;
        }
    }

    @EnsuresNonNull(value={"#1"})
    @KeepForSdk
    public static void checkNotNull(@Nullable Object reference) {
        if (reference == null) {
            Object object = new IllegalArgumentException("null reference");
            throw object;
        }
    }

    /*
     * WARNING - void declaration
     */
    @EnsuresNonNull(value={"#1"})
    @KeepForSdk
    public static void checkNotNull(@Nullable Object reference, @NonNull Object errorMessage) {
        if (reference == null) {
            void var1_1;
            Object object = new IllegalArgumentException(String.valueOf(var1_1));
            throw object;
        }
    }

    @KeepForSdk
    public static void checkNull(@NonNull Object reference) {
        if (reference != null) {
            Object object = new IllegalArgumentException("non-null reference");
            throw object;
        }
    }

    @KeepForSdk
    public static void checkState(boolean expression) {
        if (!expression) {
            IllegalStateException illegalStateException = new IllegalStateException();
            throw illegalStateException;
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public static void checkState(boolean expression, @NonNull Object errorMessage) {
        if (!expression) {
            void var1_2;
            IllegalStateException illegalStateException = new IllegalStateException(String.valueOf(var1_2));
            throw illegalStateException;
        }
    }
}

