/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import androidx.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.internal.common.zzo;
import com.google.android.gms.internal.common.zzx;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

@KeepForSdk
public class HttpUtils {
    private static final Pattern zza = Pattern.compile("^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$");
    private static final Pattern zzb = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
    private static final Pattern zzc = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$");

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    @NonNull
    public static Map<String, String> parse(@NonNull URI uri, @NonNull String encoding) {
        List<String> list;
        HashMap<String, Object> hashMap = Collections.emptyMap();
        if ((list = ((URI)((Object)list)).getRawQuery()) == null) {
            return hashMap;
        }
        if (((String)((Object)list)).length() <= 0) {
            return hashMap;
        }
        hashMap = new HashMap<String, Object>();
        zzx zzx2 = zzx.zzc(zzo.zzb('='));
        Iterator<String> iterator = zzx.zzc(zzo.zzb('&')).zzb().zzd((CharSequence)((Object)list)).iterator();
        while (iterator.hasNext()) {
            void var1_1;
            list = zzx2.zzf(iterator.next());
            if (list.isEmpty() || list.size() > 2) {
                list = new IllegalArgumentException("bad parameter");
                throw list;
            }
            String string2 = HttpUtils.zza((String)list.get(0), (String)var1_1);
            list = list.size() == 2 ? HttpUtils.zza((String)list.get(1), (String)var1_1) : null;
            hashMap.put(string2, list);
        }
        return hashMap;
    }

    private HttpUtils() {
    }

    private static String zza(String string2, String object) {
        if (object == null) {
            object = "ISO-8859-1";
        }
        try {
            string2 = URLDecoder.decode(string2, (String)object);
            return string2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            object = new IllegalArgumentException(unsupportedEncodingException);
            throw object;
        }
    }
}

