/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Process;
import android.os.WorkSource;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.Strings;
import com.google.android.gms.common.wrappers.Wrappers;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

@KeepForSdk
public class WorkSourceUtil {
    private static final int zza;
    private static final Method zzb;
    private static final Method zzc;
    private static final Method zzd;
    private static final Method zze;
    private static final Method zzf;
    private static final Method zzg;
    private static final Method zzh;
    private static final Method zzi;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    @KeepForSdk
    @NonNull
    public static WorkSource fromPackage(@NonNull Context context, @NonNull String packageName) {
        ApplicationInfo applicationInfo;
        String string2;
        block4: {
            void var0_4;
            block6: {
                String string3;
                block5: {
                    Context context2;
                    if (context == null) return null;
                    if (context2.getPackageManager() == null) return null;
                    if (string2 == null) return null;
                    try {
                        applicationInfo = Wrappers.packageManager(context2).getApplicationInfo(string2, 0);
                        if (applicationInfo != null) break block4;
                        string3 = "Could not get applicationInfo from package: ";
                        if (string2.length() == 0) break block5;
                        String string4 = string3.concat(string2);
                        break block6;
                    }
                    catch (PackageManager.NameNotFoundException nameNotFoundException) {
                        void var0_9;
                        String string6 = "Could not find package: ";
                        if (string2.length() != 0) {
                            String string7 = string6.concat(string2);
                        } else {
                            String string8 = string2 = new String(string6);
                        }
                        Log.e((String)"WorkSourceUtil", (String)var0_9);
                        return null;
                    }
                }
                String string5 = string2 = new String(string3);
            }
            Log.e((String)"WorkSourceUtil", (String)var0_4);
            return null;
        }
        int n = applicationInfo.uid;
        WorkSource workSource = new WorkSource();
        WorkSourceUtil.add(workSource, n, string2);
        return workSource;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    @NonNull
    public static WorkSource fromPackageAndModuleExperimentalPi(@NonNull Context context, @NonNull String packageName, @NonNull String moduleName) {
        void var0_6;
        String string2;
        Object[] objectArray;
        void var2_17;
        block13: {
            ApplicationInfo applicationInfo;
            block10: {
                void var0_4;
                block12: {
                    String string3;
                    block11: {
                        Context context2;
                        if (context == null || context2.getPackageManager() == null || var2_17 == null || objectArray == null) {
                            Log.w((String)"WorkSourceUtil", (String)"Unexpected null arguments");
                            return null;
                        }
                        try {
                            applicationInfo = Wrappers.packageManager(context2).getApplicationInfo((String)objectArray, 0);
                            if (applicationInfo != null) break block10;
                            string3 = "Could not get applicationInfo from package: ";
                            if (objectArray.length() == 0) break block11;
                            String string4 = string3.concat((String)objectArray);
                            break block12;
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            void var0_12;
                            String string5 = "Could not find package: ";
                            if (objectArray.length() != 0) {
                                String string6 = string5.concat((String)objectArray);
                            } else {
                                String string7 = string2 = new String(string5);
                            }
                            Log.e((String)"WorkSourceUtil", (String)var0_12);
                            int n = -1;
                        }
                    }
                    String string8 = string2 = new String(string3);
                }
                Log.e((String)"WorkSourceUtil", (String)var0_4);
                int n = -1;
                break block13;
            }
            int n = applicationInfo.uid;
        }
        if (var0_6 < 0) {
            return null;
        }
        string2 = new WorkSource();
        Object object = zzg;
        if (object == null || zzh == null) {
            WorkSourceUtil.add((WorkSource)string2, (int)var0_6, (String)objectArray);
            return string2;
        }
        try {
            object = ((Method)object).invoke((Object)string2, new Object[0]);
            int n = zza;
            if (var0_6 != n) {
                Method method = zzh;
                Object[] objectArray2 = new Object[]{(int)var0_6, objectArray};
                method.invoke(object, objectArray2);
            }
            Method method = zzh;
            objectArray = new Object[]{zza, var2_17};
            method.invoke(object, objectArray);
            return string2;
        }
        catch (Exception exception) {
            Log.w((String)"WorkSourceUtil", (String)"Unable to assign chained blame through WorkSource", (Throwable)exception);
            return string2;
        }
    }

    /*
     * Unable to fully structure code
     */
    @KeepForSdk
    @NonNull
    public static List<String> getNames(@NonNull WorkSource workSource) {
        block6: {
            var4_1 = new ArrayList<String>();
            if (var0 != null) break block6;
            var1_2 = 0;
lbl4:
            // 2 sources

            while (true) {
                block7: {
                    if (var1_2 == 0) break block7;
                    block3: for (var2_3 = 0; var2_3 < var1_2; ++var2_3) {
                        var3_4 = WorkSourceUtil.zzf;
                        if (var3_4 != null) {
                            var5_6 = new Object[]{var2_3};
                            var3_4 = (String)var3_4.invoke((Object)var0, var5_6);
lbl12:
                            // 3 sources

                            while (true) {
                                if (Strings.isEmptyOrWhitespace((String)var3_4)) continue block3;
                                Preconditions.checkNotNull(var3_4);
                                var4_1.add((String)var3_4);
                                continue block3;
                                break;
                            }
                        }
                        var3_4 = null;
                        ** GOTO lbl12
                    }
                    return var4_1;
                }
                return var4_1;
            }
        }
        var1_2 = WorkSourceUtil.zza(var0);
        ** while (true)
        catch (Exception var3_5) {
            Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)var3_5);
            var3_4 = null;
            ** continue;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        block28: {
            block32: {
                block31: {
                    block30: {
                        block29: {
                            WorkSourceUtil.zza = Process.myUid();
                            try {
                                var0 = new Class[]{Integer.TYPE};
                                var0 = WorkSource.class.getMethod("add", (Class<?>)var0);
                            }
                            catch (Exception v0) {
                                var0 = null;
                            }
                            WorkSourceUtil.zzb = var0;
                            if (PlatformVersion.isAtLeastJellyBeanMR2()) {
                                var0 = new Class[]{Integer.TYPE, String.class};
                                var0 = WorkSource.class.getMethod("add", (Class<?>)var0);
                                ** GOTO lbl18
                            } else {
                                var0 = null;
                            }
                            break block29;
                            catch (Exception v1) {
                                var0 = null;
                            }
                        }
                        WorkSourceUtil.zzc = var0;
                        try {
                            var0 = WorkSource.class.getMethod("size", new Class[0]);
                        }
                        catch (Exception v2) {
                            var0 = null;
                        }
                        WorkSourceUtil.zzd = var0;
                        try {
                            var0 = new Class[]{Integer.TYPE};
                            var0 = WorkSource.class.getMethod("get", (Class<?>)var0);
                        }
                        catch (Exception v3) {
                            var0 = null;
                        }
                        WorkSourceUtil.zze = var0;
                        if (PlatformVersion.isAtLeastJellyBeanMR2()) {
                            var0 = new Class[]{Integer.TYPE};
                            var0 = WorkSource.class.getMethod("getName", (Class<?>)var0);
                            ** GOTO lbl42
                        } else {
                            var0 = null;
                        }
                        break block30;
                        catch (Exception v4) {
                            var0 = null;
                        }
                    }
                    WorkSourceUtil.zzf = var0;
                    if (PlatformVersion.isAtLeastP()) {
                        var0 = WorkSource.class.getMethod("createWorkChain", new Class[0]);
                        ** GOTO lbl54
                    } else {
                        var0 = null;
                    }
                    break block31;
                    catch (Exception var0_1) {
                        Log.w((String)"WorkSourceUtil", (String)"Missing WorkChain API createWorkChain", (Throwable)var0_1);
                        var0 = null;
                    }
                }
                WorkSourceUtil.zzg = var0;
                if (PlatformVersion.isAtLeastP()) {
                    var0 = Class.forName("android.os.WorkSource$WorkChain");
                    var1_3 = new Class[]{Integer.TYPE, String.class};
                    var0 = var0.getMethod("addNode", var1_3);
                    ** GOTO lbl68
                } else {
                    var0 = null;
                }
                break block32;
                catch (Exception var0_2) {
                    Log.w((String)"WorkSourceUtil", (String)"Missing WorkChain class", (Throwable)var0_2);
                    var0 = null;
                }
            }
            WorkSourceUtil.zzh = var0;
            if (PlatformVersion.isAtLeastP()) {
                var0 = WorkSource.class.getMethod("isEmpty", new Class[0]);
                var0.setAccessible(true);
                ** GOTO lbl82
            } else {
                var0 = null;
            }
            break block28;
            catch (Exception v5) {
                var0 = null;
                break block28;
            }
            catch (Exception v6) {}
        }
        WorkSourceUtil.zzi = var0;
    }

    private WorkSourceUtil() {
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @KeepForSdk
    public static void add(@NonNull WorkSource workSource, int uid, @NonNull String packageName) {
        WorkSource workSource2;
        void var1_3;
        Object object;
        Object[] objectArray = zzc;
        if (objectArray != null) {
            if (object == null) {
                object = "";
            }
            Object[] objectArray2 = new Object[]{(int)var1_3, object};
            objectArray.invoke((Object)workSource2, objectArray2);
            return;
        }
        object = zzb;
        if (object == null) return;
        try {
            objectArray = new Object[]{(int)var1_3};
            ((Method)object).invoke((Object)workSource2, objectArray);
            return;
        }
        catch (Exception exception) {
            Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            return;
        }
        catch (Exception exception) {
            Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            return;
        }
    }

    @KeepForSdk
    public static boolean hasWorkSourcePermission(@NonNull Context context) {
        Context context2;
        if (context == null) {
            return false;
        }
        if (context2.getPackageManager() == null) {
            return false;
        }
        return Wrappers.packageManager(context2).checkPermission("android.permission.UPDATE_DEVICE_STATS", context2.getPackageName()) == 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    public static boolean isEmpty(@NonNull WorkSource workSource) {
        WorkSource workSource2;
        Object object = zzi;
        if (object != null) {
            try {
                object = ((Method)object).invoke((Object)workSource2, new Object[0]);
                Preconditions.checkNotNull(object);
                return (Boolean)object;
            }
            catch (Exception exception) {
                Log.e((String)"WorkSourceUtil", (String)"Unable to check WorkSource emptiness", (Throwable)exception);
            }
        }
        if (WorkSourceUtil.zza(workSource2) != 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int zza(@NonNull WorkSource object) {
        Method method = zzd;
        if (method == null) return 0;
        try {
            Object object2 = method.invoke(object, new Object[0]);
            Preconditions.checkNotNull(object2);
            return (Integer)object2;
        }
        catch (Exception exception) {
            Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            return 0;
        }
    }
}

