/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dynamic;

import android.os.IBinder;
import androidx.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.RetainForClient;
import com.google.android.gms.dynamic.IObjectWrapper;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;

@KeepForSdk
@RetainForClient
public final class ObjectWrapper<T>
extends IObjectWrapper.Stub {
    private final T zza;

    @KeepForSdk
    @NonNull
    public static <T> IObjectWrapper wrap(@NonNull T object) {
        T t;
        ObjectWrapper<T> objectWrapper = new ObjectWrapper<T>(t);
        return objectWrapper;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    @NonNull
    public static <T> T unwrap(@NonNull IObjectWrapper remote) {
        Object object;
        if (remote instanceof ObjectWrapper) {
            return ((ObjectWrapper)object).zza;
        }
        IBinder iBinder = object.asBinder();
        Field[] fieldArray = iBinder.getClass().getDeclaredFields();
        int n = fieldArray.length;
        object = null;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3;
            Field field = fieldArray[i];
            if (!field.isSynthetic()) {
                object = field;
                n3 = ++n2;
            } else {
                n3 = n2;
            }
            n2 = n3;
        }
        if (n2 != 1) {
            n2 = fieldArray.length;
            StringBuilder stringBuilder = new StringBuilder(64);
            stringBuilder.append("Unexpected number of IObjectWrapper declared fields: ");
            stringBuilder.append(n2);
            object = new IllegalArgumentException(stringBuilder.toString());
            throw object;
        }
        Preconditions.checkNotNull(object);
        if (((AccessibleObject)object).isAccessible()) {
            object = new IllegalArgumentException("IObjectWrapper declared field not private!");
            throw object;
        }
        ((Field)object).setAccessible(true);
        try {
            object = ((Field)object).get(iBinder);
            return (T)object;
        }
        catch (IllegalAccessException illegalAccessException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Could not access the field in remoteBinder.", illegalAccessException);
            throw illegalArgumentException;
        }
        catch (NullPointerException nullPointerException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Binder object is null.", nullPointerException);
            throw illegalArgumentException;
        }
    }

    private ObjectWrapper(T t) {
        this.zza = t;
    }
}

