/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Process;
import android.os.WorkSource;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.Strings;
import com.google.android.gms.common.wrappers.Wrappers;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

@KeepForSdk
public class WorkSourceUtil {
    private static final int zza;
    private static final Method zzb;
    private static final Method zzc;
    private static final Method zzd;
    private static final Method zze;
    private static final Method zzf;
    private static final Method zzg;
    private static final Method zzh;
    private static final Method zzi;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @KeepForSdk
    @NonNull
    public static WorkSource fromPackage(@NonNull Context context, @NonNull String packageName) {
        void var1_2;
        Context context2;
        block2: {
            if (context == null || context2.getPackageManager() == null || var1_2 == null) return null;
            try {
                context2 = Wrappers.packageManager(context2).getApplicationInfo((String)var1_2, 0);
                if (context2 != null) break block2;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.e((String)"WorkSourceUtil", (String)"Could not find package: ".concat((String)var1_2));
                return null;
            }
            Log.e((String)"WorkSourceUtil", (String)"Could not get applicationInfo from package: ".concat((String)var1_2));
            return null;
        }
        int n = context2.uid;
        WorkSource workSource = new WorkSource();
        WorkSourceUtil.add(workSource, n, (String)var1_2);
        return workSource;
    }

    /*
     * Unable to fully structure code
     */
    @KeepForSdk
    @NonNull
    public static WorkSource fromPackageAndModuleExperimentalPi(@NonNull Context context, @NonNull String packageName, @NonNull String moduleName) {
        block10: {
            if (context == null || var0.getPackageManager() == null || var2_5 == null || var1_4 == null) {
                Log.w((String)"WorkSourceUtil", (String)"Unexpected null arguments");
                return null;
            }
            try {
                var0 = Wrappers.packageManager(var0).getApplicationInfo((String)var1_4, 0);
                if (var0 != null) break block10;
            }
            catch (PackageManager.NameNotFoundException v0) {
                Log.e((String)"WorkSourceUtil", (String)"Could not find package: ".concat((String)var1_4));
                var0_1 = -1;
                ** continue;
            }
            Log.e((String)"WorkSourceUtil", (String)"Could not get applicationInfo from package: ".concat((String)var1_4));
            var0_1 = -1;
lbl11:
            // 3 sources

            while (true) {
                if (var0_1 < 0) {
                    return null;
                }
                var3_6 = new WorkSource();
                var4_7 = WorkSourceUtil.zzg;
                if (var4_7 == null || WorkSourceUtil.zzh == null) {
                    WorkSourceUtil.add(var3_6, var0_1, (String)var1_4);
lbl18:
                    // 3 sources

                    return var3_6;
                }
                var4_7 = var4_7.invoke((Object)var3_6, new Object[0]);
                var5_8 = WorkSourceUtil.zza;
                if (var0_1 == var5_8) ** GOTO lbl29
                var5_9 = WorkSourceUtil.zzh;
                var6_10 = new Object[]{var0_1, var1_4};
                var5_9.invoke(var4_7, var6_10);
lbl29:
                // 2 sources

                var0_2 = WorkSourceUtil.zzh;
                var1_4 = new Object[]{WorkSourceUtil.zza, var2_5};
                var0_2.invoke(var4_7, var1_4);
                ** GOTO lbl18
                break;
            }
        }
        var0_1 = var0.uid;
        ** GOTO lbl11
        catch (Exception var0_3) {
            Log.w((String)"WorkSourceUtil", (String)"Unable to assign chained blame through WorkSource", (Throwable)var0_3);
            ** continue;
        }
    }

    /*
     * Unable to fully structure code
     */
    @KeepForSdk
    @NonNull
    public static List<String> getNames(@NonNull WorkSource workSource) {
        block6: {
            var4_1 = new ArrayList<String>();
            if (var0 != null) break block6;
            var1_2 = 0;
lbl4:
            // 2 sources

            while (true) {
                block7: {
                    if (var1_2 == 0) break block7;
                    block3: for (var2_3 = 0; var2_3 < var1_2; ++var2_3) {
                        var3_4 = WorkSourceUtil.zzf;
                        if (var3_4 != null) {
                            var5_6 = new Object[]{var2_3};
                            var3_4 = (String)var3_4.invoke((Object)var0, var5_6);
lbl12:
                            // 3 sources

                            while (true) {
                                if (Strings.isEmptyOrWhitespace((String)var3_4)) continue block3;
                                Preconditions.checkNotNull(var3_4);
                                var4_1.add((String)var3_4);
                                continue block3;
                                break;
                            }
                        }
                        var3_4 = null;
                        ** GOTO lbl12
                    }
                    return var4_1;
                }
                return var4_1;
            }
        }
        var1_2 = WorkSourceUtil.zza(var0);
        ** while (true)
        catch (Exception var3_5) {
            Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)var3_5);
            var3_4 = null;
            ** continue;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        block28: {
            block32: {
                block31: {
                    block30: {
                        block29: {
                            WorkSourceUtil.zza = Process.myUid();
                            try {
                                var0 = new Class[]{Integer.TYPE};
                                var0 = WorkSource.class.getMethod("add", (Class<?>)var0);
                            }
                            catch (Exception v0) {
                                var0 = null;
                            }
                            WorkSourceUtil.zzb = var0;
                            if (PlatformVersion.isAtLeastJellyBeanMR2()) {
                                var0 = new Class[]{Integer.TYPE, String.class};
                                var0 = WorkSource.class.getMethod("add", (Class<?>)var0);
                                ** GOTO lbl18
                            } else {
                                var0 = null;
                            }
                            break block29;
                            catch (Exception v1) {
                                var0 = null;
                            }
                        }
                        WorkSourceUtil.zzc = var0;
                        try {
                            var0 = WorkSource.class.getMethod("size", new Class[0]);
                        }
                        catch (Exception v2) {
                            var0 = null;
                        }
                        WorkSourceUtil.zzd = var0;
                        try {
                            var0 = new Class[]{Integer.TYPE};
                            var0 = WorkSource.class.getMethod("get", (Class<?>)var0);
                        }
                        catch (Exception v3) {
                            var0 = null;
                        }
                        WorkSourceUtil.zze = var0;
                        if (PlatformVersion.isAtLeastJellyBeanMR2()) {
                            var0 = new Class[]{Integer.TYPE};
                            var0 = WorkSource.class.getMethod("getName", (Class<?>)var0);
                            ** GOTO lbl42
                        } else {
                            var0 = null;
                        }
                        break block30;
                        catch (Exception v4) {
                            var0 = null;
                        }
                    }
                    WorkSourceUtil.zzf = var0;
                    if (PlatformVersion.isAtLeastP()) {
                        var0 = WorkSource.class.getMethod("createWorkChain", new Class[0]);
                        ** GOTO lbl54
                    } else {
                        var0 = null;
                    }
                    break block31;
                    catch (Exception var0_1) {
                        Log.w((String)"WorkSourceUtil", (String)"Missing WorkChain API createWorkChain", (Throwable)var0_1);
                        var0 = null;
                    }
                }
                WorkSourceUtil.zzg = var0;
                if (PlatformVersion.isAtLeastP()) {
                    var0 = Class.forName("android.os.WorkSource$WorkChain");
                    var1_3 = new Class[]{Integer.TYPE, String.class};
                    var0 = var0.getMethod("addNode", var1_3);
                    ** GOTO lbl68
                } else {
                    var0 = null;
                }
                break block32;
                catch (Exception var0_2) {
                    Log.w((String)"WorkSourceUtil", (String)"Missing WorkChain class", (Throwable)var0_2);
                    var0 = null;
                }
            }
            WorkSourceUtil.zzh = var0;
            if (PlatformVersion.isAtLeastP()) {
                var0 = WorkSource.class.getMethod("isEmpty", new Class[0]);
                var0.setAccessible(true);
                ** GOTO lbl82
            } else {
                var0 = null;
            }
            break block28;
            catch (Exception v5) {
                var0 = null;
                break block28;
            }
            catch (Exception v6) {}
        }
        WorkSourceUtil.zzi = var0;
    }

    private WorkSourceUtil() {
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @KeepForSdk
    public static void add(@NonNull WorkSource workSource, int uid, @NonNull String packageName) {
        WorkSource workSource2;
        void var1_3;
        Object object;
        Object[] objectArray = zzc;
        if (objectArray != null) {
            if (object == null) {
                object = "";
            }
            Object[] objectArray2 = new Object[]{(int)var1_3, object};
            objectArray.invoke((Object)workSource2, objectArray2);
            return;
        }
        object = zzb;
        if (object == null) return;
        try {
            objectArray = new Object[]{(int)var1_3};
            ((Method)object).invoke((Object)workSource2, objectArray);
            return;
        }
        catch (Exception exception) {
            Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            return;
        }
        catch (Exception exception) {
            Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            return;
        }
    }

    @KeepForSdk
    public static boolean hasWorkSourcePermission(@NonNull Context context) {
        Context context2;
        if (context == null) {
            return false;
        }
        if (context2.getPackageManager() == null) {
            return false;
        }
        return Wrappers.packageManager(context2).checkPermission("android.permission.UPDATE_DEVICE_STATS", context2.getPackageName()) == 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    public static boolean isEmpty(@NonNull WorkSource workSource) {
        WorkSource workSource2;
        Object object = zzi;
        if (object != null) {
            try {
                object = ((Method)object).invoke((Object)workSource2, new Object[0]);
                Preconditions.checkNotNull(object);
                return (Boolean)object;
            }
            catch (Exception exception) {
                Log.e((String)"WorkSourceUtil", (String)"Unable to check WorkSource emptiness", (Throwable)exception);
            }
        }
        if (WorkSourceUtil.zza(workSource2) != 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int zza(@NonNull WorkSource object) {
        Method method = zzd;
        if (method == null) return 0;
        try {
            Object object2 = method.invoke(object, new Object[0]);
            Preconditions.checkNotNull(object2);
            return (Integer)object2;
        }
        catch (Exception exception) {
            Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            return 0;
        }
    }
}

