/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;

public abstract class ResultCallbacks<R extends Result>
implements ResultCallback<R> {
    public abstract void onFailure(@NonNull Status var1);

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @KeepForSdk
    public final void onResult(@NonNull R result) {
        void var1_2;
        Status status = result.getStatus();
        if (status.isSuccess()) {
            this.onSuccess(var1_2);
            return;
        }
        this.onFailure(status);
        if (!(var1_2 instanceof Releasable)) return;
        try {
            ((Releasable)var1_2).release();
            return;
        }
        catch (RuntimeException runtimeException) {
            Log.w((String)"ResultCallbacks", (String)"Unable to release ".concat(String.valueOf(String.valueOf(var1_2))), (Throwable)runtimeException);
            return;
        }
    }

    public abstract void onSuccess(@NonNull R var1);
}

