/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.security;

import android.content.Context;
import android.content.Intent;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.security.zza;
import java.lang.reflect.Method;

public class ProviderInstaller {
    @NonNull
    public static final String PROVIDER_NAME = "GmsCore_OpenSSL";
    private static final GoogleApiAvailabilityLight zza;
    private static final Object zzb;
    @GuardedBy(value="ProviderInstaller.lock")
    private static Method zzc;
    @GuardedBy(value="ProviderInstaller.lock")
    private static Method zzd;

    static {
        Object object;
        zza = GoogleApiAvailabilityLight.getInstance();
        zzb = object = new Object();
        zzc = null;
        zzd = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void installIfNeeded(@NonNull Context context) throws GooglePlayServicesRepairableException, GooglePlayServicesNotAvailableException {
        Object object;
        Preconditions.checkNotNull(context, "Context must not be null");
        zza.verifyGooglePlayServicesIsAvailable((Context)object, 11925000);
        Object object2 = zzb;
        synchronized (object2) {
            DynamiteModule dynamiteModule;
            block10: {
                block9: {
                    long l = SystemClock.elapsedRealtime();
                    try {
                        dynamiteModule = DynamiteModule.load(object, DynamiteModule.PREFER_HIGHEST_OR_LOCAL_VERSION_NO_FORCE_STAGING, "com.google.android.gms.providerinstaller.dynamite");
                        dynamiteModule = dynamiteModule.getModuleContext();
                    }
                    catch (DynamiteModule.LoadingException loadingException) {
                        Log.w((String)"ProviderInstaller", (String)"Failed to load providerinstaller module: ".concat(String.valueOf(loadingException.getMessage())));
                        dynamiteModule = null;
                    }
                    if (dynamiteModule != null) break block9;
                    long l2 = SystemClock.elapsedRealtime();
                    dynamiteModule = GooglePlayServicesUtilLight.getRemoteContext(object);
                    if (dynamiteModule == null) break block10;
                    try {
                        Class[] classArray = zzd;
                        if (classArray == null) {
                            classArray = new Class[]{Context.class, Long.TYPE, Long.TYPE};
                            zzd = ProviderInstaller.zzb((Context)dynamiteModule, "com.google.android.gms.common.security.ProviderInstallerImpl", "reportRequestStats", classArray);
                        }
                        classArray = zzd;
                        Object[] objectArray = new Object[]{object, l, l2};
                        classArray.invoke(null, objectArray);
                    }
                    catch (Exception exception) {
                        Log.w((String)"ProviderInstaller", (String)"Failed to report request stats: ".concat(String.valueOf(exception.getMessage())));
                    }
                }
                ProviderInstaller.zzc((Context)dynamiteModule, object, "com.google.android.gms.providerinstaller.ProviderInstallerImpl");
                return;
            }
            if (dynamiteModule != null) {
                ProviderInstaller.zzc((Context)dynamiteModule, object, "com.google.android.gms.common.security.ProviderInstallerImpl");
                return;
            }
            Log.e((String)"ProviderInstaller", (String)"Failed to get remote context");
            object = new GooglePlayServicesNotAvailableException(8);
            throw object;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void installIfNeededAsync(@NonNull Context context, @NonNull ProviderInstallListener listener) {
        Context context2;
        void var1_1;
        Preconditions.checkNotNull(context, "Context must not be null");
        Preconditions.checkNotNull(var1_1, "Listener must not be null");
        Preconditions.checkMainThread("Must be called on the UI thread");
        zza zza2 = new zza(context2, (ProviderInstallListener)var1_1);
        zza2.execute(new Void[0]);
    }

    static /* bridge */ /* synthetic */ GoogleApiAvailabilityLight zza() {
        return zza;
    }

    private static Method zzb(Context context, String string2, String string3, Class[] classArray) throws ClassNotFoundException, NoSuchMethodException {
        return context.getClassLoader().loadClass(string2).getMethod(string3, classArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GuardedBy(value="ProviderInstaller.lock")
    private static void zzc(Context context, Context object, String objectArray) throws GooglePlayServicesNotAvailableException {
        try {
            object = zzc;
            if (object == null) {
                object = new Class[]{Context.class};
                zzc = ProviderInstaller.zzb(context, (String)objectArray, "insertProvider", (Class[])object);
            }
            object = zzc;
            objectArray = new Object[]{context};
            ((Method)object).invoke(null, objectArray);
            return;
        }
        catch (Exception exception) {
            Object object2;
            object = exception.getCause();
            if (Log.isLoggable((String)"ProviderInstaller", (int)6)) {
                object2 = object == null ? exception.getMessage() : ((Throwable)object).getMessage();
                Log.e((String)"ProviderInstaller", (String)"Failed to install provider: ".concat(String.valueOf(object2)));
            }
            object2 = new GooglePlayServicesNotAvailableException(8);
            throw object2;
        }
    }

    public static interface ProviderInstallListener {
        public void onProviderInstallFailed(int var1, @Nullable Intent var2);

        public void onProviderInstalled();
    }
}

