/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.google.android.gms.common.api.internal.LifecycleCallback;
import com.google.android.gms.common.api.internal.LifecycleFragment;
import com.google.android.gms.common.api.internal.zzc;
import com.google.android.gms.internal.common.zzi;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public final class zzd
extends Fragment
implements LifecycleFragment {
    private static final WeakHashMap zza = new WeakHashMap();
    private final Map zzb = Collections.synchronizedMap(new ArrayMap());
    private int zzc = 0;
    @Nullable
    private Bundle zzd;

    static /* bridge */ /* synthetic */ int zza(zzd zzd2) {
        return zzd2.zzc;
    }

    @Override
    @Nullable
    public final /* synthetic */ Activity getLifecycleActivity() {
        return this.getActivity();
    }

    static /* bridge */ /* synthetic */ Bundle zzb(zzd zzd2) {
        return zzd2.zzd;
    }

    @Override
    @Nullable
    public final <T extends LifecycleCallback> T getCallbackOrNull(String string2, Class<T> clazz) {
        return (T)((LifecycleCallback)clazz.cast(this.zzb.get(string2)));
    }

    public static zzd zzc(FragmentActivity fragmentActivity) {
        Object object = (WeakReference)zza.get(fragmentActivity);
        if (object == null || (object = (zzd)((Reference)object).get()) == null) {
            try {
                object = (zzd)fragmentActivity.getSupportFragmentManager().findFragmentByTag("SupportLifecycleFragmentImpl");
            }
            catch (ClassCastException classCastException) {
                throw new IllegalStateException("Fragment with tag SupportLifecycleFragmentImpl is not a SupportLifecycleFragmentImpl", classCastException);
            }
            if (object == null || object.isRemoving()) {
                object = new zzd();
                fragmentActivity.getSupportFragmentManager().beginTransaction().add((Fragment)object, "SupportLifecycleFragmentImpl").commitAllowingStateLoss();
            }
            zza.put(fragmentActivity, new WeakReference<Object>(object));
            return object;
        }
        return object;
    }

    @Override
    public final void addCallback(String string2, @NonNull LifecycleCallback lifecycleCallback) {
        if (!this.zzb.containsKey(string2)) {
            this.zzb.put(string2, lifecycleCallback);
            if (this.zzc > 0) {
                new zzi(Looper.getMainLooper()).post(new zzc(this, lifecycleCallback, string2));
                return;
            }
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("LifecycleCallback with tag ");
            stringBuilder.append(string2);
            stringBuilder.append(" already added to this fragment.");
            throw new IllegalArgumentException(stringBuilder.toString());
        }
    }

    public final void dump(String string2, @Nullable FileDescriptor fileDescriptor, PrintWriter printWriter, @Nullable String[] stringArray) {
        super.dump(string2, fileDescriptor, printWriter, stringArray);
        Iterator iterator = ((zzd)((Object)iterator)).zzb.values().iterator();
        while (iterator.hasNext()) {
            ((LifecycleCallback)iterator.next()).dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }

    public final void onActivityResult(int n, int n2, @Nullable Intent intent) {
        super.onActivityResult(n, n2, intent);
        Iterator iterator = ((zzd)((Object)iterator)).zzb.values().iterator();
        while (iterator.hasNext()) {
            ((LifecycleCallback)iterator.next()).onActivityResult(n, n2, intent);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public final void onCreate(@Nullable Bundle bundle) {
        void var1_6;
        super.onCreate((Bundle)var1_6);
        this.zzc = 1;
        this.zzd = var1_6;
        Iterator iterator = this.zzb.entrySet().iterator();
        while (iterator.hasNext()) {
            void var0_4;
            Map.Entry entry = iterator.next();
            LifecycleCallback lifecycleCallback = (LifecycleCallback)entry.getValue();
            if (var1_6 != null) {
                Bundle bundle2 = var1_6.getBundle((String)entry.getKey());
            } else {
                Object var0_5 = null;
            }
            lifecycleCallback.onCreate((Bundle)var0_4);
        }
        return;
    }

    public final void onDestroy() {
        super.onDestroy();
        ((zzd)((Object)iterator)).zzc = 5;
        Iterator iterator = ((zzd)((Object)iterator)).zzb.values().iterator();
        while (iterator.hasNext()) {
            ((LifecycleCallback)iterator.next()).onDestroy();
        }
    }

    public final void onResume() {
        super.onResume();
        ((zzd)((Object)iterator)).zzc = 3;
        Iterator iterator = ((zzd)((Object)iterator)).zzb.values().iterator();
        while (iterator.hasNext()) {
            ((LifecycleCallback)iterator.next()).onResume();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        if (bundle != null) {
            for (Map.Entry entry : ((zzd)this).zzb.entrySet()) {
                Bundle bundle2 = new Bundle();
                ((LifecycleCallback)entry.getValue()).onSaveInstanceState(bundle2);
                bundle.putBundle((String)entry.getKey(), bundle2);
            }
        }
    }

    public final void onStart() {
        super.onStart();
        ((zzd)((Object)iterator)).zzc = 2;
        Iterator iterator = ((zzd)((Object)iterator)).zzb.values().iterator();
        while (iterator.hasNext()) {
            ((LifecycleCallback)iterator.next()).onStart();
        }
    }

    public final void onStop() {
        super.onStop();
        ((zzd)((Object)iterator)).zzc = 4;
        Iterator iterator = ((zzd)((Object)iterator)).zzb.values().iterator();
        while (iterator.hasNext()) {
            ((LifecycleCallback)iterator.next()).onStop();
        }
    }

    @Override
    public final boolean isCreated() {
        return this.zzc > 0;
    }

    @Override
    public final boolean isStarted() {
        return this.zzc >= 2;
    }
}

