/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import androidx.collection.ArraySet;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.errorprone.annotations.InlineMe;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@KeepForSdk
public final class CollectionUtils {
    @Deprecated
    @InlineMe(replacement="Collections.emptyList()", imports={"java.util.Collections"})
    @KeepForSdk
    @NonNull
    public static <T> List<T> listOf() {
        return Collections.emptyList();
    }

    @Deprecated
    @InlineMe(replacement="Collections.singletonList(item)", imports={"java.util.Collections"})
    @KeepForSdk
    @NonNull
    public static <T> List<T> listOf(@NonNull T item) {
        return Collections.singletonList(item);
    }

    @Deprecated
    @KeepForSdk
    @NonNull
    public static <T> List<T> listOf(T ... items) {
        switch (items.length) {
            default: {
                T[] TArray;
                return Collections.unmodifiableList(Arrays.asList(TArray));
            }
            case 1: {
                T[] TArray;
                return Collections.singletonList(TArray[0]);
            }
            case 0: 
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public static <K, V> Map<K, V> mapOf(@NonNull K key1, @NonNull V value1, @NonNull K key2, @NonNull V value2, @NonNull K key3, @NonNull V value3) {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        K k;
        Map map = CollectionUtils.zza(3, false);
        map.put(k, var1_1);
        map.put(var2_2, var3_3);
        map.put(var4_4, var5_5);
        return Collections.unmodifiableMap(map);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public static <K, V> Map<K, V> mapOf(@NonNull K key1, @NonNull V value1, @NonNull K key2, @NonNull V value2, @NonNull K key3, @NonNull V value3, @NonNull K key4, @NonNull V value4, @NonNull K key5, @NonNull V value5, @NonNull K key6, @NonNull V value6) {
        void var11_11;
        void var10_10;
        void var9_9;
        void var8_8;
        void var7_7;
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        K k;
        Map map = CollectionUtils.zza(6, false);
        map.put(k, var1_1);
        map.put(var2_2, var3_3);
        map.put(var4_4, var5_5);
        map.put(var6_6, var7_7);
        map.put(var8_8, var9_9);
        map.put(var10_10, var11_11);
        return Collections.unmodifiableMap(map);
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    @NonNull
    public static <K, V> Map<K, V> mapOfKeyValueArrays(@NonNull K[] keys, @NonNull V[] values) {
        void var1_1;
        int n = keys.length;
        int n2 = ((void)var1_1).length;
        if (n == n2) {
            switch (n) {
                default: {
                    K[] KArray;
                    Map map = CollectionUtils.zza(n, false);
                    for (n = 0; n < KArray.length; ++n) {
                        map.put(KArray[n], var1_1[n]);
                    }
                    return Collections.unmodifiableMap(map);
                }
                case 0: {
                    return Collections.emptyMap();
                }
                case 1: {
                    K[] KArray;
                    return Collections.singletonMap(KArray[0], var1_1[0]);
                }
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Key and values array lengths not equal: ");
        stringBuilder.append(n);
        stringBuilder.append(" != ");
        stringBuilder.append(n2);
        throw new IllegalArgumentException(stringBuilder.toString());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @KeepForSdk
    @NonNull
    public static <T> Set<T> mutableSetOfWithSize(int sizeEstimate) {
        int n;
        void var0_2;
        if (sizeEstimate == 0) {
            ArraySet arraySet = new ArraySet();
            return var0_2;
        }
        Set set = CollectionUtils.zzb(n, true);
        return var0_2;
    }

    @Deprecated
    @KeepForSdk
    @NonNull
    public static <T> Set<T> setOf(T ... items) {
        int n = items.length;
        switch (n) {
            default: {
                Object object;
                Set set = CollectionUtils.zzb(n, false);
                Collections.addAll(set, object);
                return Collections.unmodifiableSet(set);
            }
            case 4: {
                Set set;
                Object object;
                T t = object[0];
                T t2 = object[1];
                T t3 = object[2];
                object = object[3];
                Set set2 = set = CollectionUtils.zzb(4, false);
                set2.add(t);
                set2.add(t2);
                set2.add(t3);
                set.add(object);
                return Collections.unmodifiableSet(set);
            }
            case 3: {
                Object object;
                return CollectionUtils.setOf(object[0], object[1], object[2]);
            }
            case 2: {
                Object object;
                T t = object[0];
                Set set = CollectionUtils.zzb(2, false);
                set.add(t);
                set.add(object[1]);
                return Collections.unmodifiableSet(set);
            }
            case 1: {
                Object object;
                return Collections.singleton(object[0]);
            }
            case 0: 
        }
        return Collections.emptySet();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @KeepForSdk
    @NonNull
    public static <T> Set<T> setOf(@NonNull T item1, @NonNull T item2, @NonNull T item3) {
        void var2_2;
        void var1_1;
        T t;
        Set set = CollectionUtils.zzb(3, false);
        set.add(t);
        set.add(var1_1);
        set.add(var2_2);
        return Collections.unmodifiableSet(set);
    }

    private CollectionUtils() {
    }

    @KeepForSdk
    public static boolean isEmpty(@Nullable Collection<?> collection) {
        Collection<?> collection2;
        if (collection == null) {
            return true;
        }
        return collection2.isEmpty();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map zza(int n, boolean bl) {
        void var0_2;
        if (n <= 256) {
            ArrayMap arrayMap = new ArrayMap(n);
            return var0_2;
        }
        HashMap hashMap = new HashMap(n, 1.0f);
        return var0_2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static Set zzb(int n, boolean bl) {
        void var0_2;
        void var1_4;
        int n2 = true != var1_4 ? 256 : 128;
        if (n <= n2) {
            ArraySet arraySet = new ArraySet(n);
            return var0_2;
        }
        float f = true != var1_4 ? 1.0f : 0.75f;
        HashSet hashSet = new HashSet(n, f);
        return var0_2;
    }
}

