/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.zzc;

@SafeParcelable.Class(creator="FeatureCreator")
@KeepForSdk
public class Feature
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<Feature> CREATOR = new zzc();
    @SafeParcelable.Field(id=1, getter="getName")
    private final String zza;
    @Deprecated
    @SafeParcelable.Field(id=2, getter="getOldVersion")
    private final int zzb;
    @SafeParcelable.Field(id=3, getter="getVersion", defaultValue="-1")
    private final long zzc;

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public Feature(@NonNull String name, long version) {
        void var2_2;
        void var1_1;
        this.zza = var1_1;
        this.zzc = var2_2;
        this.zzb = -1;
    }

    @SafeParcelable.Constructor
    public Feature(@SafeParcelable.Param(id=1) @NonNull String string, @SafeParcelable.Param(id=2) int n, @SafeParcelable.Param(id=3) long l) {
        this.zza = string;
        this.zzb = n;
        this.zzc = l;
    }

    @KeepForSdk
    @NonNull
    public String getName() {
        return this.zza;
    }

    @KeepForSdk
    public long getVersion() {
        long l = this.zzc;
        if (l == -1L) {
            return this.zzb;
        }
        return l;
    }

    public final void writeToParcel(@NonNull Parcel parcel, int n) {
        int n2 = SafeParcelWriter.beginObjectHeader(parcel);
        SafeParcelWriter.writeString(parcel, 1, this.getName(), false);
        SafeParcelWriter.writeInt(parcel, 2, this.zzb);
        Parcel parcel2 = parcel;
        SafeParcelWriter.writeLong(parcel2, 3, this.getVersion());
        SafeParcelWriter.finishObjectHeader(parcel2, n2);
    }

    public final boolean equals(@Nullable Object object) {
        if (object instanceof Feature) {
            object = (Feature)object;
            return (this.getName() != null && this.getName().equals(((Feature)object).getName()) || this.getName() == null && ((Feature)object).getName() == null) && this.getVersion() == ((Feature)object).getVersion();
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode(this.getName(), this.getVersion());
    }

    @NonNull
    public final String toString() {
        Objects.ToStringHelper toStringHelper = Objects.toStringHelper(l);
        toStringHelper.add("name", ((Feature)((Object)l)).getName());
        Long l = ((Feature)((Object)l)).getVersion();
        toStringHelper.add("version", l);
        return toStringHelper.toString();
    }
}

