/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.content.Context;
import android.os.RemoteException;
import android.os.StrictMode;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.PackageVerificationResult;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.common.signatureverification.SignatureVerificationConfigurationProvider;
import com.google.android.gms.common.zzac;
import com.google.android.gms.common.zzad;
import com.google.android.gms.common.zzae;
import com.google.android.gms.common.zzo;
import com.google.android.gms.common.zzv;
import com.google.android.gms.common.zzy;
import com.google.android.gms.dynamite.DynamiteModule;

@ShowFirstParty
@KeepForSdk
public class PackageSignatureVerifier {
    @Nullable
    private static zzad zzb;
    @VisibleForTesting
    @Nullable
    static volatile zzac zza;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ShowFirstParty
    @KeepForSdk
    @NonNull
    public PackageVerificationResult queryPackageSignatureVerified(@NonNull Context context, @NonNull String callingPackage) {
        block7: {
            void var2_3;
            boolean bl;
            Object object;
            boolean bl2 = GooglePlayServicesUtilLight.honorsDebugCertificates(context);
            PackageSignatureVerifier.zza((Context)object);
            Object object2 = StrictMode.allowThreadDiskReads();
            try {
                zzo.zzb();
                bl = zzo.zzg.zzi();
            }
            catch (RemoteException | DynamiteModule.LoadingException throwable) {
                try {
                    Log.e((String)"GoogleCertificates", (String)"Failed to get Google certificates from remote", (Throwable)throwable);
                    break block7;
                }
                catch (Throwable throwable2) {
                    StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)object2);
                    throw throwable2;
                }
            }
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)object2);
            if (!bl) {
                throw new zzae();
            }
            SignatureVerificationConfigurationProvider.zza().zza();
            String.valueOf(var2_3);
            String string2 = String.valueOf(var2_3);
            object2 = true != bl2 ? "-0" : "-1";
            object2 = string2.concat((String)object2);
            if (zza != null && zza.zza().equals(object2)) {
                return zza.zzb();
            }
            PackageSignatureVerifier.zza((Context)object);
            zzv zzv2 = new zzv(null);
            zzv2.zza((String)var2_3);
            zzv2.zzb(bl2);
            zzv2.zzc(false);
            object = zzo.zzc(zzv2.zzd());
            if (((zzy)object).zza) {
                object = PackageVerificationResult.zzd((String)var2_3, ((zzy)object).zzd, null);
                zza = new zzac((String)object2, (PackageVerificationResult)object);
                return object;
            }
            String string3 = ((zzy)object).zzb;
            Preconditions.checkNotNull(string3);
            return PackageVerificationResult.zza((String)var2_3, string3, ((zzy)object).zzc, null);
        }
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)object2);
        throw new zzae();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @ShowFirstParty
    @KeepForSdk
    @NonNull
    public PackageVerificationResult queryPackageSignatureVerifiedWithRetry(@NonNull Context context, @NonNull String callingPackage) {
        void var2_2;
        void var1_1;
        try {
            PackageVerificationResult packageVerificationResult = ((PackageSignatureVerifier)this).queryPackageSignatureVerified((Context)var1_1, (String)var2_2);
            packageVerificationResult.zzc();
            return packageVerificationResult;
        }
        catch (SecurityException securityException) {
            if (!((PackageVerificationResult)(this = ((PackageSignatureVerifier)this).queryPackageSignatureVerified((Context)var1_1, (String)var2_2))).zzb()) return this;
            Log.e((String)"PkgSignatureVerifier", (String)"Got flaky result during package signature verification", (Throwable)securityException);
            return this;
        }
    }

    private static synchronized zzad zza(Context context) {
        if (zzb == null) {
            zzb = new zzad(context);
        }
        return zzb;
    }
}

