/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.ComplianceOptions;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;

@KeepForSdk
@SafeParcelable.Class(creator="ApiMetadataCreator")
public final class ApiMetadata
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<ApiMetadata> CREATOR = com.google.android.gms.common.api.zza.zza();
    private static final ApiMetadata zzb = ApiMetadata.newBuilder().build();
    @NonNull
    public static final ApiMetadata zza;
    @SafeParcelable.Field(id=1, getter="getComplianceOptions")
    @Nullable
    private final ComplianceOptions zzc;
    private boolean zzd;

    @SafeParcelable.Constructor
    ApiMetadata(@Nullable @SafeParcelable.Param(id=1) ComplianceOptions complianceOptions) {
        this.zzc = complianceOptions;
    }

    public final void writeToParcel(@NonNull Parcel parcel, int n) {
        if (this.zzd) {
            Parcel parcel2 = parcel;
            parcel2.setDataPosition(parcel2.dataPosition() + -4);
            Parcel parcel3 = parcel;
            parcel3.setDataSize(parcel3.dataSize() + -4);
            return;
        }
        parcel.writeInt(-204102970);
        Parcel parcel4 = parcel;
        SafeParcelWriter.writeParcelable(parcel4, 1, this.zzc, n, false);
        SafeParcelWriter.finishObjectHeader(parcel4, SafeParcelWriter.beginObjectHeader(parcel));
    }

    public final int hashCode() {
        ComplianceOptions complianceOptions = this.zzc;
        return Objects.hashCode(complianceOptions, this.zzd);
    }

    public final boolean equals(@Nullable Object object) {
        if (!(object instanceof ApiMetadata)) {
            return false;
        }
        object = (ApiMetadata)object;
        return Objects.equal(this.zzc, ((ApiMetadata)object).zzc) && this.zzd == ((ApiMetadata)object).zzd;
    }

    @NonNull
    public final String toString() {
        String string2 = String.valueOf(this.zzc);
        int n = String.valueOf(string2).length();
        StringBuilder stringBuilder = new StringBuilder(n + 31);
        stringBuilder.append("ApiMetadata(complianceOptions=");
        stringBuilder.append(string2);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    @KeepForSdk
    @NonNull
    public static final ApiMetadata getEmptyInstance() {
        return zzb;
    }

    @KeepForSdk
    @NonNull
    public static Builder newBuilder() {
        return new Builder();
    }

    @KeepForSdk
    @NonNull
    public static final ApiMetadata fromComplianceOptions(@NonNull ComplianceOptions options) {
        ComplianceOptions complianceOptions;
        Builder builder = ApiMetadata.newBuilder();
        builder.setComplianceOptions(complianceOptions);
        return builder.build();
    }

    static {
        Builder builder = ApiMetadata.newBuilder();
        builder.zza(true);
        zza = builder.build();
    }

    final /* synthetic */ void zza(boolean bl) {
        this.zzd = bl;
    }

    @KeepForSdk
    public static final class Builder {
        @Nullable
        private ComplianceOptions zza;
        private boolean zzb;

        /*
         * WARNING - void declaration
         */
        @KeepForSdk
        @NonNull
        public Builder setComplianceOptions(@Nullable ComplianceOptions complianceOptions) {
            void var1_1;
            this.zza = var1_1;
            return this;
        }

        @KeepForSdk
        @NonNull
        public ApiMetadata build() {
            ApiMetadata apiMetadata = new ApiMetadata(this.zza);
            apiMetadata.zza(this.zzb);
            return apiMetadata;
        }

        final /* synthetic */ Builder zza(boolean bl) {
            this.zzb = true;
            return this;
        }
    }
}

