/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import javax.annotation.Nullable;

@KeepForSdk
public final class Asserts {
    @KeepForSdk
    public static void checkNull(@Nullable Object reference) {
        if (reference != null) {
            throw new IllegalArgumentException("non-null reference");
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public static void checkNull(@Nullable Object reference, @NonNull Object errorMessage) {
        if (reference != null) {
            void var1_1;
            throw new IllegalArgumentException(String.valueOf(var1_1));
        }
    }

    @KeepForSdk
    public static void checkNotNull(@Nullable Object reference) {
        if (reference == null) {
            throw new IllegalArgumentException("null reference");
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public static void checkNotNull(@Nullable Object reference, @NonNull Object errorMessage) {
        if (reference == null) {
            void var1_1;
            throw new IllegalArgumentException(String.valueOf(var1_1));
        }
    }

    @KeepForSdk
    public static void checkState(boolean expression) {
        if (!expression) {
            throw new IllegalStateException();
        }
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public static void checkState(boolean expression, @NonNull Object errorMessage) {
        if (!expression) {
            void var1_1;
            throw new IllegalStateException(String.valueOf(var1_1));
        }
    }

    @KeepForSdk
    public static void checkMainThread(@NonNull String errorMessage) {
        if (Looper.getMainLooper().getThread() != Thread.currentThread()) {
            String string2;
            String string3 = String.valueOf(Thread.currentThread());
            String string4 = String.valueOf(Looper.getMainLooper().getThread());
            String string5 = String.valueOf(string4);
            int n = String.valueOf(string3).length() + 56 + string5.length();
            StringBuilder stringBuilder = new StringBuilder(n + 1);
            stringBuilder.append("checkMainThread: current thread ");
            stringBuilder.append(string3);
            stringBuilder.append(" IS NOT the main thread ");
            stringBuilder.append(string4);
            stringBuilder.append("!");
            string4 = stringBuilder.toString();
            Log.e((String)"Asserts", (String)string4);
            throw new IllegalStateException(string2);
        }
    }

    @KeepForSdk
    public static void checkNotMainThread(@NonNull String errorMessage) {
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            String string2;
            String string3 = String.valueOf(Thread.currentThread());
            String string4 = String.valueOf(Looper.getMainLooper().getThread());
            String string5 = String.valueOf(string4);
            int n = String.valueOf(string3).length() + 55 + string5.length();
            StringBuilder stringBuilder = new StringBuilder(n + 1);
            stringBuilder.append("checkNotMainThread: current thread ");
            stringBuilder.append(string3);
            stringBuilder.append(" IS the main thread ");
            stringBuilder.append(string4);
            stringBuilder.append("!");
            string4 = stringBuilder.toString();
            Log.e((String)"Asserts", (String)string4);
            throw new IllegalStateException(string2);
        }
    }

    private Asserts() {
        throw new AssertionError((Object)"Uninstantiable");
    }
}

