/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dynamic;

import android.os.IBinder;
import androidx.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.RetainForClient;
import com.google.android.gms.dynamic.IObjectWrapper;
import java.lang.reflect.Field;

@KeepForSdk
@RetainForClient
public final class ObjectWrapper<T>
extends IObjectWrapper.Stub {
    private final Object zza;

    private ObjectWrapper(Object object) {
        this.zza = object;
    }

    @KeepForSdk
    @NonNull
    public static <T> IObjectWrapper wrap(@NonNull T object) {
        T t;
        return new ObjectWrapper<T>(t);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @KeepForSdk
    @NonNull
    public static <T> T unwrap(@NonNull IObjectWrapper remote) {
        Object object;
        if (remote instanceof ObjectWrapper) {
            return (T)((ObjectWrapper)object).zza;
        }
        IBinder iBinder = object.asBinder();
        Field[] fieldArray = iBinder.getClass().getDeclaredFields();
        int n = fieldArray.length;
        object = null;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Field field = fieldArray[i];
            if (field.isSynthetic()) continue;
            object = field;
            ++n2;
        }
        if (n2 != 1) {
            int n3 = fieldArray.length;
            int n4 = String.valueOf(n3).length();
            StringBuilder stringBuilder = new StringBuilder(n4 + 53);
            stringBuilder.append("Unexpected number of IObjectWrapper declared fields: ");
            stringBuilder.append(n3);
            throw new IllegalArgumentException(stringBuilder.toString());
        }
        Preconditions.checkNotNull(object);
        if (((Field)object).isAccessible()) throw new IllegalArgumentException("IObjectWrapper declared field not private!");
        ((Field)object).setAccessible(true);
        try {
            object = ((Field)object).get(iBinder);
            return (T)object;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Could not access the field in remoteBinder.", illegalAccessException);
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalArgumentException("Binder object is null.", nullPointerException);
        }
    }
}

