/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.util;

import androidx.annotation.NonNull;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.internal.common.zzp;
import com.google.android.gms.internal.common.zzw;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;

@KeepForSdk
public class HttpUtils {
    private static final Pattern zza = Pattern.compile("^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$");
    private static final Pattern zzb = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
    private static final Pattern zzc = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$");

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @KeepForSdk
    @NonNull
    public static Map<String, String> parse(@NonNull URI uri, @NonNull String encoding) {
        Object object;
        HashMap<String, Object> hashMap = Collections.emptyMap();
        if ((object = ((URI)object).getRawQuery()) == null) {
            return hashMap;
        }
        if (((String)object).length() <= 0) {
            return hashMap;
        }
        hashMap = new HashMap<String, Object>();
        zzw zzw2 = zzw.zza(zzp.zzb('='));
        Iterator iterator = zzw.zza(zzp.zzb('&')).zzb().zzc((CharSequence)object).iterator();
        while (iterator.hasNext()) {
            void var1_1;
            object = zzw2.zzd((String)iterator.next());
            if (object.isEmpty()) throw new IllegalArgumentException("bad parameter");
            if (object.size() > 2) {
                throw new IllegalArgumentException("bad parameter");
            }
            String string2 = HttpUtils.zza((String)object.get(0), (String)var1_1);
            object = object.size() == 2 ? HttpUtils.zza((String)object.get(1), (String)var1_1) : null;
            hashMap.put(string2, object);
        }
        return hashMap;
    }

    private HttpUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String zza(String string2, String string3) {
        if (string3 != null) return URLDecoder.decode(string2, string3);
        try {
            string3 = "ISO-8859-1";
            return URLDecoder.decode(string2, string3);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(unsupportedEncodingException);
        }
    }
}

