/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.security;

import android.content.Context;
import android.content.Intent;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.common.zzh;
import com.google.android.gms.internal.common.zzi;
import com.google.android.gms.internal.common.zzj;
import com.google.android.gms.security.zza;
import java.lang.reflect.Method;

public class ProviderInstaller {
    @NonNull
    public static final String PROVIDER_NAME = "GmsCore_OpenSSL";
    private static final GoogleApiAvailabilityLight zza = GoogleApiAvailabilityLight.getInstance();
    private static final Object zzb = new Object();
    @GuardedBy(value="ProviderInstaller.lock")
    @Nullable
    private static Method zzc = null;
    @GuardedBy(value="ProviderInstaller.lock")
    private static boolean zzd = false;

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void installIfNeeded(@NonNull Context context) throws GooglePlayServicesRepairableException, GooglePlayServicesNotAvailableException {
        Preconditions.checkNotNull(context, "Context must not be null");
        ProviderInstaller.zza.verifyGooglePlayServicesIsAvailable(var0, 11925000);
        var2_1 = SystemClock.uptimeMillis();
        var4_2 = ProviderInstaller.zzb;
        synchronized (var4_2) {
            block15: {
                var1_3 = ProviderInstaller.zzd;
                if (!var1_3) {
                    var1_4 = "Failed to load providerinstaller module: ";
                    try {
                        var5_7 = DynamiteModule.load(var0, DynamiteModule.PREFER_HIGHEST_OR_LOCAL_VERSION_NO_FORCE_STAGING, "com.google.android.gms.providerinstaller.dynamite");
                        var1_4 = var5_7.getModuleContext();
                    }
                    catch (DynamiteModule.LoadingException var5_8) {
                        v0 = var5_8.getMessage();
                        String.valueOf(v0);
                        Log.w((String)"ProviderInstaller", (String)var1_4.concat(String.valueOf(v0)));
                        var1_4 = null;
                    }
                    if (var1_4 != null) {
                        ProviderInstaller.zzb((Context)var1_4, var0, "com.google.android.gms.providerinstaller.ProviderInstallerImpl");
                        return;
                    }
                }
                var1_3 = ProviderInstaller.zzd;
                var1_3 ^= true;
                var5_7 = "Failed to report request stats: ";
                var6_9 = GooglePlayServicesUtilLight.getRemoteContext(var0);
                if (var6_9 == null) {
                    var1_5 /* !! */  = null;
                } else {
                    ProviderInstaller.zzd = true;
                    if (var1_3) {
                        var7_10 = SystemClock.uptimeMillis();
                        var1_5 /* !! */  = "com.google.android.gms.common.security.ProviderInstallerImpl";
                        var9_11 = "reportRequestStats2";
                        var10_12 = var6_9.getClassLoader();
                        var11_13 = new zzi[3];
                        var12_14 = Context.class;
                        var11_13[0] = zzi.zzb(var12_14, var0);
                        var11_13[1] = zzh.zza(var2_1);
                        var11_13[2] = zzh.zza(var7_10);
                        zzj.zzb((String)var1_5 /* !! */ , var9_11, var10_12, var11_13);
                        var1_5 /* !! */  = var6_9;
                        ** GOTO lbl53
                    } else {
                        var1_5 /* !! */  = var6_9;
                    }
                }
                break block15;
                catch (Exception var1_6) {
                    Log.w((String)"ProviderInstaller", (String)var5_7.concat(var1_6.toString()));
                    var1_5 /* !! */  = var6_9;
                }
            }
            if (var1_5 /* !! */  != null) {
                ProviderInstaller.zzb(var1_5 /* !! */ , var0, "com.google.android.gms.common.security.ProviderInstallerImpl");
                return;
            }
            Log.e((String)"ProviderInstaller", (String)"Failed to get remote context");
            throw new GooglePlayServicesNotAvailableException(8);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void installIfNeededAsync(@NonNull Context context, @NonNull ProviderInstallListener listener) {
        Context context2;
        void var1_1;
        Preconditions.checkNotNull(context, "Context must not be null");
        Preconditions.checkNotNull(var1_1, "Listener must not be null");
        Preconditions.checkMainThread("Must be called on the UI thread");
        new zza(context2, (ProviderInstallListener)var1_1).execute(new Void[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GuardedBy(value="ProviderInstaller.lock")
    private static void zzb(Context context, Context object, String string2) throws GooglePlayServicesNotAvailableException {
        try {
            object = zzc;
            if (object == null) {
                object = new Class[]{Context.class};
                String string3 = "insertProvider";
                zzc = object = context.getClassLoader().loadClass(string2).getMethod(string3, (Class<?>)object);
            }
            zzc.invoke(null, context);
            return;
        }
        catch (Exception exception) {
            object = exception.getCause();
            if (Log.isLoggable((String)"ProviderInstaller", (int)6)) {
                String string4 = object == null ? exception.toString() : ((Throwable)object).toString();
                String.valueOf(string4);
                object = "Failed to install provider: ";
                string4 = String.valueOf(string4);
                Log.e((String)"ProviderInstaller", (String)((String)object).concat(string4));
            }
            throw new GooglePlayServicesNotAvailableException(8);
        }
    }

    static /* synthetic */ GoogleApiAvailabilityLight zza() {
        return zza;
    }

    public static interface ProviderInstallListener {
        public void onProviderInstalled();

        public void onProviderInstallFailed(int var1, @Nullable Intent var2);
    }
}

