/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.zzb;

@SafeParcelable.Class(creator="FeatureCreator")
@KeepForSdk
public class Feature
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<Feature> CREATOR = new zzb();
    @SafeParcelable.Field(id=1, getter="getName")
    private final String zza;
    @Deprecated
    @SafeParcelable.Field(id=2, getter="getOldVersion")
    private final int zzb;
    @SafeParcelable.Field(id=3, getter="getVersion", defaultValue="-1")
    private final long zzc;
    @SafeParcelable.Field(id=4, getter="getIsFullyRolledOut", defaultValue="false")
    private final boolean zzd;

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public Feature(@NonNull String name, long version) {
        this((String)var1_1, -1, (long)var2_2, false);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public Feature(@NonNull String name, int oldVersion, long version) {
        this((String)var1_1, (int)var2_2, (long)var3_3, false);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public Feature(@NonNull String name, long version, boolean isFullyRolledOut) {
        this((String)var1_1, -1, (long)var2_2, (boolean)var4_3);
        void var4_3;
        void var2_2;
        void var1_1;
    }

    @SafeParcelable.Constructor
    public Feature(@SafeParcelable.Param(id=1) @NonNull String string, @SafeParcelable.Param(id=2) int n, @SafeParcelable.Param(id=3) long l, @SafeParcelable.Param(id=4) boolean bl) {
        this.zza = string;
        this.zzb = n;
        this.zzc = l;
        this.zzd = bl;
    }

    @KeepForSdk
    @NonNull
    public String getName() {
        return this.zza;
    }

    @KeepForSdk
    public long getVersion() {
        long l = this.zzc;
        if (l == -1L) {
            return this.zzb;
        }
        return l;
    }

    @KeepForSdk
    public boolean getIsFullyRolledOut() {
        return this.zzd;
    }

    public final void writeToParcel(@NonNull Parcel parcel, int n) {
        int n2 = SafeParcelWriter.beginObjectHeader(parcel);
        SafeParcelWriter.writeString(parcel, 1, this.getName(), false);
        SafeParcelWriter.writeInt(parcel, 2, this.zzb);
        SafeParcelWriter.writeLong(parcel, 3, this.getVersion());
        Parcel parcel2 = parcel;
        SafeParcelWriter.writeBoolean(parcel2, 4, this.getIsFullyRolledOut());
        SafeParcelWriter.finishObjectHeader(parcel2, n2);
    }

    public final boolean equals(@Nullable Object object) {
        if (object instanceof Feature) {
            object = (Feature)object;
            return Objects.equal(this.getName(), ((Feature)object).getName()) && this.getVersion() == ((Feature)object).getVersion() && this.getIsFullyRolledOut() == ((Feature)object).getIsFullyRolledOut();
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode(this.getName(), this.getVersion(), this.getIsFullyRolledOut());
    }

    @NonNull
    public final String toString() {
        Objects.ToStringHelper toStringHelper = Objects.toStringHelper(bl);
        toStringHelper.add("name", ((Feature)((Object)bl)).getName());
        Long l = ((Feature)((Object)bl)).getVersion();
        toStringHelper.add("version", l);
        Boolean bl = ((Feature)((Object)bl)).getIsFullyRolledOut();
        toStringHelper.add("is_fully_rolled_out", bl);
        return toStringHelper.toString();
    }
}

