/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.auth.zza;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;

public class AccountChangeEvent
implements SafeParcelable {
    public static final Parcelable.Creator<AccountChangeEvent> CREATOR = new zza();
    final int mVersion;
    final long zzRr;
    final String zzRs;
    final int zzRt;
    final int zzRu;
    final String zzRv;

    AccountChangeEvent(int version, long id, String accountName, int changeType, int eventIndex, String changeData) {
        this.mVersion = version;
        this.zzRr = id;
        this.zzRs = zzx.zzw(accountName);
        this.zzRt = changeType;
        this.zzRu = eventIndex;
        this.zzRv = changeData;
    }

    public AccountChangeEvent(long id, String accountName, int changeType, int eventIndex, String changeData) {
        this.mVersion = 1;
        this.zzRr = id;
        this.zzRs = zzx.zzw(accountName);
        this.zzRt = changeType;
        this.zzRu = eventIndex;
        this.zzRv = changeData;
    }

    public String getAccountName() {
        return this.zzRs;
    }

    public int getChangeType() {
        return this.zzRt;
    }

    public int getEventIndex() {
        return this.zzRu;
    }

    public String getChangeData() {
        return this.zzRv;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zza.zza(this, dest, flags);
    }

    public String toString() {
        String string = "UNKNOWN";
        switch (this.zzRt) {
            case 1: {
                string = "ADDED";
                break;
            }
            case 2: {
                string = "REMOVED";
                break;
            }
            case 4: {
                string = "RENAMED_TO";
                break;
            }
            case 3: {
                string = "RENAMED_FROM";
            }
        }
        return "AccountChangeEvent {accountName = " + this.zzRs + ", changeType = " + string + ", changeData = " + this.zzRv + ", eventIndex = " + this.zzRu + "}";
    }

    public int hashCode() {
        return zzw.hashCode(this.mVersion, this.zzRr, this.zzRs, this.zzRt, this.zzRu, this.zzRv);
    }

    public boolean equals(Object that) {
        if (that == this) {
            return true;
        }
        if (that instanceof AccountChangeEvent) {
            AccountChangeEvent accountChangeEvent = (AccountChangeEvent)that;
            return this.mVersion == accountChangeEvent.mVersion && this.zzRr == accountChangeEvent.zzRr && zzw.equal(this.zzRs, accountChangeEvent.zzRs) && this.zzRt == accountChangeEvent.zzRt && this.zzRu == accountChangeEvent.zzRu && zzw.equal(this.zzRv, accountChangeEvent.zzRv);
        }
        return false;
    }
}

