/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.auth.AccountChangeEvent;
import com.google.android.gms.auth.AccountChangeEventsRequest;
import com.google.android.gms.auth.AccountChangeEventsResponse;
import com.google.android.gms.auth.GoogleAuthException;
import com.google.android.gms.auth.GooglePlayServicesAvailabilityException;
import com.google.android.gms.auth.TokenData;
import com.google.android.gms.auth.UserRecoverableAuthException;
import com.google.android.gms.auth.UserRecoverableNotifiedException;
import com.google.android.gms.auth.firstparty.shared.zzd;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.internal.zzl;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.common.zza;
import com.google.android.gms.internal.zzau;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;

public final class GoogleAuthUtil {
    public static final String GOOGLE_ACCOUNT_TYPE = "com.google";
    public static final String KEY_REQUEST_ACTIONS = "request_visible_actions";
    public static final String KEY_SUPPRESS_PROGRESS_SCREEN = "suppressProgressScreen";
    @Deprecated
    public static final String KEY_REQUEST_VISIBLE_ACTIVITIES = "request_visible_actions";
    public static final String KEY_CALLER_UID = Build.VERSION.SDK_INT >= 11 ? "callerUid" : "callerUid";
    public static final String KEY_ANDROID_PACKAGE_NAME = Build.VERSION.SDK_INT >= 14 ? "androidPackageName" : "androidPackageName";
    public static final int CHANGE_TYPE_ACCOUNT_ADDED = 1;
    public static final int CHANGE_TYPE_ACCOUNT_REMOVED = 2;
    public static final int CHANGE_TYPE_ACCOUNT_RENAMED_FROM = 3;
    public static final int CHANGE_TYPE_ACCOUNT_RENAMED_TO = 4;
    private static final ComponentName zzRw = new ComponentName("com.google.android.gms", "com.google.android.gms.auth.GetToken");
    private static final ComponentName zzRx = new ComponentName("com.google.android.gms", "com.google.android.gms.recovery.RecoveryService");

    @Deprecated
    public static String getToken(Context context, String accountName, String scope) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        Account account = new Account(accountName, GOOGLE_ACCOUNT_TYPE);
        return GoogleAuthUtil.getToken(context, account, scope);
    }

    @Deprecated
    public static String getToken(Context context, String accountName, String scope, Bundle extras) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        Account account = new Account(accountName, GOOGLE_ACCOUNT_TYPE);
        return GoogleAuthUtil.getToken(context, account, scope, extras);
    }

    public static String getToken(Context context, Account account, String scope) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        return GoogleAuthUtil.getToken(context, account, scope, new Bundle());
    }

    public static String getToken(Context context, Account account, String scope, Bundle extras) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        TokenData tokenData = GoogleAuthUtil.zza(context, account, scope, extras);
        return tokenData.getToken();
    }

    public static TokenData zza(Context context, Account account, String string, Bundle bundle) throws IOException, UserRecoverableAuthException, GoogleAuthException {
        Context context2 = context.getApplicationContext();
        zzx.zzcj("Calling this from your main thread can lead to deadlock");
        GoogleAuthUtil.zzaa(context2);
        bundle = bundle == null ? new Bundle() : new Bundle(bundle);
        String string2 = context.getApplicationInfo().packageName;
        bundle.putString("clientPackageName", string2);
        if (TextUtils.isEmpty((CharSequence)bundle.getString(KEY_ANDROID_PACKAGE_NAME))) {
            bundle.putString(KEY_ANDROID_PACKAGE_NAME, string2);
        }
        bundle.putLong("service_connection_start_time_millis", SystemClock.elapsedRealtime());
        zza zza2 = new zza();
        zzl zzl2 = zzl.zzal(context2);
        if (zzl2.zza(zzRw, (ServiceConnection)zza2, "GoogleAuthUtil")) {
            try {
                zzau zzau2 = zzau.zza.zza(zza2.zzno());
                Bundle bundle2 = zzau2.zza(account, string, bundle);
                if (bundle2 == null) {
                    Log.w((String)"GoogleAuthUtil", (String)"Binder call returned null.");
                    throw new GoogleAuthException("ServiceUnavailable");
                }
                TokenData tokenData = TokenData.zza(bundle2, "tokenDetails");
                if (tokenData != null) {
                    TokenData tokenData2 = tokenData;
                    return tokenData2;
                }
                try {
                    String string3 = bundle2.getString("Error");
                    Intent intent = (Intent)bundle2.getParcelable("userRecoveryIntent");
                    zzd zzd2 = zzd.zzbE(string3);
                    if (zzd.zza(zzd2)) {
                        throw new UserRecoverableAuthException(string3, intent);
                    }
                    if (zzd.zzc(zzd2)) {
                        throw new IOException(string3);
                    }
                    throw new GoogleAuthException(string3);
                }
                catch (RemoteException remoteException) {
                    Log.i((String)"GoogleAuthUtil", (String)"GMS remote exception ", (Throwable)remoteException);
                    throw new IOException("remote exception");
                }
                catch (InterruptedException interruptedException) {
                    throw new GoogleAuthException("Interrupted");
                }
            }
            finally {
                zzl2.zzb(zzRw, (ServiceConnection)zza2, "GoogleAuthUtil");
            }
        }
        throw new IOException("Could not bind to service with the given context.");
    }

    @Deprecated
    public static String getTokenWithNotification(Context context, String accountName, String scope, Bundle extras) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        Account account = new Account(accountName, GOOGLE_ACCOUNT_TYPE);
        return GoogleAuthUtil.getTokenWithNotification(context, account, scope, extras);
    }

    @Deprecated
    public static String getTokenWithNotification(Context context, String accountName, String scope, Bundle extras, Intent callback) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        Account account = new Account(accountName, GOOGLE_ACCOUNT_TYPE);
        return GoogleAuthUtil.getTokenWithNotification(context, account, scope, extras, callback);
    }

    @Deprecated
    public static String getTokenWithNotification(Context context, String accountName, String scope, Bundle extras, String authority, Bundle syncBundle) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        Account account = new Account(accountName, GOOGLE_ACCOUNT_TYPE);
        return GoogleAuthUtil.getTokenWithNotification(context, account, scope, extras, authority, syncBundle);
    }

    public static String getTokenWithNotification(Context context, Account account, String scope, Bundle extras) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        TokenData tokenData = GoogleAuthUtil.zzb(context, account, scope, extras);
        return tokenData.getToken();
    }

    public static TokenData zzb(Context context, Account account, String string, Bundle bundle) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        if (bundle == null) {
            bundle = new Bundle();
        }
        bundle.putBoolean("handle_notification", true);
        return GoogleAuthUtil.zzc(context, account, string, bundle);
    }

    public static String getTokenWithNotification(Context context, Account account, String scope, Bundle extras, Intent callback) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        GoogleAuthUtil.zzi(callback);
        extras = extras == null ? new Bundle() : extras;
        extras.putParcelable("callback_intent", (Parcelable)callback);
        extras.putBoolean("handle_notification", true);
        TokenData tokenData = GoogleAuthUtil.zzc(context, account, scope, extras);
        return tokenData.getToken();
    }

    public static String getTokenWithNotification(Context context, Account account, String scope, Bundle extras, String authority, Bundle syncBundle) throws IOException, UserRecoverableNotifiedException, GoogleAuthException {
        if (TextUtils.isEmpty((CharSequence)authority)) {
            throw new IllegalArgumentException("Authority cannot be empty or null.");
        }
        extras = extras == null ? new Bundle() : extras;
        syncBundle = syncBundle == null ? new Bundle() : syncBundle;
        ContentResolver.validateSyncExtrasBundle((Bundle)syncBundle);
        extras.putString("authority", authority);
        extras.putBundle("sync_extras", syncBundle);
        extras.putBoolean("handle_notification", true);
        TokenData tokenData = GoogleAuthUtil.zzc(context, account, scope, extras);
        return tokenData.getToken();
    }

    @Deprecated
    public static void invalidateToken(Context context, String token) {
        AccountManager.get((Context)context).invalidateAuthToken(GOOGLE_ACCOUNT_TYPE, token);
    }

    public static void clearToken(Context context, String token) throws GooglePlayServicesAvailabilityException, GoogleAuthException, IOException {
        block9: {
            Context context2 = context.getApplicationContext();
            zzx.zzcj("Calling this from your main thread can lead to deadlock");
            GoogleAuthUtil.zzaa(context2);
            Bundle bundle = new Bundle();
            String string = context.getApplicationInfo().packageName;
            bundle.putString("clientPackageName", string);
            if (!bundle.containsKey(KEY_ANDROID_PACKAGE_NAME)) {
                bundle.putString(KEY_ANDROID_PACKAGE_NAME, string);
            }
            zza zza2 = new zza();
            zzl zzl2 = zzl.zzal(context2);
            if (zzl2.zza(zzRw, (ServiceConnection)zza2, "GoogleAuthUtil")) {
                try {
                    zzau zzau2 = zzau.zza.zza(zza2.zzno());
                    Bundle bundle2 = zzau2.zza(token, bundle);
                    String string2 = bundle2.getString("Error");
                    if (!bundle2.getBoolean("booleanResult")) {
                        throw new GoogleAuthException(string2);
                    }
                    break block9;
                }
                catch (RemoteException remoteException) {
                    Log.i((String)"GoogleAuthUtil", (String)"GMS remote exception ", (Throwable)remoteException);
                    throw new IOException("remote exception");
                }
                catch (InterruptedException interruptedException) {
                    throw new GoogleAuthException("Interrupted");
                }
                finally {
                    zzl2.zzb(zzRw, (ServiceConnection)zza2, "GoogleAuthUtil");
                }
            }
            throw new IOException("Could not bind to service with the given context.");
        }
    }

    public static List<AccountChangeEvent> getAccountChangeEvents(Context ctx, int eventIndex, String accountName) throws GoogleAuthException, IOException {
        zzx.zzh(accountName, "accountName must be provided");
        zzx.zzcj("Calling this from your main thread can lead to deadlock");
        Context context = ctx.getApplicationContext();
        GoogleAuthUtil.zzaa(context);
        zza zza2 = new zza();
        zzl zzl2 = zzl.zzal(context);
        if (zzl2.zza(zzRw, (ServiceConnection)zza2, "GoogleAuthUtil")) {
            try {
                zzau zzau2 = zzau.zza.zza(zza2.zzno());
                AccountChangeEventsRequest accountChangeEventsRequest = new AccountChangeEventsRequest().setAccountName(accountName).setEventIndex(eventIndex);
                AccountChangeEventsResponse accountChangeEventsResponse = zzau2.zza(accountChangeEventsRequest);
                List<AccountChangeEvent> list = accountChangeEventsResponse.getEvents();
                return list;
            }
            catch (RemoteException remoteException) {
                Log.i((String)"GoogleAuthUtil", (String)"GMS remote exception ", (Throwable)remoteException);
                throw new IOException("remote exception");
            }
            catch (InterruptedException interruptedException) {
                throw new GoogleAuthException("Interrupted");
            }
            finally {
                zzl2.zzb(zzRw, (ServiceConnection)zza2, "GoogleAuthUtil");
            }
        }
        throw new IOException("Could not bind to service with the given context.");
    }

    public static String getAccountId(Context ctx, String accountName) throws GoogleAuthException, IOException {
        zzx.zzh(accountName, "accountName must be provided");
        zzx.zzcj("Calling this from your main thread can lead to deadlock");
        Context context = ctx.getApplicationContext();
        GoogleAuthUtil.zzaa(context);
        return GoogleAuthUtil.getToken(ctx, accountName, "^^_account_id_^^", new Bundle());
    }

    private static void zzi(Intent intent) {
        if (intent == null) {
            throw new IllegalArgumentException("Callback cannot be null.");
        }
        String string = intent.toUri(1);
        try {
            Intent.parseUri((String)string, (int)1);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Parameter callback contains invalid data. It must be serializable using toUri() and parseUri().");
        }
    }

    private static TokenData zzc(Context context, Account account, String string2, Bundle bundle) throws IOException, GoogleAuthException {
        if (bundle == null) {
            bundle = new Bundle();
        }
        try {
            TokenData tokenData = GoogleAuthUtil.zza(context, account, string2, bundle);
            GooglePlayServicesUtil.zzac(context);
            return tokenData;
        }
        catch (GooglePlayServicesAvailabilityException googlePlayServicesAvailabilityException) {
            int n = googlePlayServicesAvailabilityException.getConnectionStatusCode();
            GooglePlayServicesUtil.showErrorNotification(n, context);
            throw new UserRecoverableNotifiedException("User intervention required. Notification has been pushed.");
        }
        catch (UserRecoverableAuthException userRecoverableAuthException) {
            GooglePlayServicesUtil.zzac(context);
            throw new UserRecoverableNotifiedException("User intervention required. Notification has been pushed.");
        }
    }

    private static void zzaa(Context context) throws GoogleAuthException {
        try {
            GooglePlayServicesUtil.zzaa(context);
        }
        catch (GooglePlayServicesRepairableException googlePlayServicesRepairableException) {
            throw new GooglePlayServicesAvailabilityException(googlePlayServicesRepairableException.getConnectionStatusCode(), googlePlayServicesRepairableException.getMessage(), googlePlayServicesRepairableException.getIntent());
        }
        catch (GooglePlayServicesNotAvailableException googlePlayServicesNotAvailableException) {
            throw new GoogleAuthException(googlePlayServicesNotAvailableException.getMessage());
        }
    }

    private GoogleAuthUtil() {
    }
}

