/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.app.FragmentActivity;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzlb;
import com.google.android.gms.internal.zzli;
import com.google.android.gms.internal.zzlm;
import com.google.android.gms.internal.zzlp;
import com.google.android.gms.internal.zzme;
import com.google.android.gms.internal.zzqu;
import com.google.android.gms.internal.zzqw;
import com.google.android.gms.internal.zzqx;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public abstract class GoogleApiClient {
    public <A extends Api.zzb, R extends Result, T extends zzlb.zza<R, A>> T zza(T t) {
        throw new UnsupportedOperationException();
    }

    public <A extends Api.zzb, T extends zzlb.zza<? extends Result, A>> T zzb(T t) {
        throw new UnsupportedOperationException();
    }

    public <L> zzlm<L> zzo(L l) {
        throw new UnsupportedOperationException();
    }

    public <C extends Api.zzb> C zza(Api.zzc<C> zzc2) {
        throw new UnsupportedOperationException();
    }

    public boolean zza(Api<?> api) {
        throw new UnsupportedOperationException();
    }

    public abstract boolean hasConnectedApi(Api<?> var1);

    public abstract ConnectionResult getConnectionResult(Api<?> var1);

    public Context getContext() {
        throw new UnsupportedOperationException();
    }

    public Looper getLooper() {
        throw new UnsupportedOperationException();
    }

    public abstract void connect();

    public abstract ConnectionResult blockingConnect();

    public abstract ConnectionResult blockingConnect(long var1, TimeUnit var3);

    public abstract void disconnect();

    public abstract void reconnect();

    public abstract PendingResult<Status> clearDefaultAccountAndReconnect();

    public abstract void stopAutoManage(FragmentActivity var1);

    public abstract boolean isConnected();

    public abstract boolean isConnecting();

    public abstract void registerConnectionCallbacks(ConnectionCallbacks var1);

    public abstract boolean isConnectionCallbacksRegistered(ConnectionCallbacks var1);

    public abstract void unregisterConnectionCallbacks(ConnectionCallbacks var1);

    public abstract void registerConnectionFailedListener(OnConnectionFailedListener var1);

    public abstract boolean isConnectionFailedListenerRegistered(OnConnectionFailedListener var1);

    public abstract void unregisterConnectionFailedListener(OnConnectionFailedListener var1);

    public abstract void dump(String var1, FileDescriptor var2, PrintWriter var3, String[] var4);

    public int getSessionId() {
        throw new UnsupportedOperationException();
    }

    public static final class Builder {
        private Account zzQd;
        private final Set<Scope> zzaaF = new HashSet<Scope>();
        private int zzaaG;
        private View zzaaH;
        private String zzRq;
        private String zzaaI;
        private final Map<Api<?>, zzf.zza> zzaaJ = new zzme();
        private final Context mContext;
        private final Map<Api<?>, Api.ApiOptions> zzaaK = new zzme();
        private FragmentActivity zzaaL;
        private int zzaaM = -1;
        private OnConnectionFailedListener zzaaN;
        private Looper zzaaO;
        private GoogleApiAvailability zzaaP = GoogleApiAvailability.getInstance();
        private Api.zza<? extends zzqw, zzqx> zzaaQ = zzqu.zzRl;
        private final ArrayList<ConnectionCallbacks> zzaaR = new ArrayList();
        private final ArrayList<OnConnectionFailedListener> zzaaS = new ArrayList();
        private zzqx zzaaT;

        public Builder(Context context) {
            this.mContext = context;
            this.zzaaO = context.getMainLooper();
            this.zzRq = context.getPackageName();
            this.zzaaI = context.getClass().getName();
        }

        public Builder(Context context, ConnectionCallbacks connectedListener, OnConnectionFailedListener connectionFailedListener) {
            this(context);
            zzx.zzb(connectedListener, (Object)"Must provide a connected listener");
            this.zzaaR.add(connectedListener);
            zzx.zzb(connectionFailedListener, (Object)"Must provide a connection failed listener");
            this.zzaaS.add(connectionFailedListener);
        }

        public Builder setHandler(Handler handler) {
            zzx.zzb(handler, (Object)"Handler must not be null");
            this.zzaaO = handler.getLooper();
            return this;
        }

        public Builder addConnectionCallbacks(ConnectionCallbacks listener) {
            zzx.zzb(listener, (Object)"Listener must not be null");
            this.zzaaR.add(listener);
            return this;
        }

        public Builder addOnConnectionFailedListener(OnConnectionFailedListener listener) {
            zzx.zzb(listener, (Object)"Listener must not be null");
            this.zzaaS.add(listener);
            return this;
        }

        public Builder setViewForPopups(View viewForPopups) {
            zzx.zzb(viewForPopups, (Object)"View must not be null");
            this.zzaaH = viewForPopups;
            return this;
        }

        public Builder addScope(Scope scope) {
            zzx.zzb(scope, (Object)"Scope must not be null");
            this.zzaaF.add(scope);
            return this;
        }

        public Builder addApi(Api<? extends Api.ApiOptions.NotRequiredOptions> api) {
            zzx.zzb(api, (Object)"Api must not be null");
            this.zzaaK.put(api, null);
            this.zzaaF.addAll(api.zznv().zzm(null));
            return this;
        }

        public Builder addApiIfAvailable(Api<? extends Api.ApiOptions.NotRequiredOptions> api, Scope ... scopes) {
            zzx.zzb(api, (Object)"Api must not be null");
            this.zzaaK.put(api, null);
            this.zza(api, null, 1, scopes);
            return this;
        }

        public <O extends Api.ApiOptions.HasOptions> Builder addApi(Api<O> api, O options) {
            zzx.zzb(api, (Object)"Api must not be null");
            zzx.zzb(options, (Object)"Null options are not permitted for this Api");
            this.zzaaK.put(api, options);
            this.zzaaF.addAll(api.zznv().zzm(options));
            return this;
        }

        public <O extends Api.ApiOptions.HasOptions> Builder addApiIfAvailable(Api<O> api, O options, Scope ... scopes) {
            zzx.zzb(api, (Object)"Api must not be null");
            zzx.zzb(options, (Object)"Null options are not permitted for this Api");
            this.zzaaK.put(api, options);
            this.zza(api, options, 1, scopes);
            return this;
        }

        public Builder setAccountName(String accountName) {
            this.zzQd = accountName == null ? null : new Account(accountName, "com.google");
            return this;
        }

        public Builder useDefaultAccount() {
            return this.setAccountName("<<default account>>");
        }

        public Builder setGravityForPopups(int gravityForPopups) {
            this.zzaaG = gravityForPopups;
            return this;
        }

        public Builder enableAutoManage(FragmentActivity fragmentActivity, int clientId, OnConnectionFailedListener unresolvedConnectionFailedListener) {
            zzx.zzb(clientId >= 0, (Object)"clientId must be non-negative");
            this.zzaaM = clientId;
            this.zzaaL = zzx.zzb(fragmentActivity, (Object)"Null activity is not permitted.");
            this.zzaaN = unresolvedConnectionFailedListener;
            return this;
        }

        public Builder enableAutoManage(FragmentActivity fragmentActivity, OnConnectionFailedListener unresolvedConnectionFailedListener) {
            return this.enableAutoManage(fragmentActivity, 0, unresolvedConnectionFailedListener);
        }

        public Builder requestServerAuthCode(String serverClientId, ServerAuthCodeCallbacks callbacks) {
            this.zzaaT = new zzqx.zza().zza(serverClientId, callbacks).zzCi();
            return this;
        }

        public zzf zznB() {
            if (this.zzaaK.containsKey(zzqu.API)) {
                zzx.zza(this.zzaaT == null, (Object)"SignIn.API can't be used in conjunction with requestServerAuthCode.");
                this.zzaaT = (zzqx)this.zzaaK.get(zzqu.API);
            }
            return new zzf(this.zzQd, this.zzaaF, this.zzaaJ, this.zzaaG, this.zzaaH, this.zzRq, this.zzaaI, this.zzaaT != null ? this.zzaaT : zzqx.zzaUZ);
        }

        public GoogleApiClient build() {
            zzx.zzb(!this.zzaaK.isEmpty(), (Object)"must call addApi() to add at least one API");
            if (this.zzaaM >= 0) {
                return this.zznC();
            }
            return new zzli(this.mContext, this.zzaaO, this.zznB(), this.zzaaP, this.zzaaQ, this.zzaaK, this.zzaaR, this.zzaaS, -1);
        }

        private GoogleApiClient zznC() {
            final zzli zzli2 = new zzli(this.mContext.getApplicationContext(), this.zzaaO, this.zznB(), this.zzaaP, this.zzaaQ, this.zzaaK, this.zzaaR, this.zzaaS, this.zzaaM);
            zzlp zzlp2 = zzlp.zza(this.zzaaL);
            if (zzlp2 == null) {
                Handler handler = new Handler(this.mContext.getMainLooper());
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (Builder.this.zzaaL.isFinishing() || Builder.this.zzaaL.getSupportFragmentManager().isDestroyed()) {
                            return;
                        }
                        Builder.this.zza(zzlp.zzb(Builder.this.zzaaL), zzli2);
                    }
                });
            } else {
                this.zza(zzlp2, zzli2);
            }
            return zzli2;
        }

        private void zza(zzlp zzlp2, GoogleApiClient googleApiClient) {
            zzlp2.zza(this.zzaaM, googleApiClient, this.zzaaN);
        }

        private <O extends Api.ApiOptions> void zza(Api<O> api, O o, int n, Scope ... scopeArray) {
            boolean bl;
            if (n == 1) {
                bl = true;
            } else if (n == 2) {
                bl = false;
            } else {
                throw new IllegalArgumentException("Invalid resolution mode: '" + n + "', use a constant from GoogleApiClient.ResolutionMode");
            }
            HashSet<Scope> hashSet = new HashSet<Scope>(api.zznv().zzm(o));
            for (Scope scope : scopeArray) {
                hashSet.add(scope);
            }
            this.zzaaJ.put(api, new zzf.zza(hashSet, bl));
        }
    }

    public static interface zza {
        public void zza(ConnectionResult var1);

        public void zzb(ConnectionResult var1);
    }

    public static interface ServerAuthCodeCallbacks {
        public CheckResult onCheckServerAuthorization(String var1, Set<Scope> var2);

        public boolean onUploadServerAuthCode(String var1, String var2);

        public static class CheckResult {
            private boolean zzaaV;
            private Set<Scope> zzTm;

            public static CheckResult newAuthNotRequiredResult() {
                return new CheckResult(false, null);
            }

            public static CheckResult newAuthRequiredResult(Set<Scope> requiredScopes) {
                zzx.zzb(requiredScopes != null && !requiredScopes.isEmpty(), (Object)"A non-empty scope set is required if further auth is needed.");
                return new CheckResult(true, requiredScopes);
            }

            private CheckResult(boolean requiresNewAuthCode, Set<Scope> requiredScopes) {
                this.zzaaV = requiresNewAuthCode;
                this.zzTm = requiredScopes;
            }

            public boolean zznD() {
                return this.zzaaV;
            }

            public Set<Scope> zznE() {
                return this.zzTm;
            }
        }
    }

    public static interface OnConnectionFailedListener {
        public void onConnectionFailed(ConnectionResult var1);
    }

    public static interface ConnectionCallbacks {
        public static final int CAUSE_SERVICE_DISCONNECTED = 1;
        public static final int CAUSE_NETWORK_LOST = 2;

        public void onConnected(Bundle var1);

        public void onConnectionSuspended(int var1);
    }
}

