/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import java.util.LinkedHashMap;
import java.util.Map;

public class zzmg<K, V> {
    private final LinkedHashMap<K, V> zzagB;
    private int size;
    private int zzagC;
    private int zzagD;
    private int zzagE;
    private int zzagF;
    private int zzagG;
    private int zzagH;

    public zzmg(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        this.zzagC = n;
        this.zzagB = new LinkedHashMap(0, 0.75f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V get(K key) {
        Object object;
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        zzmg<K, V> zzmg2 = this;
        synchronized (zzmg2) {
            object = this.zzagB.get(key);
            if (object != null) {
                ++this.zzagG;
                return object;
            }
            ++this.zzagH;
        }
        zzmg2 = this.create(key);
        if (zzmg2 == null) {
            return null;
        }
        zzmg zzmg3 = this;
        synchronized (zzmg3) {
            ++this.zzagE;
            object = this.zzagB.put(key, zzmg2);
            if (object != null) {
                this.zzagB.put(key, object);
            } else {
                this.size += this.zzc(key, zzmg2);
            }
        }
        if (object != null) {
            this.entryRemoved(false, key, zzmg2, object);
            return object;
        }
        this.trimToSize(this.zzagC);
        return (V)zzmg2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final V put(K key, V value) {
        V v;
        if (key == null || value == null) {
            throw new NullPointerException("key == null || value == null");
        }
        zzmg zzmg2 = this;
        synchronized (zzmg2) {
            ++this.zzagD;
            this.size += this.zzc(key, value);
            v = this.zzagB.put(key, value);
            if (v != null) {
                this.size -= this.zzc(key, v);
            }
        }
        if (v != null) {
            this.entryRemoved(false, key, v, value);
        }
        this.trimToSize(this.zzagC);
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trimToSize(int maxSize) {
        while (true) {
            V v;
            K k;
            zzmg zzmg2 = this;
            synchronized (zzmg2) {
                if (this.size < 0 || this.zzagB.isEmpty() && this.size != 0) {
                    throw new IllegalStateException(this.getClass().getName() + ".sizeOf() is reporting inconsistent results!");
                }
                if (this.size <= maxSize || this.zzagB.isEmpty()) {
                    break;
                }
                Map.Entry<K, V> entry = this.zzagB.entrySet().iterator().next();
                k = entry.getKey();
                v = entry.getValue();
                this.zzagB.remove(k);
                this.size -= this.zzc(k, v);
                ++this.zzagF;
            }
            this.entryRemoved(true, k, v, null);
        }
    }

    protected void entryRemoved(boolean evicted, K key, V oldValue, V newValue) {
    }

    protected V create(K key) {
        return null;
    }

    private int zzc(K k, V v) {
        int n = this.sizeOf(k, v);
        if (n < 0) {
            throw new IllegalStateException("Negative size: " + k + "=" + v);
        }
        return n;
    }

    protected int sizeOf(K key, V value) {
        return 1;
    }

    public final void evictAll() {
        this.trimToSize(-1);
    }

    public final synchronized int size() {
        return this.size;
    }

    public final synchronized String toString() {
        int n = this.zzagG + this.zzagH;
        int n2 = n != 0 ? 100 * this.zzagG / n : 0;
        return String.format("LruCache[maxSize=%d,hits=%d,misses=%d,hitRate=%d%%]", this.zzagC, this.zzagG, this.zzagH, n2);
    }
}

