/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.WorkSource;
import android.util.Log;
import com.google.android.gms.internal.zzmx;
import com.google.android.gms.internal.zznb;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class zznc {
    private static final Method zzaip = zznc.zzqG();
    private static final Method zzaiq = zznc.zzqH();
    private static final Method zzair = zznc.zzqI();
    private static final Method zzais = zznc.zzqJ();
    private static final Method zzait = zznc.zzqK();

    public static WorkSource zzf(int n, String string2) {
        WorkSource workSource = new WorkSource();
        zznc.zza(workSource, n, string2);
        return workSource;
    }

    public static WorkSource zzm(Context context, String string2) {
        if (context == null || context.getPackageManager() == null) {
            return null;
        }
        ApplicationInfo applicationInfo = null;
        try {
            applicationInfo = context.getPackageManager().getApplicationInfo(string2, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.e((String)"WorkSourceUtil", (String)("Could not find package: " + string2));
            return null;
        }
        if (applicationInfo == null) {
            Log.e((String)"WorkSourceUtil", (String)("Could not get applicationInfo from package: " + string2));
            return null;
        }
        return zznc.zzf(applicationInfo.uid, string2);
    }

    public static void zza(WorkSource workSource, int n, String string2) {
        if (zzaiq != null) {
            if (string2 == null) {
                string2 = "";
            }
            try {
                zzaiq.invoke((Object)workSource, n, string2);
            }
            catch (Exception exception) {
                Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            }
            return;
        }
        if (zzaip != null) {
            try {
                zzaip.invoke((Object)workSource, n);
            }
            catch (Exception exception) {
                Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            }
        }
    }

    public static int zza(WorkSource workSource) {
        if (zzair != null) {
            try {
                return (Integer)zzair.invoke((Object)workSource, new Object[0]);
            }
            catch (Exception exception) {
                Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            }
        }
        return 0;
    }

    public static String zza(WorkSource workSource, int n) {
        if (zzait != null) {
            try {
                return (String)zzait.invoke((Object)workSource, n);
            }
            catch (Exception exception) {
                Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            }
        }
        return null;
    }

    public static List<String> zzb(WorkSource workSource) {
        int n;
        int n2 = n = workSource == null ? 0 : zznc.zza(workSource);
        if (n == 0) {
            return Collections.EMPTY_LIST;
        }
        String string2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            string2 = zznc.zza(workSource, i);
            if (zznb.zzcA(string2)) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static boolean zzar(Context context) {
        int n = context.getPackageManager().checkPermission("android.permission.UPDATE_DEVICE_STATS", context.getPackageName());
        return n == 0;
    }

    private static Method zzqG() {
        Method method = null;
        try {
            method = WorkSource.class.getMethod("add", Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method;
    }

    private static Method zzqH() {
        Method method = null;
        if (zzmx.zzqA()) {
            try {
                method = WorkSource.class.getMethod("add", Integer.TYPE, String.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return method;
    }

    private static Method zzqI() {
        Method method = null;
        try {
            method = WorkSource.class.getMethod("size", new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method;
    }

    private static Method zzqJ() {
        Method method = null;
        try {
            method = WorkSource.class.getMethod("get", Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method;
    }

    private static Method zzqK() {
        Method method = null;
        if (zzmx.zzqA()) {
            try {
                method = WorkSource.class.getMethod("getName", Integer.TYPE);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return method;
    }
}

