/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.Looper;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.OptionalPendingResult;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzly;
import com.google.android.gms.internal.zzmo;
import com.google.android.gms.internal.zzmq;

public final class PendingResults {
    public static PendingResult<Status> immediatePendingResult(Status result) {
        zzx.zzb(result, (Object)"Result must not be null");
        zzmq zzmq2 = new zzmq(Looper.getMainLooper());
        zzmq2.zzb(result);
        return zzmq2;
    }

    public static PendingResult<Status> zza(Status status, GoogleApiClient googleApiClient) {
        zzx.zzb(status, (Object)"Result must not be null");
        zzmq zzmq2 = new zzmq(googleApiClient);
        zzmq2.zzb(status);
        return zzmq2;
    }

    public static <R extends Result> PendingResult<R> zza(R r, GoogleApiClient googleApiClient) {
        zzx.zzb(r, (Object)"Result must not be null");
        zzx.zzb(!r.getStatus().isSuccess(), (Object)"Status code must not be SUCCESS");
        zzb<R> zzb2 = new zzb<R>(googleApiClient, r);
        zzb2.zzb(r);
        return zzb2;
    }

    public static <R extends Result> OptionalPendingResult<R> immediatePendingResult(R result) {
        zzx.zzb(result, (Object)"Result must not be null");
        zzc<R> zzc2 = new zzc<R>(null);
        zzc2.zzb(result);
        return new zzmo(zzc2);
    }

    public static <R extends Result> OptionalPendingResult<R> zzb(R r, GoogleApiClient googleApiClient) {
        zzx.zzb(r, (Object)"Result must not be null");
        zzc<R> zzc2 = new zzc<R>(googleApiClient);
        zzc2.zzb(r);
        return new zzmo(zzc2);
    }

    public static PendingResult<Status> canceledPendingResult() {
        zzmq zzmq2 = new zzmq(Looper.getMainLooper());
        zzmq2.cancel();
        return zzmq2;
    }

    public static <R extends Result> PendingResult<R> canceledPendingResult(R result) {
        zzx.zzb(result, (Object)"Result must not be null");
        zzx.zzb(result.getStatus().getStatusCode() == 16, (Object)"Status code must be CommonStatusCodes.CANCELED");
        zza<R> zza2 = new zza<R>(result);
        zza2.cancel();
        return zza2;
    }

    private PendingResults() {
    }

    private static final class zza<R extends Result>
    extends zzly<R> {
        private final R zzaeS;

        public zza(R r) {
            super(Looper.getMainLooper());
            this.zzaeS = r;
        }

        @Override
        protected R zzc(Status status) {
            if (status.getStatusCode() != this.zzaeS.getStatus().getStatusCode()) {
                throw new UnsupportedOperationException("Creating failed results is not supported");
            }
            return this.zzaeS;
        }
    }

    private static final class zzb<R extends Result>
    extends zzly<R> {
        private final R zzaeT;

        public zzb(GoogleApiClient googleApiClient, R r) {
            super(googleApiClient);
            this.zzaeT = r;
        }

        @Override
        protected R zzc(Status status) {
            return this.zzaeT;
        }
    }

    private static final class zzc<R extends Result>
    extends zzly<R> {
        public zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        @Override
        protected R zzc(Status status) {
            throw new UnsupportedOperationException("Creating failed results is not supported");
        }
    }
}

