/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.stats;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Debug;
import android.os.Parcelable;
import android.os.Process;
import android.os.SystemClock;
import android.util.Log;
import com.google.android.gms.common.stats.ConnectionEvent;
import com.google.android.gms.common.stats.zzc;
import com.google.android.gms.common.stats.zzd;
import com.google.android.gms.common.stats.zze;
import com.google.android.gms.internal.zznk;
import com.google.android.gms.internal.zzny;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class zzb {
    private static final Object zzakg = new Object();
    private static zzb zzaly;
    private final List<String> zzalz;
    private final List<String> zzalA;
    private final List<String> zzalB;
    private final List<String> zzalC;
    private zze zzalD;
    private static Integer zzalE;
    private zze zzalF;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzb zzrz() {
        Object object = zzakg;
        synchronized (object) {
            if (zzaly == null) {
                zzaly = new zzb();
            }
        }
        return zzaly;
    }

    private zzb() {
        if (zzb.getLogLevel() == zzd.LOG_LEVEL_OFF) {
            this.zzalz = Collections.EMPTY_LIST;
            this.zzalA = Collections.EMPTY_LIST;
            this.zzalB = Collections.EMPTY_LIST;
            this.zzalC = Collections.EMPTY_LIST;
            return;
        }
        String string2 = zzc.zza.zzalJ.get();
        this.zzalz = string2 == null ? Collections.EMPTY_LIST : Arrays.asList(string2.split(","));
        string2 = zzc.zza.zzalK.get();
        this.zzalA = string2 == null ? Collections.EMPTY_LIST : Arrays.asList(string2.split(","));
        string2 = zzc.zza.zzalL.get();
        this.zzalB = string2 == null ? Collections.EMPTY_LIST : Arrays.asList(string2.split(","));
        string2 = zzc.zza.zzalM.get();
        this.zzalC = string2 == null ? Collections.EMPTY_LIST : Arrays.asList(string2.split(","));
        this.zzalD = new zze(1024, zzc.zza.zzalN.get());
        this.zzalF = new zze(1024, zzc.zza.zzalN.get());
    }

    private boolean zzc(Context context, Intent intent) {
        ComponentName componentName = intent.getComponent();
        if (componentName == null || com.google.android.gms.common.internal.zzd.zzaiU && "com.google.android.gms".equals(componentName.getPackageName())) {
            return false;
        }
        return zznk.zzj(context, componentName.getPackageName());
    }

    public boolean zza(Context context, String string2, Intent intent, ServiceConnection serviceConnection, int n) {
        if (this.zzc(context, intent)) {
            Log.w((String)"ConnectionTracker", (String)"Attempted to bind to a service in a STOPPED package.");
            return false;
        }
        boolean bl = context.bindService(intent, serviceConnection, n);
        if (bl) {
            this.zza(context, this.zzb(serviceConnection), string2, intent, 2);
        }
        return bl;
    }

    public boolean zza(Context context, Intent intent, ServiceConnection serviceConnection, int n) {
        return this.zza(context, context.getClass().getName(), intent, serviceConnection, n);
    }

    public void zza(Context context, ServiceConnection serviceConnection) {
        context.unbindService(serviceConnection);
        this.zza(context, this.zzb(serviceConnection), (String)null, (Intent)null, 1);
    }

    public void zza(Context context, ServiceConnection serviceConnection, String string2, Intent intent) {
        this.zza(context, this.zzb(serviceConnection), string2, intent, 3);
    }

    public void zzb(Context context, ServiceConnection serviceConnection) {
        this.zza(context, this.zzb(serviceConnection), (String)null, (Intent)null, 4);
    }

    private void zza(Context context, String string2, String string3, Intent intent, int n) {
        String string4;
        String string5;
        String string6;
        if (!this.zzrA() || this.zzalD == null) {
            return;
        }
        if (n == 4 || n == 1) {
            if (!this.zzalD.zzcN(string2)) {
                return;
            }
            string6 = null;
            string5 = null;
            string4 = null;
        } else {
            ServiceInfo serviceInfo = zzb.zzd(context, intent);
            if (serviceInfo == null) {
                Log.w((String)"ConnectionTracker", (String)String.format("Client %s made an invalid request %s", string3, intent.toUri(0)));
                return;
            }
            string6 = serviceInfo.processName;
            string5 = serviceInfo.name;
            string4 = zzny.zzay(context);
            if (!this.zzb(string4, string3, string6, string5)) {
                return;
            }
            this.zzalD.zzcM(string2);
        }
        this.zza(context, string2, n, string4, string3, string6, string5);
    }

    private void zza(Context context, String string2, int n, String string3, String string4, String string5, String string6) {
        long l = System.currentTimeMillis();
        String string7 = null;
        if ((zzb.getLogLevel() & zzd.zzalS) != 0 && n != 13) {
            string7 = zzny.zzm(3, 5);
        }
        long l2 = 0L;
        if ((zzb.getLogLevel() & zzd.zzalU) != 0) {
            l2 = Debug.getNativeHeapAllocatedSize();
        }
        ConnectionEvent connectionEvent = n == 1 || n == 4 || n == 14 ? new ConnectionEvent(l, n, null, null, null, null, string7, string2, SystemClock.elapsedRealtime(), l2) : new ConnectionEvent(l, n, string3, string4, string5, string6, string7, string2, SystemClock.elapsedRealtime(), l2);
        context.startService(new Intent().setComponent(zzd.zzalO).putExtra("com.google.android.gms.common.stats.EXTRA_LOG_EVENT", (Parcelable)connectionEvent));
    }

    private boolean zzrA() {
        if (!com.google.android.gms.common.internal.zzd.zzaiU) {
            return false;
        }
        int n = zzb.getLogLevel();
        return n != zzd.LOG_LEVEL_OFF;
    }

    private boolean zzb(String string2, String string3, String string4, String string5) {
        int n = zzb.getLogLevel();
        return !this.zzalz.contains(string2) && !this.zzalA.contains(string3) && !this.zzalB.contains(string4) && !this.zzalC.contains(string5) && (!string4.equals(string2) || (n & zzd.zzalT) == 0);
    }

    private static ServiceInfo zzd(Context context, Intent intent) {
        List list = context.getPackageManager().queryIntentServices(intent, 128);
        if (list == null || list.size() == 0) {
            Log.w((String)"ConnectionTracker", (String)String.format("There are no handler of this intent: %s\n Stack trace: %s", intent.toUri(0), zzny.zzm(3, 20)));
            return null;
        }
        if (list.size() > 1) {
            Log.w((String)"ConnectionTracker", (String)String.format("Multiple handlers found for this intent: %s\n Stack trace: %s", intent.toUri(0), zzny.zzm(3, 20)));
            Iterator iterator = list.iterator();
            if (iterator.hasNext()) {
                ResolveInfo resolveInfo = (ResolveInfo)iterator.next();
                Log.w((String)"ConnectionTracker", (String)resolveInfo.serviceInfo.name);
                return null;
            }
        }
        return ((ResolveInfo)list.get((int)0)).serviceInfo;
    }

    private String zzb(ServiceConnection serviceConnection) {
        return String.valueOf((long)Process.myPid() << 32 | (long)System.identityHashCode(serviceConnection));
    }

    private static int getLogLevel() {
        if (zzalE == null) {
            try {
                zzalE = zznk.zzka() ? zzc.zza.zzalI.get() : zzd.LOG_LEVEL_OFF;
            }
            catch (SecurityException securityException) {
                zzalE = zzd.LOG_LEVEL_OFF;
            }
        }
        return zzalE;
    }
}

