/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.ResolveAccountResponse;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.internal.zzp;
import com.google.android.gms.common.internal.zzt;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zzlx;
import com.google.android.gms.internal.zzmg;
import com.google.android.gms.internal.zzmh;
import com.google.android.gms.internal.zzmi;
import com.google.android.gms.internal.zzmj;
import com.google.android.gms.internal.zzsc;
import com.google.android.gms.internal.zzsd;
import com.google.android.gms.signin.internal.AuthAccountResult;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;

public class zzme
implements zzmh {
    private final zzmi zzafD;
    private final Lock zzafz;
    private final Context mContext;
    private final GoogleApiAvailability zzaeL;
    private ConnectionResult zzafF;
    private int zzafG;
    private int zzafH = 0;
    private boolean zzafI = false;
    private int zzafJ;
    private final Bundle zzafK = new Bundle();
    private final Set<Api.zzc> zzafL = new HashSet<Api.zzc>();
    private zzsc zzafM;
    private int zzafN;
    private boolean zzafO;
    private boolean zzafP;
    private zzp zzafQ;
    private boolean zzafR;
    private boolean zzafS;
    private final com.google.android.gms.common.internal.zzf zzafT;
    private final Map<Api<?>, Integer> zzafU;
    private final Api.zza<? extends zzsc, zzsd> zzaeM;
    private ArrayList<Future<?>> zzafV = new ArrayList();

    public zzme(zzmi zzmi2, com.google.android.gms.common.internal.zzf zzf2, Map<Api<?>, Integer> map, GoogleApiAvailability googleApiAvailability, Api.zza<? extends zzsc, zzsd> zza2, Lock lock, Context context) {
        this.zzafD = zzmi2;
        this.zzafT = zzf2;
        this.zzafU = map;
        this.zzaeL = googleApiAvailability;
        this.zzaeM = zza2;
        this.zzafz = lock;
        this.mContext = context;
    }

    @Override
    public void begin() {
        this.zzafD.zzagJ.clear();
        this.zzafI = false;
        this.zzafO = false;
        this.zzafF = null;
        this.zzafH = 0;
        this.zzafN = 2;
        this.zzafP = false;
        this.zzafR = false;
        boolean bl = false;
        HashMap<Api.zzb, GoogleApiClient.zza> hashMap = new HashMap<Api.zzb, GoogleApiClient.zza>();
        for (Api<?> api : this.zzafU.keySet()) {
            Api.zzb zzb2 = this.zzafD.zzagp.get(api.zzoA());
            int n = this.zzafU.get(api);
            bl |= api.zzoy().getPriority() == 1;
            if (zzb2.zzmn()) {
                this.zzafO = true;
                if (n < this.zzafN) {
                    this.zzafN = n;
                }
                if (n != 0) {
                    this.zzafL.add(api.zzoA());
                }
            }
            hashMap.put(zzb2, new zzd(this, api, n));
        }
        if (bl) {
            this.zzafO = false;
        }
        if (this.zzafO) {
            this.zzafT.zza(this.zzafD.zzafp.getSessionId());
            zzg zzg2 = new zzg();
            this.zzafM = this.zzaeM.zza(this.mContext, this.zzafD.zzafp.getLooper(), this.zzafT, this.zzafT.zzqg(), zzg2, zzg2);
        }
        this.zzafJ = this.zzafD.zzagp.size();
        this.zzafV.add(zzmj.zzpz().submit(new zze(hashMap)));
    }

    private boolean zzpd() {
        --this.zzafJ;
        if (this.zzafJ > 0) {
            return false;
        }
        if (this.zzafJ < 0) {
            Log.i((String)"GoogleApiClientConnecting", (String)this.zzafD.zzafp.zzpt());
            Log.wtf((String)"GoogleApiClientConnecting", (String)"GoogleApiClient received too many callbacks for the given step. Clients may be in an unexpected state; GoogleApiClient will now disconnect.", (Throwable)new Exception());
            this.zzi(new ConnectionResult(8, null));
            return false;
        }
        if (this.zzafF != null) {
            this.zzafD.zzagM = this.zzafG;
            this.zzi(this.zzafF);
            return false;
        }
        return true;
    }

    private void zzpe() {
        if (this.zzafJ != 0) {
            return;
        }
        if (this.zzafO) {
            if (this.zzafP) {
                this.zzpf();
            }
        } else {
            this.zzph();
        }
    }

    private void zza(ResolveAccountResponse resolveAccountResponse) {
        if (!this.zzbA(0)) {
            return;
        }
        ConnectionResult connectionResult = resolveAccountResponse.zzqI();
        if (connectionResult.isSuccess()) {
            this.zzafQ = resolveAccountResponse.zzqH();
            this.zzafP = true;
            this.zzafR = resolveAccountResponse.zzqJ();
            this.zzafS = resolveAccountResponse.zzqK();
            this.zzpe();
        } else if (this.zzh(connectionResult)) {
            this.zzpj();
            this.zzpe();
        } else {
            this.zzi(connectionResult);
        }
    }

    private void zzpf() {
        ArrayList<Api.zzb> arrayList = new ArrayList<Api.zzb>();
        this.zzafH = 1;
        this.zzafJ = this.zzafD.zzagp.size();
        for (Api.zzc<?> zzc2 : this.zzafD.zzagp.keySet()) {
            if (this.zzafD.zzagJ.containsKey(zzc2)) {
                if (!this.zzpd()) continue;
                this.zzpg();
                continue;
            }
            arrayList.add(this.zzafD.zzagp.get(zzc2));
        }
        if (!arrayList.isEmpty()) {
            this.zzafV.add(zzmj.zzpz().submit(new zzh(arrayList)));
        }
    }

    private void zzpg() {
        this.zzafH = 2;
        this.zzafD.zzafp.zzagq = this.zzpl();
        this.zzafV.add(zzmj.zzpz().submit(new zzc()));
    }

    private void zzf(ConnectionResult connectionResult) {
        if (!this.zzbA(2)) {
            return;
        }
        if (connectionResult.isSuccess()) {
            this.zzph();
        } else if (this.zzh(connectionResult)) {
            this.zzpj();
            this.zzph();
        } else {
            this.zzi(connectionResult);
        }
    }

    private void zzph() {
        ArrayList<Api.zzb> arrayList = new ArrayList<Api.zzb>();
        this.zzafH = 3;
        this.zzafJ = this.zzafD.zzagp.size();
        for (Api.zzc<?> zzc2 : this.zzafD.zzagp.keySet()) {
            if (this.zzafD.zzagJ.containsKey(zzc2)) {
                if (!this.zzpd()) continue;
                this.zzpi();
                continue;
            }
            arrayList.add(this.zzafD.zzagp.get(zzc2));
        }
        if (!arrayList.isEmpty()) {
            this.zzafV.add(zzmj.zzpz().submit(new zzf(arrayList)));
        }
    }

    @Override
    public void onConnected(Bundle connectionHint) {
        if (!this.zzbA(3)) {
            return;
        }
        if (connectionHint != null) {
            this.zzafK.putAll(connectionHint);
        }
        if (this.zzpd()) {
            this.zzpi();
        }
    }

    @Override
    public void zza(ConnectionResult connectionResult, Api<?> api, int n) {
        if (!this.zzbA(3)) {
            return;
        }
        this.zzb(connectionResult, api, n);
        if (this.zzpd()) {
            this.zzpi();
        }
    }

    private void zzpi() {
        this.zzafD.zzpx();
        zzmj.zzpz().execute(new Runnable(){

            @Override
            public void run() {
                zzme.this.zzaeL.zzaj(zzme.this.mContext);
            }
        });
        if (this.zzafM != null) {
            if (this.zzafR) {
                this.zzafM.zza(this.zzafQ, this.zzafS);
            }
            this.zzZ(false);
        }
        for (Api.zzc<?> zzc2 : this.zzafD.zzagJ.keySet()) {
            Api.zzb zzb2 = this.zzafD.zzagp.get(zzc2);
            zzb2.disconnect();
        }
        Bundle bundle = this.zzafK.isEmpty() ? null : this.zzafK;
        this.zzafD.zzagN.zzi(bundle);
        if (this.zzafI) {
            this.zzafI = false;
            this.disconnect();
        }
    }

    @Override
    public <A extends Api.zzb, R extends Result, T extends zzlx.zza<R, A>> T zza(T t) {
        this.zzafD.zzafp.zzagj.add(t);
        return t;
    }

    @Override
    public <A extends Api.zzb, T extends zzlx.zza<? extends Result, A>> T zzb(T t) {
        throw new IllegalStateException("GoogleApiClient is not connected yet.");
    }

    @Override
    public void connect() {
        this.zzafI = false;
    }

    @Override
    public void disconnect() {
        Iterator iterator = this.zzafD.zzafp.zzagj.iterator();
        while (iterator.hasNext()) {
            zzmg.zze zze2 = (zzmg.zze)iterator.next();
            if (zze2.zzoQ() == 1) continue;
            zze2.cancel();
            iterator.remove();
        }
        if (this.zzafF == null && !this.zzafD.zzafp.zzagj.isEmpty()) {
            this.zzafI = true;
            return;
        }
        this.zzpk();
        this.zzZ(true);
        this.zzafD.zzj(null);
    }

    @Override
    public void onConnectionSuspended(int cause) {
        this.zzi(new ConnectionResult(8, null));
    }

    private void zzb(ConnectionResult connectionResult, Api<?> api, int n) {
        int n2;
        if (n != 2 && this.zza(n2 = api.zzoy().getPriority(), n, connectionResult)) {
            this.zzafF = connectionResult;
            this.zzafG = n2;
        }
        this.zzafD.zzagJ.put(api.zzoA(), connectionResult);
    }

    private boolean zza(int n, int n2, ConnectionResult connectionResult) {
        if (n2 == 1 && !this.zzg(connectionResult)) {
            return false;
        }
        return this.zzafF == null || n < this.zzafG;
    }

    private boolean zzg(ConnectionResult connectionResult) {
        if (connectionResult.hasResolution()) {
            return true;
        }
        return this.zzaeL.zzbu(connectionResult.getErrorCode()) != null;
    }

    private void zzpj() {
        this.zzafO = false;
        this.zzafD.zzafp.zzagq = Collections.emptySet();
        for (Api.zzc zzc2 : this.zzafL) {
            if (this.zzafD.zzagJ.containsKey(zzc2)) continue;
            this.zzafD.zzagJ.put(zzc2, new ConnectionResult(17, null));
        }
    }

    private boolean zzh(ConnectionResult connectionResult) {
        return this.zzafN == 2 || this.zzafN == 1 && !connectionResult.hasResolution();
    }

    private void zzi(ConnectionResult connectionResult) {
        this.zzpk();
        this.zzZ(!connectionResult.hasResolution());
        this.zzafD.zzj(connectionResult);
        if (!this.zzafI) {
            this.zzafD.zzagN.zze(connectionResult);
        }
        this.zzafI = false;
    }

    private void zzZ(boolean bl) {
        if (this.zzafM != null) {
            if (this.zzafM.isConnected() && bl) {
                this.zzafM.zzDL();
            }
            this.zzafM.disconnect();
            this.zzafQ = null;
        }
    }

    private void zzpk() {
        for (Future<?> future : this.zzafV) {
            future.cancel(true);
        }
        this.zzafV.clear();
    }

    private Set<Scope> zzpl() {
        if (this.zzafT == null) {
            return Collections.emptySet();
        }
        HashSet<Scope> hashSet = new HashSet<Scope>(this.zzafT.zzqa());
        Map<Api<?>, zzf.zza> map = this.zzafT.zzqc();
        for (Api<?> api : map.keySet()) {
            if (this.zzafD.zzagJ.containsKey(api.zzoA())) continue;
            hashSet.addAll(map.get(api).zzVH);
        }
        return hashSet;
    }

    private boolean zzbA(int n) {
        if (this.zzafH != n) {
            Log.i((String)"GoogleApiClientConnecting", (String)this.zzafD.zzafp.zzpt());
            Log.wtf((String)"GoogleApiClientConnecting", (String)("GoogleApiClient connecting is in step " + this.zzbB(this.zzafH) + " but received callback for step " + this.zzbB(n)), (Throwable)new Exception());
            this.zzi(new ConnectionResult(8, null));
            return false;
        }
        return true;
    }

    private String zzbB(int n) {
        switch (n) {
            case 0: {
                return "STEP_GETTING_SERVICE_BINDINGS";
            }
            case 1: {
                return "STEP_VALIDATING_ACCOUNT";
            }
            case 2: {
                return "STEP_AUTHENTICATING";
            }
            case 3: {
                return "STEP_GETTING_REMOTE_SERVICE";
            }
        }
        return "UNKNOWN";
    }

    private static class zza
    extends com.google.android.gms.signin.internal.zzb {
        private final WeakReference<zzme> zzafX;

        zza(zzme zzme2) {
            this.zzafX = new WeakReference<zzme>(zzme2);
        }

        @Override
        public void zza(final ConnectionResult connectionResult, AuthAccountResult authAccountResult) {
            final zzme zzme2 = (zzme)this.zzafX.get();
            if (zzme2 == null) {
                return;
            }
            zzme2.zzafD.zza(new zzmi.zza(zzme2){

                @Override
                public void zzpc() {
                    zzme2.zzf(connectionResult);
                }
            });
        }
    }

    private static class zzd
    implements GoogleApiClient.zza {
        private final WeakReference<zzme> zzafX;
        private final Api<?> zzafm;
        private final int zzafn;

        public zzd(zzme zzme2, Api<?> api, int n) {
            this.zzafX = new WeakReference<zzme>(zzme2);
            this.zzafm = api;
            this.zzafn = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zza(ConnectionResult connectionResult) {
            zzme zzme2 = (zzme)this.zzafX.get();
            if (zzme2 == null) {
                return;
            }
            zzx.zza(Looper.myLooper() == ((zzme)zzme2).zzafD.zzafp.getLooper(), (Object)"onReportServiceBinding must be called on the GoogleApiClient handler thread");
            zzme2.zzafz.lock();
            try {
                if (!zzme2.zzbA(0)) {
                    return;
                }
                if (!connectionResult.isSuccess()) {
                    zzme2.zzb(connectionResult, this.zzafm, this.zzafn);
                }
                if (zzme2.zzpd()) {
                    zzme2.zzpe();
                }
            }
            finally {
                zzme2.zzafz.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void zzb(ConnectionResult connectionResult) {
            zzme zzme2 = (zzme)this.zzafX.get();
            if (zzme2 == null) {
                return;
            }
            zzx.zza(Looper.myLooper() == ((zzme)zzme2).zzafD.zzafp.getLooper(), (Object)"onReportAccountValidation must be called on the GoogleApiClient handler thread");
            zzme2.zzafz.lock();
            try {
                if (!zzme2.zzbA(1)) {
                    return;
                }
                if (!connectionResult.isSuccess()) {
                    zzme2.zzb(connectionResult, this.zzafm, this.zzafn);
                }
                if (zzme2.zzpd()) {
                    zzme2.zzpg();
                }
            }
            finally {
                zzme2.zzafz.unlock();
            }
        }
    }

    private class zzg
    implements GoogleApiClient.ConnectionCallbacks,
    GoogleApiClient.OnConnectionFailedListener {
        private zzg() {
        }

        @Override
        public void onConnected(Bundle connectionHint) {
            zzme.this.zzafM.zza(new zzb(zzme.this));
        }

        @Override
        public void onConnectionSuspended(int cause) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onConnectionFailed(ConnectionResult result) {
            zzme.this.zzafz.lock();
            try {
                if (zzme.this.zzh(result)) {
                    zzme.this.zzpj();
                    zzme.this.zzph();
                } else {
                    zzme.this.zzi(result);
                }
            }
            finally {
                zzme.this.zzafz.unlock();
            }
        }
    }

    private static class zzb
    extends zzt.zza {
        private final WeakReference<zzme> zzafX;

        zzb(zzme zzme2) {
            this.zzafX = new WeakReference<zzme>(zzme2);
        }

        @Override
        public void zzb(final ResolveAccountResponse resolveAccountResponse) {
            final zzme zzme2 = (zzme)this.zzafX.get();
            if (zzme2 == null) {
                return;
            }
            zzme2.zzafD.zza(new zzmi.zza(zzme2){

                @Override
                public void zzpc() {
                    zzme2.zza(resolveAccountResponse);
                }
            });
        }
    }

    private class zzf
    extends zzi {
        private final ArrayList<Api.zzb> zzagg;

        public zzf(ArrayList<Api.zzb> arrayList) {
            this.zzagg = arrayList;
        }

        @Override
        public void zzpc() {
            if (((zzme)zzme.this).zzafD.zzafp.zzagq.isEmpty()) {
                ((zzme)zzme.this).zzafD.zzafp.zzagq = zzme.this.zzpl();
            }
            for (Api.zzb zzb2 : this.zzagg) {
                zzb2.zza(zzme.this.zzafQ, ((zzme)zzme.this).zzafD.zzafp.zzagq);
            }
        }
    }

    private class zzc
    extends zzi {
        private zzc() {
        }

        @Override
        public void zzpc() {
            zzme.this.zzafM.zza(zzme.this.zzafQ, ((zzme)zzme.this).zzafD.zzafp.zzagq, new zza(zzme.this));
        }
    }

    private class zzh
    extends zzi {
        private final ArrayList<Api.zzb> zzagg;

        public zzh(ArrayList<Api.zzb> arrayList) {
            this.zzagg = arrayList;
        }

        @Override
        public void zzpc() {
            for (Api.zzb zzb2 : this.zzagg) {
                zzb2.zza(zzme.this.zzafQ);
            }
        }
    }

    private class zze
    extends zzi {
        private final Map<Api.zzb, GoogleApiClient.zza> zzagd;

        public zze(Map<Api.zzb, GoogleApiClient.zza> map) {
            this.zzagd = map;
        }

        @Override
        public void zzpc() {
            int n = zzme.this.zzaeL.isGooglePlayServicesAvailable(zzme.this.mContext);
            if (n != 0) {
                final ConnectionResult connectionResult = new ConnectionResult(n, null);
                zzme.this.zzafD.zza(new zzmi.zza(zzme.this){

                    @Override
                    public void zzpc() {
                        zzme.this.zzi(connectionResult);
                    }
                });
                return;
            }
            if (zzme.this.zzafO) {
                zzme.this.zzafM.connect();
            }
            for (Api.zzb zzb2 : this.zzagd.keySet()) {
                zzb2.zza(this.zzagd.get(zzb2));
            }
        }
    }

    private abstract class zzi
    implements Runnable {
        private zzi() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            zzme.this.zzafz.lock();
            try {
                if (Thread.interrupted()) {
                    return;
                }
                this.zzpc();
            }
            catch (RuntimeException runtimeException) {
                zzme.this.zzafD.zza(runtimeException);
            }
            finally {
                zzme.this.zzafz.unlock();
            }
        }

        protected abstract void zzpc();
    }
}

