/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.playlog.internal;

import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.playlog.internal.zzc;

public class LogEvent
implements SafeParcelable {
    public static final zzc CREATOR = new zzc();
    public final int versionCode;
    public final long zzaYn;
    public final long zzaYo;
    public final String tag;
    public final byte[] zzaYp;
    public final Bundle zzaYq;

    LogEvent(int versionCode, long eventTime, long eventUptime, String tag, byte[] sourceExtensionBytes, Bundle keyValuePairs) {
        this.versionCode = versionCode;
        this.zzaYn = eventTime;
        this.zzaYo = eventUptime;
        this.tag = tag;
        this.zzaYp = sourceExtensionBytes;
        this.zzaYq = keyValuePairs;
    }

    public LogEvent(long eventTime, long eventUptime, String tag, byte[] sourceExtensionBytes, String ... extras) {
        this.versionCode = 1;
        this.zzaYn = eventTime;
        this.zzaYo = eventUptime;
        this.tag = tag;
        this.zzaYp = sourceExtensionBytes;
        this.zzaYq = LogEvent.zzd(extras);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        zzc.zza(this, out, flags);
    }

    private static Bundle zzd(String ... stringArray) {
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length % 2 != 0) {
            throw new IllegalArgumentException("extras must have an even number of elements");
        }
        int n = stringArray.length / 2;
        if (n == 0) {
            return null;
        }
        Bundle bundle = new Bundle(n);
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i * 2];
            String string2 = stringArray[i * 2 + 1];
            bundle.putString(string, string2);
        }
        return bundle;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("tag=").append(this.tag).append(",");
        stringBuilder.append("eventTime=").append(this.zzaYn).append(",");
        stringBuilder.append("eventUptime=").append(this.zzaYo).append(",");
        if (this.zzaYq != null && !this.zzaYq.isEmpty()) {
            stringBuilder.append("keyValues=");
            for (String string : this.zzaYq.keySet()) {
                stringBuilder.append("(").append(string).append(",");
                stringBuilder.append(this.zzaYq.getString(string)).append(")");
                stringBuilder.append(" ");
            }
        }
        return stringBuilder.toString();
    }
}

