/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.playlog.internal;

import android.content.Context;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.internal.zzj;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.internal.zztk;
import com.google.android.gms.playlog.internal.LogEvent;
import com.google.android.gms.playlog.internal.PlayLoggerContext;
import com.google.android.gms.playlog.internal.zza;
import com.google.android.gms.playlog.internal.zzb;
import com.google.android.gms.playlog.internal.zzd;
import java.util.ArrayList;

public class zzf
extends zzj<zza> {
    private final String zzSp;
    private final zzd zzaYG;
    private final zzb zzaYH;
    private final Object zzpK;
    private boolean zzaYI;

    public zzf(Context context, Looper looper, zzd zzd2, com.google.android.gms.common.internal.zzf zzf2) {
        super(context, looper, 24, zzf2, zzd2, zzd2);
        this.zzSp = context.getPackageName();
        this.zzaYG = zzx.zzy(zzd2);
        this.zzaYG.zza(this);
        this.zzaYH = new zzb();
        this.zzpK = new Object();
        this.zzaYI = true;
    }

    @Override
    protected String zzgh() {
        return "com.google.android.gms.playlog.service.START";
    }

    @Override
    protected String zzgi() {
        return "com.google.android.gms.playlog.internal.IPlayLogService";
    }

    protected zza zzdJ(IBinder iBinder) {
        return zza.zza.zzdI(iBinder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.zzpK;
        synchronized (object) {
            if (this.isConnecting() || this.isConnected()) {
                return;
            }
            this.zzaYG.zzar(true);
            this.zzqp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.zzpK;
        synchronized (object) {
            this.zzaYG.zzar(false);
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void zzas(boolean bl) {
        Object object = this.zzpK;
        synchronized (object) {
            boolean bl2 = this.zzaYI;
            this.zzaYI = bl;
            if (bl2 && !this.zzaYI) {
                this.zzDb();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zzb(PlayLoggerContext playLoggerContext, LogEvent logEvent) {
        Object object = this.zzpK;
        synchronized (object) {
            if (this.zzaYI) {
                this.zzc(playLoggerContext, logEvent);
            } else {
                this.zzd(playLoggerContext, logEvent);
            }
        }
    }

    private void zzc(PlayLoggerContext playLoggerContext, LogEvent logEvent) {
        this.zzaYH.zza(playLoggerContext, logEvent);
    }

    private void zzd(PlayLoggerContext playLoggerContext, LogEvent logEvent) {
        try {
            this.zzDb();
            ((zza)this.zzqs()).zza(this.zzSp, playLoggerContext, logEvent);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"PlayLoggerImpl", (String)"Couldn't send log event.  Will try caching.");
            this.zzc(playLoggerContext, logEvent);
        }
        catch (IllegalStateException illegalStateException) {
            Log.e((String)"PlayLoggerImpl", (String)"Service was disconnected.  Will try caching.");
            this.zzc(playLoggerContext, logEvent);
        }
    }

    private void zzDb() {
        com.google.android.gms.common.internal.zzb.zzaa(!this.zzaYI);
        if (!this.zzaYH.isEmpty()) {
            try {
                PlayLoggerContext playLoggerContext = null;
                ArrayList<LogEvent> arrayList = new ArrayList<LogEvent>();
                for (zzb.zza zza2 : this.zzaYH.zzCZ()) {
                    if (zza2.zzaYv != null) {
                        ((zza)this.zzqs()).zza(this.zzSp, zza2.zzaYt, zztk.toByteArray(zza2.zzaYv));
                        continue;
                    }
                    if (zza2.zzaYt.equals(playLoggerContext)) {
                        arrayList.add(zza2.zzaYu);
                        continue;
                    }
                    if (!arrayList.isEmpty()) {
                        ((zza)this.zzqs()).zza(this.zzSp, playLoggerContext, arrayList);
                        arrayList.clear();
                    }
                    playLoggerContext = zza2.zzaYt;
                    arrayList.add(zza2.zzaYu);
                }
                if (!arrayList.isEmpty()) {
                    ((zza)this.zzqs()).zza(this.zzSp, playLoggerContext, arrayList);
                }
                this.zzaYH.clear();
            }
            catch (RemoteException remoteException) {
                Log.e((String)"PlayLoggerImpl", (String)"Couldn't send cached log events to AndroidLog service.  Retaining in memory cache.");
            }
        }
    }

    @Override
    protected /* synthetic */ IInterface zzW(IBinder iBinder) {
        return this.zzdJ(iBinder);
    }
}

