/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.accounts.Account;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.util.ArrayMap;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zza;
import com.google.android.gms.common.api.internal.zzj;
import com.google.android.gms.common.api.internal.zzq;
import com.google.android.gms.common.api.internal.zzu;
import com.google.android.gms.common.api.internal.zzw;
import com.google.android.gms.common.api.internal.zzx;
import com.google.android.gms.common.internal.zzad;
import com.google.android.gms.common.internal.zzf;
import com.google.android.gms.common.zzc;
import com.google.android.gms.internal.zzrl;
import com.google.android.gms.internal.zzrn;
import com.google.android.gms.internal.zzro;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public abstract class GoogleApiClient {
    private static final Set<GoogleApiClient> zzagg = Collections.newSetFromMap(new WeakHashMap());
    public static final int SIGN_IN_MODE_REQUIRED = 1;
    public static final int SIGN_IN_MODE_OPTIONAL = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpAll(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        Set<GoogleApiClient> set = zzagg;
        synchronized (set) {
            int n = 0;
            String string2 = prefix + "  ";
            for (GoogleApiClient googleApiClient : zzagg) {
                writer.append(prefix).append("GoogleApiClient#").println(n++);
                googleApiClient.dump(string2, fd, writer, args);
            }
        }
    }

    public static Set<GoogleApiClient> zzoV() {
        return zzagg;
    }

    public <A extends Api.zzb, R extends Result, T extends zza.zza<R, A>> T zza(@NonNull T t) {
        throw new UnsupportedOperationException();
    }

    public <A extends Api.zzb, T extends zza.zza<? extends Result, A>> T zzb(@NonNull T t) {
        throw new UnsupportedOperationException();
    }

    public <L> zzq<L> zzr(@NonNull L l) {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public <C extends Api.zzb> C zza(@NonNull Api.zzc<C> zzc2) {
        throw new UnsupportedOperationException();
    }

    public boolean zza(@NonNull Api<?> api) {
        throw new UnsupportedOperationException();
    }

    public abstract boolean hasConnectedApi(@NonNull Api<?> var1);

    @NonNull
    public abstract ConnectionResult getConnectionResult(@NonNull Api<?> var1);

    public Context getContext() {
        throw new UnsupportedOperationException();
    }

    public Looper getLooper() {
        throw new UnsupportedOperationException();
    }

    public boolean zza(zzu zzu2) {
        throw new UnsupportedOperationException();
    }

    public void zzoW() {
        throw new UnsupportedOperationException();
    }

    public abstract void connect();

    public void connect(int signInMode) {
        throw new UnsupportedOperationException();
    }

    public abstract ConnectionResult blockingConnect();

    public abstract ConnectionResult blockingConnect(long var1, @NonNull TimeUnit var3);

    public abstract void disconnect();

    public abstract void reconnect();

    public abstract PendingResult<Status> clearDefaultAccountAndReconnect();

    public abstract void stopAutoManage(@NonNull FragmentActivity var1);

    public abstract boolean isConnected();

    public abstract boolean isConnecting();

    public abstract void registerConnectionCallbacks(@NonNull ConnectionCallbacks var1);

    public abstract boolean isConnectionCallbacksRegistered(@NonNull ConnectionCallbacks var1);

    public abstract void unregisterConnectionCallbacks(@NonNull ConnectionCallbacks var1);

    public abstract void registerConnectionFailedListener(@NonNull OnConnectionFailedListener var1);

    public abstract boolean isConnectionFailedListenerRegistered(@NonNull OnConnectionFailedListener var1);

    public abstract void unregisterConnectionFailedListener(@NonNull OnConnectionFailedListener var1);

    public abstract void dump(String var1, FileDescriptor var2, PrintWriter var3, String[] var4);

    public void zza(zzx zzx2) {
        throw new UnsupportedOperationException();
    }

    public void zzb(zzx zzx2) {
        throw new UnsupportedOperationException();
    }

    public static final class Builder {
        private Account zzTI;
        private final Set<Scope> zzagh = new HashSet<Scope>();
        private final Set<Scope> zzagi = new HashSet<Scope>();
        private int zzagj;
        private View zzagk;
        private String zzUW;
        private String zzagl;
        private final Map<Api<?>, zzf.zza> zzagm = new ArrayMap();
        private final Context mContext;
        private final Map<Api<?>, Api.ApiOptions> zzagn = new ArrayMap();
        private FragmentActivity zzago;
        private int zzagp = -1;
        private OnConnectionFailedListener zzagq;
        private Looper zzagr;
        private zzc zzags = zzc.zzoK();
        private Api.zza<? extends zzrn, zzro> zzagt = zzrl.zzUJ;
        private final ArrayList<ConnectionCallbacks> zzagu = new ArrayList();
        private final ArrayList<OnConnectionFailedListener> zzagv = new ArrayList();

        public Builder(@NonNull Context context) {
            this.mContext = context;
            this.zzagr = context.getMainLooper();
            this.zzUW = context.getPackageName();
            this.zzagl = context.getClass().getName();
        }

        public Builder(@NonNull Context context, @NonNull ConnectionCallbacks connectedListener, @NonNull OnConnectionFailedListener connectionFailedListener) {
            this(context);
            com.google.android.gms.common.internal.zzx.zzb(connectedListener, (Object)"Must provide a connected listener");
            this.zzagu.add(connectedListener);
            com.google.android.gms.common.internal.zzx.zzb(connectionFailedListener, (Object)"Must provide a connection failed listener");
            this.zzagv.add(connectionFailedListener);
        }

        public Builder setHandler(@NonNull Handler handler) {
            com.google.android.gms.common.internal.zzx.zzb(handler, (Object)"Handler must not be null");
            this.zzagr = handler.getLooper();
            return this;
        }

        public Builder addConnectionCallbacks(@NonNull ConnectionCallbacks listener) {
            com.google.android.gms.common.internal.zzx.zzb(listener, (Object)"Listener must not be null");
            this.zzagu.add(listener);
            return this;
        }

        public Builder addOnConnectionFailedListener(@NonNull OnConnectionFailedListener listener) {
            com.google.android.gms.common.internal.zzx.zzb(listener, (Object)"Listener must not be null");
            this.zzagv.add(listener);
            return this;
        }

        public Builder setViewForPopups(@NonNull View viewForPopups) {
            com.google.android.gms.common.internal.zzx.zzb(viewForPopups, (Object)"View must not be null");
            this.zzagk = viewForPopups;
            return this;
        }

        public Builder addScope(@NonNull Scope scope) {
            com.google.android.gms.common.internal.zzx.zzb(scope, (Object)"Scope must not be null");
            this.zzagh.add(scope);
            return this;
        }

        public Builder addApi(@NonNull Api<? extends Api.ApiOptions.NotRequiredOptions> api) {
            com.google.android.gms.common.internal.zzx.zzb(api, (Object)"Api must not be null");
            this.zzagn.put(api, null);
            List<Scope> list = api.zzoP().zzo(null);
            this.zzagi.addAll(list);
            this.zzagh.addAll(list);
            return this;
        }

        public Builder addApiIfAvailable(@NonNull Api<? extends Api.ApiOptions.NotRequiredOptions> api, Scope ... scopes) {
            com.google.android.gms.common.internal.zzx.zzb(api, (Object)"Api must not be null");
            this.zzagn.put(api, null);
            this.zza(api, null, 1, scopes);
            return this;
        }

        public <O extends Api.ApiOptions.HasOptions> Builder addApi(@NonNull Api<O> api, @NonNull O options) {
            com.google.android.gms.common.internal.zzx.zzb(api, (Object)"Api must not be null");
            com.google.android.gms.common.internal.zzx.zzb(options, (Object)"Null options are not permitted for this Api");
            this.zzagn.put(api, options);
            List<Scope> list = api.zzoP().zzo(options);
            this.zzagi.addAll(list);
            this.zzagh.addAll(list);
            return this;
        }

        public <O extends Api.ApiOptions.HasOptions> Builder addApiIfAvailable(@NonNull Api<O> api, @NonNull O options, Scope ... scopes) {
            com.google.android.gms.common.internal.zzx.zzb(api, (Object)"Api must not be null");
            com.google.android.gms.common.internal.zzx.zzb(options, (Object)"Null options are not permitted for this Api");
            this.zzagn.put(api, options);
            this.zza(api, options, 1, scopes);
            return this;
        }

        public Builder setAccountName(String accountName) {
            this.zzTI = accountName == null ? null : new Account(accountName, "com.google");
            return this;
        }

        public Builder useDefaultAccount() {
            return this.setAccountName("<<default account>>");
        }

        public Builder setGravityForPopups(int gravityForPopups) {
            this.zzagj = gravityForPopups;
            return this;
        }

        public Builder enableAutoManage(@NonNull FragmentActivity fragmentActivity, int clientId, @Nullable OnConnectionFailedListener unresolvedConnectionFailedListener) {
            com.google.android.gms.common.internal.zzx.zzb(clientId >= 0, (Object)"clientId must be non-negative");
            this.zzagp = clientId;
            this.zzago = com.google.android.gms.common.internal.zzx.zzb(fragmentActivity, (Object)"Null activity is not permitted.");
            this.zzagq = unresolvedConnectionFailedListener;
            return this;
        }

        public Builder enableAutoManage(@NonNull FragmentActivity fragmentActivity, @Nullable OnConnectionFailedListener unresolvedConnectionFailedListener) {
            return this.enableAutoManage(fragmentActivity, 0, unresolvedConnectionFailedListener);
        }

        public zzf zzoY() {
            zzro zzro2 = zzro.zzbgV;
            if (this.zzagn.containsKey(zzrl.API)) {
                zzro2 = (zzro)this.zzagn.get(zzrl.API);
            }
            return new zzf(this.zzTI, this.zzagh, this.zzagm, this.zzagj, this.zzagk, this.zzUW, this.zzagl, zzro2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public GoogleApiClient build() {
            com.google.android.gms.common.internal.zzx.zzb(!this.zzagn.isEmpty(), (Object)"must call addApi() to add at least one API");
            GoogleApiClient googleApiClient = this.zzoZ();
            Set set = zzagg;
            synchronized (set) {
                zzagg.add(googleApiClient);
            }
            if (this.zzagp >= 0) {
                this.zze(googleApiClient);
            }
            return googleApiClient;
        }

        private GoogleApiClient zzoZ() {
            zzf zzf2 = this.zzoY();
            Api<?> api = null;
            Api<?> api2 = null;
            Map<Api<?>, zzf.zza> map = zzf2.zzqu();
            ArrayMap arrayMap = new ArrayMap();
            ArrayMap arrayMap2 = new ArrayMap();
            ArrayList<com.google.android.gms.common.api.internal.zzc> arrayList = new ArrayList<com.google.android.gms.common.api.internal.zzc>();
            for (Api<?> api3 : this.zzagn.keySet()) {
                zzad<Object> zzad2;
                Object object;
                Api.ApiOptions apiOptions = this.zzagn.get(api3);
                int n = 0;
                if (map.get(api3) != null) {
                    n = map.get(api3).zzalf ? 1 : 2;
                }
                arrayMap.put(api3, n);
                com.google.android.gms.common.api.internal.zzc zzc2 = new com.google.android.gms.common.api.internal.zzc(api3, n);
                arrayList.add(zzc2);
                if (api3.zzoS()) {
                    object = api3.zzoQ();
                    if (object.getPriority() == 1) {
                        api2 = api3;
                    }
                    zzad2 = Builder.zza(object, (Object)apiOptions, this.mContext, this.zzagr, zzf2, (ConnectionCallbacks)zzc2, (OnConnectionFailedListener)zzc2);
                } else {
                    object = api3.zzoP();
                    if (((Api.zza)object).getPriority() == 1) {
                        api2 = api3;
                    }
                    zzad2 = Builder.zza(object, (Object)apiOptions, this.mContext, this.zzagr, zzf2, (ConnectionCallbacks)zzc2, (OnConnectionFailedListener)zzc2);
                }
                arrayMap2.put(api3.zzoR(), zzad2);
                if (!zzad2.zznb()) continue;
                if (api != null) {
                    throw new IllegalStateException(api3.getName() + " cannot be used with " + api.getName());
                }
                api = api3;
            }
            if (api != null) {
                if (api2 != null) {
                    throw new IllegalStateException(api.getName() + " cannot be used with " + api2.getName());
                }
                com.google.android.gms.common.internal.zzx.zza(this.zzTI == null, "Must not set an account in GoogleApiClient.Builder when using %s. Set account in GoogleSignInOptions.Builder instead", api.getName());
                com.google.android.gms.common.internal.zzx.zza(this.zzagh.equals(this.zzagi), "Must not set scopes in GoogleApiClient.Builder when using %s. Set account in GoogleSignInOptions.Builder instead.", api.getName());
            }
            int n = zzj.zza(arrayMap2.values(), true);
            return new zzj(this.mContext, new ReentrantLock(), this.zzagr, zzf2, this.zzags, this.zzagt, (Map<Api<?>, Integer>)arrayMap, (List<ConnectionCallbacks>)this.zzagu, (List<OnConnectionFailedListener>)this.zzagv, (Map<Api.zzc<?>, Api.zzb>)arrayMap2, this.zzagp, n, arrayList);
        }

        private void zze(final GoogleApiClient googleApiClient) {
            zzw zzw2 = zzw.zza(this.zzago);
            if (zzw2 == null) {
                Handler handler = new Handler(this.mContext.getMainLooper());
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (Builder.this.zzago.isFinishing() || Builder.this.zzago.getSupportFragmentManager().isDestroyed()) {
                            return;
                        }
                        Builder.this.zza(zzw.zzb(Builder.this.zzago), googleApiClient);
                    }
                });
            } else {
                this.zza(zzw2, googleApiClient);
            }
        }

        private void zza(zzw zzw2, GoogleApiClient googleApiClient) {
            zzw2.zza(this.zzagp, googleApiClient, this.zzagq);
        }

        private <O extends Api.ApiOptions> void zza(Api<O> api, O o, int n, Scope ... scopeArray) {
            boolean bl;
            if (n == 1) {
                bl = true;
            } else if (n == 2) {
                bl = false;
            } else {
                throw new IllegalArgumentException("Invalid resolution mode: '" + n + "', use a constant from GoogleApiClient.ResolutionMode");
            }
            HashSet<Scope> hashSet = new HashSet<Scope>(api.zzoP().zzo(o));
            for (Scope scope : scopeArray) {
                hashSet.add(scope);
            }
            this.zzagm.put(api, new zzf.zza(hashSet, bl));
        }

        private static <C extends Api.zzb, O> C zza(Api.zza<C, O> zza2, Object object, Context context, Looper looper, zzf zzf2, ConnectionCallbacks connectionCallbacks, OnConnectionFailedListener onConnectionFailedListener) {
            return zza2.zza(context, looper, zzf2, object, connectionCallbacks, onConnectionFailedListener);
        }

        private static <C extends Api.zzd, O> zzad zza(Api.zze<C, O> zze2, Object object, Context context, Looper looper, zzf zzf2, ConnectionCallbacks connectionCallbacks, OnConnectionFailedListener onConnectionFailedListener) {
            return new zzad(context, looper, zze2.zzoU(), connectionCallbacks, onConnectionFailedListener, zzf2, (Api.zzd)zze2.zzq(object));
        }
    }

    public static interface zza {
        public void zza(@NonNull ConnectionResult var1);
    }

    public static interface OnConnectionFailedListener {
        public void onConnectionFailed(@NonNull ConnectionResult var1);
    }

    public static interface ConnectionCallbacks {
        public static final int CAUSE_SERVICE_DISCONNECTED = 1;
        public static final int CAUSE_NETWORK_LOST = 2;

        public void onConnected(@Nullable Bundle var1);

        public void onConnectionSuspended(int var1);
    }
}

