/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.WorkSource;
import android.util.Log;
import com.google.android.gms.internal.zzne;
import com.google.android.gms.internal.zzni;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class zznj {
    private static final Method zzaol = zznj.zzsp();
    private static final Method zzaom = zznj.zzsq();
    private static final Method zzaon = zznj.zzsr();
    private static final Method zzaoo = zznj.zzss();
    private static final Method zzaop = zznj.zzst();

    public static WorkSource zzf(int n, String string) {
        WorkSource workSource = new WorkSource();
        zznj.zza(workSource, n, string);
        return workSource;
    }

    public static WorkSource zzl(Context context, String string) {
        if (context == null || context.getPackageManager() == null) {
            return null;
        }
        ApplicationInfo applicationInfo = null;
        try {
            applicationInfo = context.getPackageManager().getApplicationInfo(string, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            Log.e((String)"WorkSourceUtil", (String)("Could not find package: " + string));
            return null;
        }
        if (applicationInfo == null) {
            Log.e((String)"WorkSourceUtil", (String)("Could not get applicationInfo from package: " + string));
            return null;
        }
        return zznj.zzf(applicationInfo.uid, string);
    }

    public static void zza(WorkSource workSource, int n, String string) {
        if (zzaom != null) {
            if (string == null) {
                string = "";
            }
            try {
                zzaom.invoke((Object)workSource, n, string);
            }
            catch (Exception exception) {
                Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            }
            return;
        }
        if (zzaol != null) {
            try {
                zzaol.invoke((Object)workSource, n);
            }
            catch (Exception exception) {
                Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            }
        }
    }

    public static int zza(WorkSource workSource) {
        if (zzaon != null) {
            try {
                return (Integer)zzaon.invoke((Object)workSource, new Object[0]);
            }
            catch (Exception exception) {
                Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            }
        }
        return 0;
    }

    public static String zza(WorkSource workSource, int n) {
        if (zzaop != null) {
            try {
                return (String)zzaop.invoke((Object)workSource, n);
            }
            catch (Exception exception) {
                Log.wtf((String)"WorkSourceUtil", (String)"Unable to assign blame through WorkSource", (Throwable)exception);
            }
        }
        return null;
    }

    public static List<String> zzb(WorkSource workSource) {
        int n;
        int n2 = n = workSource == null ? 0 : zznj.zza(workSource);
        if (n == 0) {
            return Collections.EMPTY_LIST;
        }
        String string = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            string = zznj.zza(workSource, i);
            if (zzni.zzcV(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static boolean zzaA(Context context) {
        if (context == null) {
            return false;
        }
        PackageManager packageManager = context.getPackageManager();
        if (packageManager == null) {
            return false;
        }
        int n = packageManager.checkPermission("android.permission.UPDATE_DEVICE_STATS", context.getPackageName());
        return n == 0;
    }

    private static Method zzsp() {
        Method method = null;
        try {
            method = WorkSource.class.getMethod("add", Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method;
    }

    private static Method zzsq() {
        Method method = null;
        if (zzne.zzsj()) {
            try {
                method = WorkSource.class.getMethod("add", Integer.TYPE, String.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return method;
    }

    private static Method zzsr() {
        Method method = null;
        try {
            method = WorkSource.class.getMethod("size", new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method;
    }

    private static Method zzss() {
        Method method = null;
        try {
            method = WorkSource.class.getMethod("get", Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return method;
    }

    private static Method zzst() {
        Method method = null;
        if (zzne.zzsj()) {
            try {
                method = WorkSource.class.getMethod("getName", Integer.TYPE);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return method;
    }
}

