/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.annotation.TargetApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzm;
import com.google.android.gms.common.internal.zzz;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

final class zzn
extends zzm
implements Handler.Callback {
    private final HashMap<zza, zzb> zzarR = new HashMap();
    private final Context zztm;
    private final Handler mHandler;
    private final com.google.android.gms.common.stats.zzb zzarS;
    private final long zzarT;

    zzn(Context context) {
        this.zztm = context.getApplicationContext();
        this.mHandler = new Handler(context.getMainLooper(), (Handler.Callback)this);
        this.zzarS = com.google.android.gms.common.stats.zzb.zzuH();
        this.zzarT = 5000L;
    }

    @Override
    public boolean zza(String string2, String string3, ServiceConnection serviceConnection, String string4) {
        return this.zza(new zza(string2, string3), serviceConnection, string4);
    }

    @Override
    public boolean zza(ComponentName componentName, ServiceConnection serviceConnection, String string2) {
        return this.zza(new zza(componentName), serviceConnection, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean zza(zza zza2, ServiceConnection serviceConnection, String string2) {
        zzaa.zzb(serviceConnection, (Object)"ServiceConnection must not be null");
        HashMap<zza, zzb> hashMap = this.zzarR;
        synchronized (hashMap) {
            zzb zzb2 = this.zzarR.get(zza2);
            if (zzb2 == null) {
                zzb2 = new zzb(zza2);
                zzb2.zza(serviceConnection, string2);
                zzb2.zzdg(string2);
                this.zzarR.put(zza2, zzb2);
            } else {
                this.mHandler.removeMessages(0, (Object)zzb2);
                if (zzb2.zza(serviceConnection)) {
                    String string3 = String.valueOf(zza2);
                    throw new IllegalStateException(new StringBuilder(81 + String.valueOf(string3).length()).append("Trying to bind a GmsServiceConnection that was already connected before.  config=").append(string3).toString());
                }
                zzb2.zza(serviceConnection, string2);
                switch (zzb2.getState()) {
                    case 1: {
                        serviceConnection.onServiceConnected(zzb2.getComponentName(), zzb2.getBinder());
                        break;
                    }
                    case 2: {
                        zzb2.zzdg(string2);
                    }
                }
            }
            return zzb2.isBound();
        }
    }

    @Override
    public void zzb(String string2, String string3, ServiceConnection serviceConnection, String string4) {
        this.zzb(new zza(string2, string3), serviceConnection, string4);
    }

    @Override
    public void zzb(ComponentName componentName, ServiceConnection serviceConnection, String string2) {
        this.zzb(new zza(componentName), serviceConnection, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zzb(zza zza2, ServiceConnection serviceConnection, String string2) {
        zzaa.zzb(serviceConnection, (Object)"ServiceConnection must not be null");
        HashMap<zza, zzb> hashMap = this.zzarR;
        synchronized (hashMap) {
            zzb zzb2 = this.zzarR.get(zza2);
            if (zzb2 == null) {
                String string3 = String.valueOf(zza2);
                throw new IllegalStateException(new StringBuilder(50 + String.valueOf(string3).length()).append("Nonexistent connection status for service config: ").append(string3).toString());
            }
            if (!zzb2.zza(serviceConnection)) {
                String string4 = String.valueOf(zza2);
                throw new IllegalStateException(new StringBuilder(76 + String.valueOf(string4).length()).append("Trying to unbind a GmsServiceConnection  that was not bound before.  config=").append(string4).toString());
            }
            zzb2.zzb(serviceConnection, string2);
            if (zzb2.zztL()) {
                Message message = this.mHandler.obtainMessage(0, (Object)zzb2);
                this.mHandler.sendMessageDelayed(message, this.zzarT);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleMessage(Message message) {
        switch (message.what) {
            case 0: {
                zzb zzb2 = (zzb)message.obj;
                HashMap<zza, zzb> hashMap = this.zzarR;
                synchronized (hashMap) {
                    if (zzb2.zztL()) {
                        if (zzb2.isBound()) {
                            zzb2.zzdh("GmsClientSupervisor");
                        }
                        this.zzarR.remove(zzb2.zzarZ);
                    }
                }
                return true;
            }
        }
        return false;
    }

    private static final class zza {
        private final String zzVt;
        private final String zzarU;
        private final ComponentName zzarV;

        public zza(String string2, String string3) {
            this.zzVt = zzaa.zzdl(string2);
            this.zzarU = zzaa.zzdl(string3);
            this.zzarV = null;
        }

        public zza(ComponentName componentName) {
            this.zzVt = null;
            this.zzarU = null;
            this.zzarV = zzaa.zzz(componentName);
        }

        public String toString() {
            return this.zzVt == null ? this.zzarV.flattenToString() : this.zzVt;
        }

        public Intent zztK() {
            Intent intent = this.zzVt != null ? new Intent(this.zzVt).setPackage(this.zzarU) : new Intent().setComponent(this.zzarV);
            return intent;
        }

        public int hashCode() {
            return zzz.hashCode(this.zzVt, this.zzarV);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof zza)) {
                return false;
            }
            zza zza2 = (zza)object;
            return zzz.equal(this.zzVt, zza2.zzVt) && zzz.equal(this.zzarV, zza2.zzarV);
        }
    }

    private final class zzb {
        private final zza zzarW;
        private final Set<ServiceConnection> zzarX;
        private int mState;
        private boolean zzarY;
        private IBinder zzaqQ;
        private final com.google.android.gms.common.internal.zzn$zza zzarZ;
        private ComponentName zzarV;

        public zzb(com.google.android.gms.common.internal.zzn$zza zza2) {
            this.zzarZ = zza2;
            this.zzarW = new zza();
            this.zzarX = new HashSet<ServiceConnection>();
            this.mState = 2;
        }

        @TargetApi(value=14)
        public void zzdg(String string2) {
            this.mState = 3;
            this.zzarY = zzn.this.zzarS.zza(zzn.this.zztm, string2, this.zzarZ.zztK(), this.zzarW, 129);
            if (!this.zzarY) {
                this.mState = 2;
                try {
                    zzn.this.zzarS.zza(zzn.this.zztm, this.zzarW);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }

        public void zzdh(String string2) {
            zzn.this.zzarS.zza(zzn.this.zztm, this.zzarW);
            this.zzarY = false;
            this.mState = 2;
        }

        public void zza(ServiceConnection serviceConnection, String string2) {
            zzn.this.zzarS.zza(zzn.this.zztm, serviceConnection, string2, this.zzarZ.zztK());
            this.zzarX.add(serviceConnection);
        }

        public void zzb(ServiceConnection serviceConnection, String string2) {
            zzn.this.zzarS.zzb(zzn.this.zztm, serviceConnection);
            this.zzarX.remove(serviceConnection);
        }

        public boolean isBound() {
            return this.zzarY;
        }

        public int getState() {
            return this.mState;
        }

        public boolean zza(ServiceConnection serviceConnection) {
            return this.zzarX.contains(serviceConnection);
        }

        public boolean zztL() {
            return this.zzarX.isEmpty();
        }

        public IBinder getBinder() {
            return this.zzaqQ;
        }

        public ComponentName getComponentName() {
            return this.zzarV;
        }

        public class zza
        implements ServiceConnection {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                HashMap hashMap = zzn.this.zzarR;
                synchronized (hashMap) {
                    zzb.this.zzaqQ = iBinder;
                    zzb.this.zzarV = componentName;
                    for (ServiceConnection serviceConnection : zzb.this.zzarX) {
                        serviceConnection.onServiceConnected(componentName, iBinder);
                    }
                    zzb.this.mState = 1;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceDisconnected(ComponentName componentName) {
                HashMap hashMap = zzn.this.zzarR;
                synchronized (hashMap) {
                    zzb.this.zzaqQ = null;
                    zzb.this.zzarV = componentName;
                    for (ServiceConnection serviceConnection : zzb.this.zzarX) {
                        serviceConnection.onServiceDisconnected(componentName);
                    }
                    zzb.this.mState = 2;
                }
            }
        }
    }
}

