/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzamg;

public final class zzamf
implements Cloneable {
    private static final zzamg zzcac = new zzamg();
    private boolean zzcad = false;
    private int[] zzcae;
    private zzamg[] zzcaf;
    private int mSize;

    zzamf() {
        this(10);
    }

    zzamf(int n) {
        n = this.idealIntArraySize(n);
        this.zzcae = new int[n];
        this.zzcaf = new zzamg[n];
        this.mSize = 0;
    }

    zzamg zzok(int n) {
        int n2 = this.zzom(n);
        if (n2 < 0 || this.zzcaf[n2] == zzcac) {
            return null;
        }
        return this.zzcaf[n2];
    }

    void remove(int n) {
        int n2 = this.zzom(n);
        if (n2 >= 0 && this.zzcaf[n2] != zzcac) {
            this.zzcaf[n2] = zzcac;
            this.zzcad = true;
        }
    }

    private void gc() {
        int n = this.mSize;
        int n2 = 0;
        int[] nArray = this.zzcae;
        zzamg[] zzamgArray = this.zzcaf;
        for (int i = 0; i < n; ++i) {
            zzamg zzamg2 = zzamgArray[i];
            if (zzamg2 == zzcac) continue;
            if (i != n2) {
                nArray[n2] = nArray[i];
                zzamgArray[n2] = zzamg2;
                zzamgArray[i] = null;
            }
            ++n2;
        }
        this.zzcad = false;
        this.mSize = n2;
    }

    void zza(int n, zzamg zzamg2) {
        int n2 = this.zzom(n);
        if (n2 >= 0) {
            this.zzcaf[n2] = zzamg2;
        } else {
            if ((n2 ^= 0xFFFFFFFF) < this.mSize && this.zzcaf[n2] == zzcac) {
                this.zzcae[n2] = n;
                this.zzcaf[n2] = zzamg2;
                return;
            }
            if (this.zzcad && this.mSize >= this.zzcae.length) {
                this.gc();
                n2 = ~this.zzom(n);
            }
            if (this.mSize >= this.zzcae.length) {
                int n3 = this.idealIntArraySize(this.mSize + 1);
                int[] nArray = new int[n3];
                zzamg[] zzamgArray = new zzamg[n3];
                System.arraycopy(this.zzcae, 0, nArray, 0, this.zzcae.length);
                System.arraycopy(this.zzcaf, 0, zzamgArray, 0, this.zzcaf.length);
                this.zzcae = nArray;
                this.zzcaf = zzamgArray;
            }
            if (this.mSize - n2 != 0) {
                System.arraycopy(this.zzcae, n2, this.zzcae, n2 + 1, this.mSize - n2);
                System.arraycopy(this.zzcaf, n2, this.zzcaf, n2 + 1, this.mSize - n2);
            }
            this.zzcae[n2] = n;
            this.zzcaf[n2] = zzamg2;
            ++this.mSize;
        }
    }

    int size() {
        if (this.zzcad) {
            this.gc();
        }
        return this.mSize;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    zzamg zzol(int n) {
        if (this.zzcad) {
            this.gc();
        }
        return this.zzcaf[n];
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof zzamf)) {
            return false;
        }
        zzamf zzamf2 = (zzamf)object;
        if (this.size() != zzamf2.size()) {
            return false;
        }
        return this.zza(this.zzcae, zzamf2.zzcae, this.mSize) && this.zza(this.zzcaf, zzamf2.zzcaf, this.mSize);
    }

    public int hashCode() {
        if (this.zzcad) {
            this.gc();
        }
        int n = 17;
        for (int i = 0; i < this.mSize; ++i) {
            n = 31 * n + this.zzcae[i];
            n = 31 * n + this.zzcaf[i].hashCode();
        }
        return n;
    }

    private int idealIntArraySize(int n) {
        return this.idealByteArraySize(n * 4) / 4;
    }

    private int idealByteArraySize(int n) {
        for (int i = 4; i < 32; ++i) {
            if (n > (1 << i) - 12) continue;
            return (1 << i) - 12;
        }
        return n;
    }

    private int zzom(int n) {
        int n2 = 0;
        int n3 = this.mSize - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >>> 1;
            int n5 = this.zzcae[n4];
            if (n5 < n) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > n) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return ~n2;
    }

    private boolean zza(int[] nArray, int[] nArray2, int n) {
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    private boolean zza(zzamg[] zzamgArray, zzamg[] zzamgArray2, int n) {
        for (int i = 0; i < n; ++i) {
            if (zzamgArray[i].equals(zzamgArray2[i])) continue;
            return false;
        }
        return true;
    }

    public final zzamf zzWV() {
        int n = this.size();
        zzamf zzamf2 = new zzamf(n);
        System.arraycopy(this.zzcae, 0, zzamf2.zzcae, 0, n);
        for (int i = 0; i < n; ++i) {
            if (this.zzcaf[i] == null) continue;
            zzamf2.zzcaf[i] = (zzamg)this.zzcaf[i].clone();
        }
        zzamf2.mSize = n;
        return zzamf2;
    }

    public /* synthetic */ Object clone() throws CloneNotSupportedException {
        return this.zzWV();
    }
}

