/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.phenotype;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.phenotype.zzb;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Comparator;

public class Flag
extends AbstractSafeParcelable
implements Comparable<Flag> {
    public static final Parcelable.Creator<Flag> CREATOR = new zzb();
    final int mVersionCode;
    public final String name;
    final long asc;
    final boolean abu;
    final double abw;
    final String zr;
    final byte[] asd;
    public final int ase;
    public final int asf;
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final zza asg = new zza();

    Flag(int n, String string, long l, boolean bl, double d, String string2, byte[] byArray, int n2, int n3) {
        this.mVersionCode = n;
        this.name = string;
        this.asc = l;
        this.abu = bl;
        this.abw = d;
        this.zr = string2;
        this.asd = byArray;
        this.ase = n2;
        this.asf = n3;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Flag(");
        stringBuilder.append(this.mVersionCode);
        stringBuilder.append(", ");
        stringBuilder.append(this.name);
        stringBuilder.append(", ");
        switch (this.ase) {
            case 1: {
                stringBuilder.append(this.asc);
                break;
            }
            case 2: {
                stringBuilder.append(this.abu);
                break;
            }
            case 3: {
                stringBuilder.append(this.abw);
                break;
            }
            case 4: {
                stringBuilder.append("'");
                stringBuilder.append(this.zr);
                stringBuilder.append("'");
                break;
            }
            case 5: {
                if (this.asd == null) {
                    stringBuilder.append("null");
                    break;
                }
                stringBuilder.append("'");
                stringBuilder.append(new String(this.asd, UTF_8));
                stringBuilder.append("'");
                break;
            }
            default: {
                int n = this.ase;
                throw new AssertionError((Object)new StringBuilder(31).append("Invalid enum value: ").append(n).toString());
            }
        }
        stringBuilder.append(", ");
        stringBuilder.append(this.ase);
        stringBuilder.append(", ");
        stringBuilder.append(this.asf);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Flag) {
            Flag flag = (Flag)object;
            if (this.mVersionCode != flag.mVersionCode || !zzaa.equal(this.name, flag.name) || this.ase != flag.ase || this.asf != flag.asf) {
                return false;
            }
            switch (this.ase) {
                case 1: {
                    return this.asc == flag.asc;
                }
                case 2: {
                    return this.abu == flag.abu;
                }
                case 3: {
                    return this.abw == flag.abw;
                }
                case 4: {
                    return zzaa.equal(this.zr, flag.zr);
                }
                case 5: {
                    return Arrays.equals(this.asd, flag.asd);
                }
            }
            int n = this.ase;
            throw new AssertionError((Object)new StringBuilder(31).append("Invalid enum value: ").append(n).toString());
        }
        return false;
    }

    public int zza(Flag flag) {
        int n = this.name.compareTo(flag.name);
        if (n != 0) {
            return n;
        }
        n = Flag.compare(this.ase, flag.ase);
        if (n != 0) {
            return n;
        }
        switch (this.ase) {
            case 1: {
                return Flag.compare(this.asc, flag.asc);
            }
            case 2: {
                return Flag.compare(this.abu, flag.abu);
            }
            case 3: {
                return Double.compare(this.abw, flag.abw);
            }
            case 4: {
                return Flag.compare(this.zr, flag.zr);
            }
            case 5: {
                if (this.asd == flag.asd) {
                    return 0;
                }
                if (this.asd == null) {
                    return -1;
                }
                if (flag.asd == null) {
                    return 1;
                }
                for (int i = 0; i < Math.min(this.asd.length, flag.asd.length); ++i) {
                    n = Flag.compare(this.asd[i], flag.asd[i]);
                    if (n == 0) continue;
                    return n;
                }
                return Flag.compare(this.asd.length, flag.asd.length);
            }
        }
        int n2 = this.ase;
        throw new AssertionError((Object)new StringBuilder(31).append("Invalid enum value: ").append(n2).toString());
    }

    private static int compare(String string, String string2) {
        if (string == string2) {
            return 0;
        }
        if (string == null) {
            return -1;
        }
        if (string2 == null) {
            return 1;
        }
        return string.compareTo(string2);
    }

    private static int compare(int n, int n2) {
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    private static int compare(long l, long l2) {
        return l < l2 ? -1 : (l == l2 ? 0 : 1);
    }

    private static int compare(boolean bl, boolean bl2) {
        return bl == bl2 ? 0 : (bl ? 1 : -1);
    }

    private static int compare(byte by, byte by2) {
        return by - by2;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzb.zza(this, parcel, n);
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.zza((Flag)object);
    }

    public static class zza
    implements Comparator<Flag> {
        public int zza(Flag flag, Flag flag2) {
            if (flag.asf == flag2.asf) {
                return flag.name.compareTo(flag2.name);
            }
            return flag.asf - flag2.asf;
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.zza((Flag)object, (Flag)object2);
        }
    }
}

