/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzamw;
import com.google.android.gms.internal.zzamx;
import com.google.android.gms.internal.zzamy;
import com.google.android.gms.internal.zzanc;
import com.google.android.gms.internal.zzane;
import com.google.android.gms.internal.zzanf;
import com.google.android.gms.internal.zzang;
import com.google.android.gms.internal.zzanh;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class zzamn
implements zzamx<Date>,
zzang<Date> {
    private final DateFormat bdO;
    private final DateFormat bdP;
    private final DateFormat bdQ;

    zzamn() {
        this(DateFormat.getDateTimeInstance(2, 2, Locale.US), DateFormat.getDateTimeInstance(2, 2));
    }

    zzamn(String string2) {
        this(new SimpleDateFormat(string2, Locale.US), new SimpleDateFormat(string2));
    }

    public zzamn(int n, int n2) {
        this(DateFormat.getDateTimeInstance(n, n2, Locale.US), DateFormat.getDateTimeInstance(n, n2));
    }

    zzamn(DateFormat dateFormat, DateFormat dateFormat2) {
        this.bdO = dateFormat;
        this.bdP = dateFormat2;
        this.bdQ = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        this.bdQ.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public zzamy zza(Date date, Type type, zzanf zzanf2) {
        DateFormat dateFormat = this.bdP;
        synchronized (dateFormat) {
            String string2 = this.bdO.format(date);
            return new zzane(string2);
        }
    }

    public Date zza(zzamy zzamy2, Type type, zzamw zzamw2) throws zzanc {
        if (!(zzamy2 instanceof zzane)) {
            throw new zzanc("The date should be a string value");
        }
        Date date = this.zza(zzamy2);
        if (type == Date.class) {
            return date;
        }
        if (type == Timestamp.class) {
            return new Timestamp(date.getTime());
        }
        if (type == java.sql.Date.class) {
            return new java.sql.Date(date.getTime());
        }
        String string2 = String.valueOf(this.getClass());
        String string3 = String.valueOf(type);
        throw new IllegalArgumentException(new StringBuilder(23 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(" cannot deserialize to ").append(string3).toString());
    }

    private Date zza(zzamy zzamy2) {
        DateFormat dateFormat = this.bdP;
        synchronized (dateFormat) {
            try {
                return this.bdP.parse(zzamy2.zzczh());
            }
            catch (ParseException parseException) {
                try {
                    return this.bdO.parse(zzamy2.zzczh());
                }
                catch (ParseException parseException2) {
                    try {
                        return this.bdQ.parse(zzamy2.zzczh());
                    }
                    catch (ParseException parseException3) {
                        throw new zzanh(zzamy2.zzczh(), parseException3);
                    }
                }
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(zzamn.class.getSimpleName());
        stringBuilder.append('(').append(this.bdP.getClass().getSimpleName()).append(')');
        return stringBuilder.toString();
    }

    @Override
    public /* synthetic */ Object zzb(zzamy zzamy2, Type type, zzamw zzamw2) throws zzanc {
        return this.zza(zzamy2, type, zzamw2);
    }
}

