/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.phenotype;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.phenotype.Flag;
import com.google.android.gms.phenotype.zza;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;

public class Configuration
extends AbstractSafeParcelable
implements Comparable<Configuration> {
    public static final Parcelable.Creator<Configuration> CREATOR = new zza();
    final int mVersionCode;
    public final int arY;
    public final Flag[] arZ;
    public final String[] asa;
    public final Map<String, Flag> asb;

    Configuration(int n, int n2, Flag[] flagArray, String[] stringArray) {
        this.mVersionCode = n;
        this.arY = n2;
        this.arZ = flagArray;
        this.asb = new TreeMap<String, Flag>();
        for (Flag flag : flagArray) {
            this.asb.put(flag.name, flag);
        }
        this.asa = stringArray;
        if (this.asa != null) {
            Arrays.sort(this.asa);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Configuration(");
        stringBuilder.append(this.mVersionCode);
        stringBuilder.append(", ");
        stringBuilder.append(this.arY);
        stringBuilder.append(", ");
        stringBuilder.append("(");
        for (Flag flag : this.asb.values()) {
            stringBuilder.append(flag);
            stringBuilder.append(", ");
        }
        stringBuilder.append(")");
        stringBuilder.append(", ");
        stringBuilder.append("(");
        if (this.asa != null) {
            for (String string2 : this.asa) {
                stringBuilder.append(string2);
                stringBuilder.append(", ");
            }
        } else {
            stringBuilder.append("null");
        }
        stringBuilder.append(")");
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Configuration) {
            Configuration configuration = (Configuration)object;
            return this.mVersionCode == configuration.mVersionCode && this.arY == configuration.arY && zzaa.equal(this.asb, configuration.asb) && Arrays.equals(this.asa, configuration.asa);
        }
        return false;
    }

    public int zza(Configuration configuration) {
        return this.arY - configuration.arY;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zza.zza(this, parcel, n);
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.zza((Configuration)object);
    }
}

