/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.zzf;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzaa;

public final class Status
extends AbstractSafeParcelable
implements Result,
ReflectedParcelable {
    public static final Status sq = new Status(0);
    public static final Status sr = new Status(14);
    public static final Status ss = new Status(8);
    public static final Status st = new Status(15);
    public static final Status su = new Status(16);
    public static final Status sv = new Status(17);
    public static final Status sw = new Status(18);
    public static final Parcelable.Creator<Status> CREATOR = new zzf();
    private final int mVersionCode;
    private final int ok;
    private final String rc;
    private final PendingIntent mPendingIntent;

    Status(int n, int n2, String string2, PendingIntent pendingIntent) {
        this.mVersionCode = n;
        this.ok = n2;
        this.rc = string2;
        this.mPendingIntent = pendingIntent;
    }

    public Status(int n) {
        this(n, null);
    }

    public Status(int n, String string2) {
        this(1, n, string2, null);
    }

    public Status(int n, String string2, PendingIntent pendingIntent) {
        this(1, n, string2, pendingIntent);
    }

    public void startResolutionForResult(Activity activity, int n) throws IntentSender.SendIntentException {
        if (!this.hasResolution()) {
            return;
        }
        activity.startIntentSenderForResult(this.mPendingIntent.getIntentSender(), n, null, 0, 0, 0);
    }

    PendingIntent zzaol() {
        return this.mPendingIntent;
    }

    @Nullable
    public String getStatusMessage() {
        return this.rc;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public boolean hasResolution() {
        return this.mPendingIntent != null;
    }

    public boolean isSuccess() {
        return this.ok <= 0;
    }

    public boolean isCanceled() {
        return this.ok == 16;
    }

    public boolean isInterrupted() {
        return this.ok == 14;
    }

    public int getStatusCode() {
        return this.ok;
    }

    public PendingIntent getResolution() {
        return this.mPendingIntent;
    }

    public int hashCode() {
        return zzaa.hashCode(this.mVersionCode, this.ok, this.rc, this.mPendingIntent);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Status)) {
            return false;
        }
        Status status = (Status)object;
        return this.mVersionCode == status.mVersionCode && this.ok == status.ok && zzaa.equal(this.rc, status.rc) && zzaa.equal(this.mPendingIntent, status.mPendingIntent);
    }

    private String zzaom() {
        if (this.rc != null) {
            return this.rc;
        }
        return CommonStatusCodes.getStatusCodeString(this.ok);
    }

    public String toString() {
        return zzaa.zzx(this).zzg("statusCode", this.zzaom()).zzg("resolution", this.mPendingIntent).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzf.zza(this, parcel, n);
    }

    @Override
    public Status getStatus() {
        return this;
    }
}

