/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.server.response;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.server.converter.ConverterWrapper;
import com.google.android.gms.common.server.response.FieldMappingDictionary;
import com.google.android.gms.common.server.response.SafeParcelResponse;
import com.google.android.gms.common.util.zzc;
import com.google.android.gms.common.util.zzp;
import com.google.android.gms.common.util.zzq;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class FastJsonResponse {
    public abstract Map<String, Field<?, ?>> zzatv();

    protected abstract Object zzhs(String var1);

    protected boolean zza(Field field) {
        if (field.zzatu() == 11) {
            if (field.zzatz()) {
                return this.zzhv(field.zzaua());
            }
            return this.zzhu(field.zzaua());
        }
        return this.zzht(field.zzaua());
    }

    protected abstract boolean zzht(String var1);

    protected boolean zzhu(String string2) {
        throw new UnsupportedOperationException("Concrete types not supported");
    }

    protected boolean zzhv(String string2) {
        throw new UnsupportedOperationException("Concrete type arrays not supported");
    }

    protected <O, I> I zza(Field<I, O> field, Object object) {
        if (((Field)field).zO != null) {
            return field.convertBack(object);
        }
        return (I)object;
    }

    public HashMap<String, Object> zzatw() {
        return null;
    }

    public HashMap<String, Object> zzatx() {
        return null;
    }

    public String toString() {
        Map<String, Field<?, ?>> map = this.zzatv();
        StringBuilder stringBuilder = new StringBuilder(100);
        block5: for (String string2 : map.keySet()) {
            Field<?, ?> field = map.get(string2);
            if (!this.zza(field)) continue;
            Object object = this.zzb(field);
            Object obj = this.zza(field, object);
            if (stringBuilder.length() == 0) {
                stringBuilder.append("{");
            } else {
                stringBuilder.append(",");
            }
            stringBuilder.append("\"").append(string2).append("\":");
            if (obj == null) {
                stringBuilder.append("null");
                continue;
            }
            switch (field.zzatu()) {
                case 8: {
                    stringBuilder.append("\"").append(zzc.zzp((byte[])obj)).append("\"");
                    continue block5;
                }
                case 9: {
                    stringBuilder.append("\"").append(zzc.zzq((byte[])obj)).append("\"");
                    continue block5;
                }
                case 10: {
                    HashMap hashMap = (HashMap)obj;
                    zzq.zza(stringBuilder, hashMap);
                    continue block5;
                }
            }
            if (field.zzaty()) {
                this.zza(stringBuilder, field, (ArrayList)obj);
                continue;
            }
            this.zza(stringBuilder, field, obj);
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.append("}");
        } else {
            stringBuilder.append("{}");
        }
        return stringBuilder.toString();
    }

    protected Object zzb(Field field) {
        String string2 = field.zzaua();
        if (field.zzauc() != null) {
            HashMap<String, Object> hashMap;
            zzab.zza(this.zzhs(field.zzaua()) == null, "Concrete field shouldn't be value object: %s", field.zzaua());
            HashMap<String, Object> hashMap2 = hashMap = field.zzatz() ? this.zzatx() : this.zzatw();
            if (hashMap != null) {
                return hashMap.get(string2);
            }
            try {
                char c = Character.toUpperCase(string2.charAt(0));
                String string3 = String.valueOf(string2.substring(1));
                String string4 = new StringBuilder(4 + String.valueOf(string3).length()).append("get").append(c).append(string3).toString();
                return this.getClass().getMethod(string4, new Class[0]).invoke((Object)this, new Object[0]);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return this.zzhs(field.zzaua());
    }

    private void zza(StringBuilder stringBuilder, Field field, Object object) {
        if (field.zzatt() == 11) {
            Class<FastJsonResponse> clazz = field.zzauc();
            stringBuilder.append(clazz.cast(object).toString());
        } else if (field.zzatt() == 7) {
            stringBuilder.append("\"");
            stringBuilder.append(zzp.zzia((String)object));
            stringBuilder.append("\"");
        } else {
            stringBuilder.append(object);
        }
    }

    private void zza(StringBuilder stringBuilder, Field field, ArrayList<Object> arrayList) {
        stringBuilder.append("[");
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            if (i > 0) {
                stringBuilder.append(",");
            }
            if ((object = arrayList.get(i)) == null) continue;
            this.zza(stringBuilder, field, object);
        }
        stringBuilder.append("]");
    }

    public static interface zza<I, O> {
        public int zzatt();

        public int zzatu();

        public I convertBack(O var1);
    }

    public static class Field<I, O>
    extends AbstractSafeParcelable {
        private final int mVersionCode;
        protected final int zF;
        protected final boolean zG;
        protected final int zH;
        protected final boolean zI;
        protected final String zJ;
        protected final int zK;
        protected final Class<? extends FastJsonResponse> zL;
        protected final String zM;
        private FieldMappingDictionary zN;
        private zza<I, O> zO;
        public static final com.google.android.gms.common.server.response.zza CREATOR = new com.google.android.gms.common.server.response.zza();

        Field(int n, int n2, boolean bl, int n3, boolean bl2, String string2, int n4, String string3, ConverterWrapper converterWrapper) {
            this.mVersionCode = n;
            this.zF = n2;
            this.zG = bl;
            this.zH = n3;
            this.zI = bl2;
            this.zJ = string2;
            this.zK = n4;
            if (string3 == null) {
                this.zL = null;
                this.zM = null;
            } else {
                this.zL = SafeParcelResponse.class;
                this.zM = string3;
            }
            this.zO = converterWrapper == null ? null : converterWrapper.zzatr();
        }

        protected Field(int n, boolean bl, int n2, boolean bl2, String string2, int n3, Class<? extends FastJsonResponse> clazz, zza<I, O> zza2) {
            this.mVersionCode = 1;
            this.zF = n;
            this.zG = bl;
            this.zH = n2;
            this.zI = bl2;
            this.zJ = string2;
            this.zK = n3;
            this.zL = clazz;
            this.zM = clazz == null ? null : clazz.getCanonicalName();
            this.zO = zza2;
        }

        public int getVersionCode() {
            return this.mVersionCode;
        }

        public int zzatt() {
            return this.zF;
        }

        public boolean zzaty() {
            return this.zG;
        }

        public int zzatu() {
            return this.zH;
        }

        public boolean zzatz() {
            return this.zI;
        }

        public String zzaua() {
            return this.zJ;
        }

        public int zzaub() {
            return this.zK;
        }

        public Class<? extends FastJsonResponse> zzauc() {
            return this.zL;
        }

        String zzaud() {
            if (this.zM == null) {
                return null;
            }
            return this.zM;
        }

        public boolean zzaue() {
            return this.zO != null;
        }

        public void zza(FieldMappingDictionary fieldMappingDictionary) {
            this.zN = fieldMappingDictionary;
        }

        ConverterWrapper zzauf() {
            if (this.zO == null) {
                return null;
            }
            return ConverterWrapper.zza(this.zO);
        }

        public Map<String, Field<?, ?>> zzaug() {
            zzab.zzy(this.zM);
            zzab.zzy(this.zN);
            return this.zN.zzhw(this.zM);
        }

        public I convertBack(O o) {
            return this.zO.convertBack(o);
        }

        public static Field<Integer, Integer> zzj(String string2, int n) {
            return new Field<Integer, Integer>(0, false, 0, false, string2, n, null, null);
        }

        public static Field<Boolean, Boolean> zzk(String string2, int n) {
            return new Field<Boolean, Boolean>(6, false, 6, false, string2, n, null, null);
        }

        public static Field<String, String> zzl(String string2, int n) {
            return new Field<String, String>(7, false, 7, false, string2, n, null, null);
        }

        public static <T extends FastJsonResponse> Field<T, T> zza(String string2, int n, Class<T> clazz) {
            return new Field(11, false, 11, false, string2, n, clazz, null);
        }

        public static <T extends FastJsonResponse> Field<ArrayList<T>, ArrayList<T>> zzb(String string2, int n, Class<T> clazz) {
            return new Field<ArrayList<T>, ArrayList<T>>(11, true, 11, true, string2, n, clazz, null);
        }

        public static Field zza(String string2, int n, zza<?, ?> zza2, boolean bl) {
            return new Field(zza2.zzatt(), bl, zza2.zzatu(), false, string2, n, null, zza2);
        }

        public void writeToParcel(Parcel parcel, int n) {
            com.google.android.gms.common.server.response.zza.zza(this, parcel, n);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Field\n");
            stringBuilder.append("            versionCode=").append(this.mVersionCode).append('\n');
            stringBuilder.append("                 typeIn=").append(this.zF).append('\n');
            stringBuilder.append("            typeInArray=").append(this.zG).append('\n');
            stringBuilder.append("                typeOut=").append(this.zH).append('\n');
            stringBuilder.append("           typeOutArray=").append(this.zI).append('\n');
            stringBuilder.append("        outputFieldName=").append(this.zJ).append('\n');
            stringBuilder.append("      safeParcelFieldId=").append(this.zK).append('\n');
            stringBuilder.append("       concreteTypeName=").append(this.zzaud()).append('\n');
            if (this.zzauc() != null) {
                stringBuilder.append("     concreteType.class=").append(this.zzauc().getCanonicalName()).append('\n');
            }
            stringBuilder.append("          converterName=").append(this.zO == null ? "null" : this.zO.getClass().getCanonicalName()).append('\n');
            return stringBuilder.toString();
        }
    }
}

