/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.zzh;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.zzab;

public final class Status
extends AbstractSafeParcelable
implements Result,
ReflectedParcelable {
    public static final Status vY = new Status(0);
    public static final Status vZ = new Status(14);
    public static final Status wa = new Status(8);
    public static final Status wb = new Status(15);
    public static final Status wc = new Status(16);
    public static final Status wd = new Status(17);
    public static final Status we = new Status(18);
    public static final Parcelable.Creator<Status> CREATOR = new zzh();
    private final int mVersionCode;
    private final int rR;
    private final String uK;
    private final PendingIntent mPendingIntent;

    Status(int n, int n2, String string2, PendingIntent pendingIntent) {
        this.mVersionCode = n;
        this.rR = n2;
        this.uK = string2;
        this.mPendingIntent = pendingIntent;
    }

    public Status(int n) {
        this(n, null);
    }

    public Status(int n, String string2) {
        this(1, n, string2, null);
    }

    public Status(int n, String string2, PendingIntent pendingIntent) {
        this(1, n, string2, pendingIntent);
    }

    public void startResolutionForResult(Activity activity, int n) throws IntentSender.SendIntentException {
        if (!this.hasResolution()) {
            return;
        }
        activity.startIntentSenderForResult(this.mPendingIntent.getIntentSender(), n, null, 0, 0, 0);
    }

    PendingIntent zzaqh() {
        return this.mPendingIntent;
    }

    @Nullable
    public String getStatusMessage() {
        return this.uK;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public boolean hasResolution() {
        return this.mPendingIntent != null;
    }

    public boolean isSuccess() {
        return this.rR <= 0;
    }

    public boolean isCanceled() {
        return this.rR == 16;
    }

    public boolean isInterrupted() {
        return this.rR == 14;
    }

    public int getStatusCode() {
        return this.rR;
    }

    public PendingIntent getResolution() {
        return this.mPendingIntent;
    }

    public int hashCode() {
        return zzab.hashCode(this.mVersionCode, this.rR, this.uK, this.mPendingIntent);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Status)) {
            return false;
        }
        Status status = (Status)object;
        return this.mVersionCode == status.mVersionCode && this.rR == status.rR && zzab.equal(this.uK, status.uK) && zzab.equal(this.mPendingIntent, status.mPendingIntent);
    }

    private String zzaqi() {
        if (this.uK != null) {
            return this.uK;
        }
        return CommonStatusCodes.getStatusCodeString(this.rR);
    }

    public String toString() {
        return zzab.zzx(this).zzg("statusCode", this.zzaqi()).zzg("resolution", this.mPendingIntent).toString();
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzh.zza(this, parcel, n);
    }

    @Override
    public Status getStatus() {
        return this;
    }
}

