/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import com.google.android.gms.internal.zzaod;
import com.google.android.gms.internal.zzaoi;
import com.google.android.gms.internal.zzapf;
import com.google.android.gms.internal.zzapg;
import com.google.android.gms.internal.zzapj;
import com.google.android.gms.internal.zzapx;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class zzapb {
    private final Map<Type, zzaod<?>> bkY;

    public zzapb(Map<Type, zzaod<?>> map) {
        this.bkY = map;
    }

    public <T> zzapg<T> zzb(zzapx<T> zzapx2) {
        final Type type = zzapx2.bz();
        Class<T> clazz = zzapx2.by();
        final zzaod<?> zzaod2 = this.bkY.get(type);
        if (zzaod2 != null) {
            return new zzapg<T>(){

                @Override
                public T bg() {
                    return zzaod2.zza(type);
                }
            };
        }
        final zzaod<?> zzaod3 = this.bkY.get(clazz);
        if (zzaod3 != null) {
            return new zzapg<T>(){

                @Override
                public T bg() {
                    return zzaod3.zza(type);
                }
            };
        }
        zzapg<T> zzapg2 = this.zzl(clazz);
        if (zzapg2 != null) {
            return zzapg2;
        }
        zzapg<T> zzapg3 = this.zzc(type, clazz);
        if (zzapg3 != null) {
            return zzapg3;
        }
        return this.zzd(type, clazz);
    }

    private <T> zzapg<T> zzl(Class<? super T> clazz) {
        try {
            final Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            return new zzapg<T>(){

                @Override
                public T bg() {
                    try {
                        Object var1_1 = null;
                        return constructor.newInstance(null);
                    }
                    catch (InstantiationException instantiationException) {
                        String string2 = String.valueOf(constructor);
                        throw new RuntimeException(new StringBuilder(30 + String.valueOf(string2).length()).append("Failed to invoke ").append(string2).append(" with no args").toString(), instantiationException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        String string3 = String.valueOf(constructor);
                        throw new RuntimeException(new StringBuilder(30 + String.valueOf(string3).length()).append("Failed to invoke ").append(string3).append(" with no args").toString(), invocationTargetException.getTargetException());
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new AssertionError((Object)illegalAccessException);
                    }
                }
            };
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private <T> zzapg<T> zzc(final Type type, Class<? super T> clazz) {
        if (Collection.class.isAssignableFrom(clazz)) {
            if (SortedSet.class.isAssignableFrom(clazz)) {
                return new zzapg<T>(){

                    @Override
                    public T bg() {
                        return new TreeSet();
                    }
                };
            }
            if (EnumSet.class.isAssignableFrom(clazz)) {
                return new zzapg<T>(){

                    @Override
                    public T bg() {
                        if (type instanceof ParameterizedType) {
                            Type type2 = ((ParameterizedType)type).getActualTypeArguments()[0];
                            if (type2 instanceof Class) {
                                return EnumSet.noneOf((Class)type2);
                            }
                            String string2 = String.valueOf(type.toString());
                            throw new zzaoi(string2.length() != 0 ? "Invalid EnumSet type: ".concat(string2) : new String("Invalid EnumSet type: "));
                        }
                        String string3 = String.valueOf(type.toString());
                        throw new zzaoi(string3.length() != 0 ? "Invalid EnumSet type: ".concat(string3) : new String("Invalid EnumSet type: "));
                    }
                };
            }
            if (Set.class.isAssignableFrom(clazz)) {
                return new zzapg<T>(){

                    @Override
                    public T bg() {
                        return new LinkedHashSet();
                    }
                };
            }
            if (Queue.class.isAssignableFrom(clazz)) {
                return new zzapg<T>(){

                    @Override
                    public T bg() {
                        return new LinkedList();
                    }
                };
            }
            return new zzapg<T>(){

                @Override
                public T bg() {
                    return new ArrayList();
                }
            };
        }
        if (Map.class.isAssignableFrom(clazz)) {
            if (SortedMap.class.isAssignableFrom(clazz)) {
                return new zzapg<T>(){

                    @Override
                    public T bg() {
                        return new TreeMap();
                    }
                };
            }
            if (type instanceof ParameterizedType && !String.class.isAssignableFrom(zzapx.zzl(((ParameterizedType)type).getActualTypeArguments()[0]).by())) {
                return new zzapg<T>(){

                    @Override
                    public T bg() {
                        return new LinkedHashMap();
                    }
                };
            }
            return new zzapg<T>(){

                @Override
                public T bg() {
                    return new zzapf();
                }
            };
        }
        return null;
    }

    private <T> zzapg<T> zzd(final Type type, final Class<? super T> clazz) {
        return new zzapg<T>(){
            private final zzapj blB = zzapj.bl();

            @Override
            public T bg() {
                try {
                    Object t = this.blB.zzf(clazz);
                    return t;
                }
                catch (Exception exception) {
                    String string2 = String.valueOf(type);
                    throw new RuntimeException(new StringBuilder(116 + String.valueOf(string2).length()).append("Unable to invoke no-args constructor for ").append(string2).append(". ").append("Register an InstanceCreator with Gson for this type may fix this problem.").toString(), exception);
                }
            }
        };
    }

    public String toString() {
        return this.bkY.toString();
    }
}

