/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v4.util.ArrayMap;
import com.google.android.gms.internal.zzra;
import com.google.android.gms.internal.zzrb;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;

@TargetApi(value=11)
public final class zzrc
extends Fragment
implements zzrb {
    private static WeakHashMap<Activity, WeakReference<zzrc>> yZ = new WeakHashMap();
    private Map<String, zzra> za = new ArrayMap();
    private int zzbqm = 0;
    private Bundle zb;

    public static zzrc zzt(Activity activity) {
        zzrc zzrc2;
        WeakReference<zzrc> weakReference = yZ.get(activity);
        if (weakReference != null && (zzrc2 = (zzrc)weakReference.get()) != null) {
            return zzrc2;
        }
        try {
            zzrc2 = (zzrc)activity.getFragmentManager().findFragmentByTag("LifecycleFragmentImpl");
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("Fragment with tag LifecycleFragmentImpl is not a LifecycleFragmentImpl", classCastException);
        }
        if (zzrc2 == null || zzrc2.isRemoving()) {
            zzrc2 = new zzrc();
            activity.getFragmentManager().beginTransaction().add((Fragment)zzrc2, "LifecycleFragmentImpl").commitAllowingStateLoss();
        }
        yZ.put(activity, new WeakReference<zzrc>(zzrc2));
        return zzrc2;
    }

    @Override
    public <T extends zzra> T zza(String string2, Class<T> clazz) {
        return (T)((zzra)clazz.cast(this.za.get(string2)));
    }

    @Override
    public void zza(String string2, @NonNull zzra zzra2) {
        if (this.za.containsKey(string2)) {
            throw new IllegalArgumentException(new StringBuilder(59 + String.valueOf(string2).length()).append("LifecycleCallback with tag ").append(string2).append(" already added to this fragment.").toString());
        }
        this.za.put(string2, zzra2);
        this.zzb(string2, zzra2);
    }

    private void zzb(final String string2, final @NonNull zzra zzra2) {
        if (this.zzbqm > 0) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    if (zzrc.this.zzbqm >= 1) {
                        zzra2.onCreate(zzrc.this.zb != null ? zzrc.this.zb.getBundle(string2) : null);
                    }
                    if (zzrc.this.zzbqm >= 2) {
                        zzra2.onStart();
                    }
                    if (zzrc.this.zzbqm >= 3) {
                        zzra2.onStop();
                    }
                    if (zzrc.this.zzbqm >= 4) {
                        zzra2.onDestroy();
                    }
                }
            });
        }
    }

    @Override
    public Activity zzasq() {
        return this.getActivity();
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.zzbqm = 1;
        this.zb = bundle;
        for (Map.Entry<String, zzra> entry : this.za.entrySet()) {
            entry.getValue().onCreate(bundle != null ? bundle.getBundle(entry.getKey()) : null);
        }
    }

    public void onStart() {
        super.onStop();
        this.zzbqm = 2;
        for (zzra zzra2 : this.za.values()) {
            zzra2.onStart();
        }
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        super.onActivityResult(n, n2, intent);
        for (zzra zzra2 : this.za.values()) {
            zzra2.onActivityResult(n, n2, intent);
        }
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        if (bundle == null) {
            return;
        }
        for (Map.Entry<String, zzra> entry : this.za.entrySet()) {
            Bundle bundle2 = new Bundle();
            entry.getValue().onSaveInstanceState(bundle2);
            bundle.putBundle(entry.getKey(), bundle2);
        }
    }

    public void onStop() {
        super.onStop();
        this.zzbqm = 3;
        for (zzra zzra2 : this.za.values()) {
            zzra2.onStop();
        }
    }

    public void onDestroy() {
        super.onStop();
        this.zzbqm = 4;
        for (zzra zzra2 : this.za.values()) {
            zzra2.onDestroy();
        }
    }

    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        super.dump(string2, fileDescriptor, printWriter, stringArray);
        for (zzra zzra2 : this.za.values()) {
            zzra2.dump(string2, fileDescriptor, printWriter, stringArray);
        }
    }
}

