/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.zzc;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zztm;
import com.google.android.gms.internal.zztn;
import dalvik.system.PathClassLoader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;

public final class zztl {
    private static zztm Qh;
    private static final HashMap<String, byte[]> Qi;
    private static String Qj;
    private static final zzb.zza Qk;
    private static final zzb.zza Ql;
    public static final zzb Qm;
    public static final zzb Qn;
    public static final zzb Qo;
    public static final zzb Qp;
    public static final zzb Qq;
    private final Context Qr;

    public static zztl zza(Context context, zzb zzb2, String string2) throws zza {
        return zztl.zza(context, zzb2, string2, Qk);
    }

    public static zztl zza(Context context, zzb zzb2, String string2, zzb.zza zza2) throws zza {
        zzb.zzb zzb3 = zzb2.zza(context, string2, zza2);
        int n = zzb3.Qt;
        final int n2 = zzb3.Qu;
        Log.i((String)"DynamiteModule", (String)new StringBuilder(68 + String.valueOf(string2).length() + String.valueOf(string2).length()).append("Considering local module ").append(string2).append(":").append(n).append(" and remote module ").append(string2).append(":").append(n2).toString());
        if (zzb3.Qv == 0 || zzb3.Qv == -1 && zzb3.Qt == 0 || zzb3.Qv == 1 && zzb3.Qu == 0) {
            n = zzb3.Qt;
            n2 = zzb3.Qu;
            throw new zza(new StringBuilder(91).append("No acceptable module found. Local version is ").append(n).append(" and remote version is ").append(n2).append(".").toString());
        }
        if (zzb3.Qv == -1) {
            return zztl.zzac(context, string2);
        }
        if (zzb3.Qv == 1) {
            try {
                return zza2.zza(context, string2, zzb3.Qu);
            }
            catch (zza zza3) {
                String string3 = String.valueOf(zza3.getMessage());
                Log.w((String)"DynamiteModule", (String)(string3.length() != 0 ? "Failed to load remote module: ".concat(string3) : new String("Failed to load remote module: ")));
                if (zzb3.Qt != 0) {
                    n2 = zzb3.Qt;
                    zzb.zza zza4 = new zzb.zza(){

                        @Override
                        public int zzb(Context context, String string2, boolean bl) {
                            return 0;
                        }

                        @Override
                        public int zzaa(Context context, String string2) {
                            return n2;
                        }

                        @Override
                        public zztl zza(Context context, String string2, int n) throws zza {
                            throw new zza("local only VersionPolicy should not load from remote");
                        }
                    };
                    zzb3 = zzb2.zza(context, string2, zza4);
                    if (zzb3.Qv == -1) {
                        return zztl.zzac(context, string2);
                    }
                }
                throw new zza("Remote load failed. No local fallback found.", zza3);
            }
        }
        n = zzb3.Qv;
        throw new zza(new StringBuilder(47).append("VersionPolicy returned invalid code:").append(n).toString());
    }

    public static int zzaa(Context context, String string2) {
        try {
            Object object = String.valueOf("com.google.android.gms.dynamite.descriptors.");
            Object object2 = String.valueOf("ModuleDescriptor");
            Class<?> clazz = context.getApplicationContext().getClassLoader().loadClass(new StringBuilder(1 + String.valueOf(object).length() + String.valueOf(string2).length() + String.valueOf(object2).length()).append((String)object).append(string2).append(".").append((String)object2).toString());
            object = clazz.getDeclaredField("MODULE_ID");
            object2 = clazz.getDeclaredField("MODULE_VERSION");
            if (!((Field)object).get(null).equals(string2)) {
                String string3 = String.valueOf(((Field)object).get(null));
                Log.e((String)"DynamiteModule", (String)new StringBuilder(51 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Module descriptor id '").append(string3).append("' didn't match expected id '").append(string2).append("'").toString());
                return 0;
            }
            return ((Field)object2).getInt(null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.w((String)"DynamiteModule", (String)new StringBuilder(45 + String.valueOf(string2).length()).append("Local module descriptor class for ").append(string2).append(" not found.").toString());
        }
        catch (Exception exception) {
            String string4 = String.valueOf(exception.getMessage());
            Log.e((String)"DynamiteModule", (String)(string4.length() != 0 ? "Failed to load module descriptor class: ".concat(string4) : new String("Failed to load module descriptor class: ")));
        }
        return 0;
    }

    public static int zzb(Context context, String string2, boolean bl) {
        zztm zztm2 = zztl.zzcs(context);
        if (zztm2 == null) {
            return 0;
        }
        try {
            return zztm2.zza(zze.zzac(context), string2, bl);
        }
        catch (RemoteException remoteException) {
            String string3 = String.valueOf(remoteException.getMessage());
            Log.w((String)"DynamiteModule", (String)(string3.length() != 0 ? "Failed to retrieve remote module version: ".concat(string3) : new String("Failed to retrieve remote module version: ")));
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static int zzc(Context context, String string2, boolean bl) throws zza {
        String string3 = bl ? "api_force_staging" : "api";
        String string4 = String.valueOf("content://com.google.android.gms.chimera/");
        Uri uri = Uri.parse((String)new StringBuilder(1 + String.valueOf(string4).length() + String.valueOf(string3).length() + String.valueOf(string2).length()).append(string4).append(string3).append("/").append(string2).toString());
        if (context == null) throw new zza("Failed to get dynamite module ContentResolver.");
        string4 = context.getContentResolver();
        if (string4 == null) {
            throw new zza("Failed to get dynamite module ContentResolver.");
        }
        try (Cursor cursor = string4.query(uri, null, null, null, null);){
            if (cursor == null || !cursor.moveToFirst()) {
                Log.w((String)"DynamiteModule", (String)"Failed to retrieve remote module version.");
                throw new zza("Failed to connect to dynamite module ContentResolver.");
            }
            int n = cursor.getInt(0);
            if (n > 0) {
                Class<zztl> clazz = zztl.class;
                // MONITORENTER : com.google.android.gms.internal.zztl.class
                Qi.put(new StringBuilder(12 + String.valueOf(string2).length()).append(string2).append(":").append(n).toString(), cursor.getBlob(1));
                Qj = cursor.getString(2);
                // MONITOREXIT : clazz
            }
            int n2 = n;
            return n2;
        }
    }

    public static int zzab(Context context, String string2) {
        return zztl.zzb(context, string2, false);
    }

    private static zztl zzac(Context context, String string2) {
        String string3 = String.valueOf(string2);
        Log.i((String)"DynamiteModule", (String)(string3.length() != 0 ? "Selected local version of ".concat(string3) : new String("Selected local version of ")));
        return new zztl(context.getApplicationContext());
    }

    private static zztl zza(Context context, String string2, int n) throws zza {
        Log.i((String)"DynamiteModule", (String)new StringBuilder(51 + String.valueOf(string2).length()).append("Selected remote version of ").append(string2).append(", version >= ").append(n).toString());
        zztm zztm2 = zztl.zzcs(context);
        if (zztm2 == null) {
            throw new zza("Failed to create IDynamiteLoader.");
        }
        zzd zzd2 = null;
        try {
            zzd2 = zztm2.zza(zze.zzac(context), string2, n);
        }
        catch (RemoteException remoteException) {
            throw new zza("Failed to load remote module.", remoteException);
        }
        if (zze.zzae(zzd2) == null) {
            throw new zza("Failed to load remote module.");
        }
        return new zztl((Context)zze.zzae(zzd2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static zztm zzcs(Context context) {
        Class<zztl> clazz = zztl.class;
        synchronized (zztl.class) {
            if (Qh != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return Qh;
            }
            if (zzc.zzaql().isGooglePlayServicesAvailable(context) != 0) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            try {
                Context context2 = context.createPackageContext("com.google.android.gms", 3);
                ClassLoader classLoader = context2.getClassLoader();
                Class<?> clazz2 = classLoader.loadClass("com.google.android.gms.chimera.container.DynamiteLoaderImpl");
                IBinder iBinder = (IBinder)clazz2.newInstance();
                zztm zztm2 = zztm.zza.zzfe(iBinder);
                if (zztm2 != null) {
                    Qh = zztm2;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return zztm2;
                }
            }
            catch (Exception exception) {
                String string2 = String.valueOf(exception.getMessage());
                Log.e((String)"DynamiteModule", (String)(string2.length() != 0 ? "Failed to load IDynamiteLoader from GmsCore: ".concat(string2) : new String("Failed to load IDynamiteLoader from GmsCore: ")));
            }
            return null;
        }
    }

    public Context zzbdt() {
        return this.Qr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static zztl zzb(Context context, String string2, int n) throws zza {
        Log.i((String)"DynamiteModule", (String)new StringBuilder(51 + String.valueOf(string2).length()).append("Selected remote version of ").append(string2).append(", version >= ").append(n).toString());
        Context context2 = zztl.class;
        synchronized (zztl.class) {
            byte[] byArray = Qi.get(new StringBuilder(12 + String.valueOf(string2).length()).append(string2).append(":").append(n).toString());
            String string3 = Qj;
            // ** MonitorExit[var5_3] (shouldn't be in output)
            if (byArray == null) {
                throw new zza("Module implementation could not be found.");
            }
            context2 = context.getApplicationContext();
            Context context3 = zztl.zza(context2, string2, byArray, string3);
            if (context3 == null) {
                throw new zza("Failed to get module context");
            }
            return new zztl(context3);
        }
    }

    private static Context zza(Context context, String string2, byte[] byArray, String string3) {
        if (string3 == null || string3.isEmpty()) {
            Log.e((String)"DynamiteModule", (String)"No valid DynamiteLoader APK path");
            return null;
        }
        PathClassLoader pathClassLoader = new PathClassLoader(string3, context.getClassLoader()){

            protected Class<?> loadClass(String string2, boolean bl) throws ClassNotFoundException {
                if (!string2.startsWith("java.") && !string2.startsWith("android.")) {
                    try {
                        return this.findClass(string2);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                return super.loadClass(string2, bl);
            }
        };
        try {
            zztn zztn2 = zztn.zza.zzff((IBinder)pathClassLoader.loadClass("com.google.android.gms.dynamiteloader.DynamiteLoaderV2").getConstructor(new Class[0]).newInstance(new Object[0]));
            zzd zzd2 = zztn2.zza(zze.zzac(context), string2, byArray);
            return (Context)zze.zzae(zzd2);
        }
        catch (RemoteException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException throwable) {
            String string4 = String.valueOf(throwable.toString());
            Log.e((String)"DynamiteModule", (String)(string4.length() != 0 ? "Failed to load DynamiteLoader: ".concat(string4) : new String("Failed to load DynamiteLoader: ")));
            return null;
        }
    }

    public IBinder zzjd(String string2) throws zza {
        try {
            Class<?> clazz = this.Qr.getClassLoader().loadClass(string2);
            return (IBinder)clazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
            String string3 = String.valueOf(string2);
            throw new zza(string3.length() != 0 ? "Failed to instantiate module class: ".concat(string3) : new String("Failed to instantiate module class: "), reflectiveOperationException);
        }
    }

    private zztl(Context context) {
        this.Qr = zzaa.zzy(context);
    }

    static {
        Qi = new HashMap();
        Qk = new zzb.zza(){

            @Override
            public int zzb(Context context, String string2, boolean bl) throws zza {
                return zztl.zzb(context, string2, bl);
            }

            @Override
            public int zzaa(Context context, String string2) {
                return zztl.zzaa(context, string2);
            }

            @Override
            public zztl zza(Context context, String string2, int n) throws zza {
                return zztl.zza(context, string2, n);
            }
        };
        Ql = new zzb.zza(){

            @Override
            public int zzb(Context context, String string2, boolean bl) throws zza {
                return zztl.zzc(context, string2, bl);
            }

            @Override
            public int zzaa(Context context, String string2) {
                return zztl.zzaa(context, string2);
            }

            @Override
            public zztl zza(Context context, String string2, int n) throws zza {
                return zztl.zzb(context, string2, n);
            }
        };
        Qm = new zzb(){

            @Override
            public zzb.zzb zza(Context context, String string2, zzb.zza zza2) throws zza {
                zzb.zzb zzb2 = new zzb.zzb();
                zzb2.Qu = zza2.zzb(context, string2, true);
                if (zzb2.Qu != 0) {
                    zzb2.Qv = 1;
                } else {
                    zzb2.Qt = zza2.zzaa(context, string2);
                    if (zzb2.Qt != 0) {
                        zzb2.Qv = -1;
                    }
                }
                return zzb2;
            }
        };
        Qn = new zzb(){

            @Override
            public zzb.zzb zza(Context context, String string2, zzb.zza zza2) throws zza {
                zzb.zzb zzb2 = new zzb.zzb();
                zzb2.Qt = zza2.zzaa(context, string2);
                if (zzb2.Qt != 0) {
                    zzb2.Qv = -1;
                } else {
                    zzb2.Qu = zza2.zzb(context, string2, true);
                    if (zzb2.Qu != 0) {
                        zzb2.Qv = 1;
                    }
                }
                return zzb2;
            }
        };
        Qo = new zzb(){

            @Override
            public zzb.zzb zza(Context context, String string2, zzb.zza zza2) throws zza {
                zzb.zzb zzb2 = new zzb.zzb();
                zzb2.Qt = zza2.zzaa(context, string2);
                zzb2.Qu = zza2.zzb(context, string2, true);
                zzb2.Qv = zzb2.Qt == 0 && zzb2.Qu == 0 ? 0 : (zzb2.Qt >= zzb2.Qu ? -1 : 1);
                return zzb2;
            }
        };
        Qp = new zzb(){

            @Override
            public zzb.zzb zza(Context context, String string2, zzb.zza zza2) throws zza {
                zzb.zzb zzb2 = new zzb.zzb();
                zzb2.Qt = zza2.zzaa(context, string2);
                zzb2.Qu = zza2.zzb(context, string2, true);
                zzb2.Qv = zzb2.Qt == 0 && zzb2.Qu == 0 ? 0 : (zzb2.Qu >= zzb2.Qt ? 1 : -1);
                return zzb2;
            }
        };
        Qq = new zzb(){

            @Override
            public zzb.zzb zza(Context context, String string2, zzb.zza zza2) throws zza {
                zzb.zzb zzb2 = new zzb.zzb();
                zzb2.Qt = zza2.zzaa(context, string2);
                zzb2.Qu = zzb2.Qt != 0 ? zza2.zzb(context, string2, false) : zza2.zzb(context, string2, true);
                zzb2.Qv = zzb2.Qt == 0 && zzb2.Qu == 0 ? 0 : (zzb2.Qu >= zzb2.Qt ? 1 : -1);
                return zzb2;
            }
        };
    }

    public static class zza
    extends Exception {
        private zza(String string2) {
            super(string2);
        }

        private zza(String string2, Throwable throwable) {
            super(string2, throwable);
        }
    }

    public static interface com.google.android.gms.internal.zztl$zzb {
        public zzb zza(Context var1, String var2, zza var3) throws com.google.android.gms.internal.zztl$zza;

        public static class zzb {
            public int Qt = 0;
            public int Qu = 0;
            public int Qv = 0;
        }

        public static interface zza {
            public int zzb(Context var1, String var2, boolean var3) throws com.google.android.gms.internal.zztl$zza;

            public int zzaa(Context var1, String var2);

            public zztl zza(Context var1, String var2, int var3) throws com.google.android.gms.internal.zztl$zza;
        }
    }
}

