/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.google.android.gms.cast.LaunchOptions;
import com.google.android.gms.cast.framework.media.CastMediaOptions;
import com.google.android.gms.cast.framework.zzb;
import com.google.android.gms.common.internal.safeparcel.zza;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CastOptions
extends zza {
    public static final Parcelable.Creator<CastOptions> CREATOR = new zzb();
    private final int mVersionCode;
    private final String zzaoY;
    private final List<String> zzaoZ;
    private final boolean zzapa;
    private final LaunchOptions zzana;
    private final boolean zzapb;
    private final CastMediaOptions zzapc;
    private final boolean zzapd;
    private final double zzape;

    CastOptions(int n, String string, List<String> list, boolean bl, LaunchOptions launchOptions, boolean bl2, CastMediaOptions castMediaOptions, boolean bl3, double d) {
        this.mVersionCode = n;
        this.zzaoY = TextUtils.isEmpty((CharSequence)string) ? "" : string;
        int n2 = list == null ? 0 : list.size();
        this.zzaoZ = new ArrayList<String>(n2);
        if (n2 > 0) {
            this.zzaoZ.addAll(list);
        }
        this.zzapa = bl;
        this.zzana = launchOptions == null ? new LaunchOptions() : launchOptions;
        this.zzapb = bl2;
        this.zzapc = castMediaOptions;
        this.zzapd = bl3;
        this.zzape = d;
    }

    int getVersionCode() {
        return this.mVersionCode;
    }

    public String getReceiverApplicationId() {
        return this.zzaoY;
    }

    public List<String> getSupportedNamespaces() {
        return Collections.unmodifiableList(this.zzaoZ);
    }

    public boolean getStopReceiverApplicationWhenEndingSession() {
        return this.zzapa;
    }

    public LaunchOptions getLaunchOptions() {
        return this.zzana;
    }

    public boolean getResumeSavedSession() {
        return this.zzapb;
    }

    public CastMediaOptions getCastMediaOptions() {
        return this.zzapc;
    }

    public boolean getEnableReconnectionService() {
        return this.zzapd;
    }

    public double getVolumeDeltaBeforeIceCreamSandwich() {
        return this.zzape;
    }

    public void writeToParcel(Parcel parcel, int n) {
        zzb.zza(this, parcel, n);
    }

    public static final class Builder {
        private String zzaoY;
        private List<String> zzaoZ = new ArrayList<String>();
        private boolean zzapa;
        private LaunchOptions zzana = new LaunchOptions();
        private boolean zzapb = true;
        private CastMediaOptions zzapc = new CastMediaOptions.Builder().build();
        private boolean zzapd = true;
        private double zzape = 0.05f;

        public Builder setReceiverApplicationId(String string) {
            this.zzaoY = string;
            return this;
        }

        public Builder setSupportedNamespaces(List<String> list) {
            this.zzaoZ = list;
            return this;
        }

        public Builder setStopReceiverApplicationWhenEndingSession(boolean bl) {
            this.zzapa = bl;
            return this;
        }

        public Builder setLaunchOptions(LaunchOptions launchOptions) {
            this.zzana = launchOptions;
            return this;
        }

        public Builder setResumeSavedSession(boolean bl) {
            this.zzapb = bl;
            return this;
        }

        public Builder setCastMediaOptions(CastMediaOptions castMediaOptions) {
            this.zzapc = castMediaOptions;
            return this;
        }

        public Builder setEnableReconnectionService(boolean bl) {
            this.zzapd = bl;
            return this;
        }

        public Builder setVolumeDeltaBeforeIceCreamSandwich(double d) throws IllegalArgumentException {
            if (d <= 0.0 || d > 0.5) {
                throw new IllegalArgumentException("volumeDelta must be greater than 0 and less or equal to 0.5");
            }
            this.zzape = d;
            return this;
        }

        public CastOptions build() {
            return new CastOptions(1, this.zzaoY, this.zzaoZ, this.zzapa, this.zzana, this.zzapb, this.zzapc, this.zzapd, this.zzape);
        }
    }
}

