/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.StringRes;
import android.support.v7.app.MediaRouteButton;
import android.view.MenuItem;
import android.view.View;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzww;
import com.google.android.gms.internal.zzwx;

public interface IntroductoryOverlay {
    public void show();

    public void remove();

    public static class Builder {
        private Activity mActivity;
        private View zzapr;
        private int zzaps;
        private String zzapt;
        private OnOverlayDismissedListener zzapu;
        private boolean zzapv;
        private float zzapw;
        private String zzapx;

        @TargetApi(value=11)
        public Builder(Activity activity, MenuItem menuItem) {
            this.mActivity = (Activity)zzac.zzw((Object)activity);
            if (zzs.zzyx()) {
                this.zzapr = ((MenuItem)zzac.zzw((Object)menuItem)).getActionView();
            }
        }

        public Builder(Activity activity, MediaRouteButton mediaRouteButton) {
            this.mActivity = (Activity)zzac.zzw((Object)activity);
            this.zzapr = (View)zzac.zzw((Object)mediaRouteButton);
        }

        public Builder setOverlayColor(@ColorRes int n) {
            this.zzaps = this.mActivity.getResources().getColor(n);
            return this;
        }

        public Builder setTitleText(String string2) {
            this.zzapt = string2;
            return this;
        }

        public Builder setTitleText(@StringRes int n) {
            this.zzapt = this.mActivity.getResources().getString(n);
            return this;
        }

        public Builder setOnOverlayDismissedListener(OnOverlayDismissedListener onOverlayDismissedListener) {
            this.zzapu = onOverlayDismissedListener;
            return this;
        }

        public Builder setSingleTime() {
            this.zzapv = true;
            return this;
        }

        public Builder setFocusRadiusId(@DimenRes int n) {
            this.zzapw = this.mActivity.getResources().getDimension(n);
            return this;
        }

        public Builder setFocusRadius(float f) {
            this.zzapw = f;
            return this;
        }

        public Builder setButtonText(String string2) {
            this.zzapx = string2;
            return this;
        }

        public Builder setButtonText(@StringRes int n) {
            this.zzapx = this.mActivity.getResources().getString(n);
            return this;
        }

        public Activity getActivity() {
            return this.mActivity;
        }

        public View zzst() {
            return this.zzapr;
        }

        public OnOverlayDismissedListener zzsu() {
            return this.zzapu;
        }

        public int zzsv() {
            return this.zzaps;
        }

        public boolean zzsw() {
            return this.zzapv;
        }

        public String zzsx() {
            return this.zzapt;
        }

        public String zzsy() {
            return this.zzapx;
        }

        public float zzsz() {
            return this.zzapw;
        }

        public IntroductoryOverlay build() {
            if (zzs.zzyC()) {
                return new zzww(this);
            }
            return new zzwx(this);
        }
    }

    public static class zza {
        public static void zzac(Context context) {
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
            sharedPreferences.edit().putBoolean("googlecast-introOverlayShown", true).apply();
        }

        public static boolean zzad(Context context) {
            SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
            return sharedPreferences.getBoolean("googlecast-introOverlayShown", false);
        }
    }

    public static interface OnOverlayDismissedListener {
        public void onOverlayDismissed();
    }
}

