/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework;

import android.content.Context;
import android.os.Bundle;
import android.os.RemoteException;
import com.google.android.gms.cast.framework.zzm;
import com.google.android.gms.cast.framework.zzq;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.internal.zzwq;
import com.google.android.gms.internal.zzyu;

public abstract class Session {
    private static final zzyu zzaoQ = new zzyu("Session");
    private final zzm zzapz;
    private final zza zzapA = new zza();

    protected Session(Context context, String string2, String string3) {
        this.zzapz = zzwq.zza(context, string2, string3, this.zzapA);
    }

    protected abstract void start(Bundle var1);

    protected abstract void resume(Bundle var1);

    protected abstract void end(boolean var1);

    public long getSessionRemainingTimeMs() {
        zzac.zzdn((String)"Must be called from the main thread.");
        return 0L;
    }

    public final String getCategory() {
        zzac.zzdn((String)"Must be called from the main thread.");
        try {
            return this.zzapz.getCategory();
        }
        catch (RemoteException remoteException) {
            zzaoQ.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getCategory", zzm.class.getSimpleName()});
            return null;
        }
    }

    public final String getSessionId() {
        zzac.zzdn((String)"Must be called from the main thread.");
        try {
            return this.zzapz.getSessionId();
        }
        catch (RemoteException remoteException) {
            zzaoQ.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getSessionId", zzm.class.getSimpleName()});
            return null;
        }
    }

    public boolean isConnected() {
        zzac.zzdn((String)"Must be called from the main thread.");
        try {
            return this.zzapz.isConnected();
        }
        catch (RemoteException remoteException) {
            zzaoQ.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isConnected", zzm.class.getSimpleName()});
            return false;
        }
    }

    public boolean isConnecting() {
        zzac.zzdn((String)"Must be called from the main thread.");
        try {
            return this.zzapz.isConnecting();
        }
        catch (RemoteException remoteException) {
            zzaoQ.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isConnecting", zzm.class.getSimpleName()});
            return false;
        }
    }

    public boolean isDisconnecting() {
        zzac.zzdn((String)"Must be called from the main thread.");
        try {
            return this.zzapz.isDisconnecting();
        }
        catch (RemoteException remoteException) {
            zzaoQ.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isDisconnecting", zzm.class.getSimpleName()});
            return false;
        }
    }

    public boolean isDisconnected() {
        zzac.zzdn((String)"Must be called from the main thread.");
        try {
            return this.zzapz.isDisconnected();
        }
        catch (RemoteException remoteException) {
            zzaoQ.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isDisconnected", zzm.class.getSimpleName()});
            return true;
        }
    }

    public boolean isResuming() {
        zzac.zzdn((String)"Must be called from the main thread.");
        try {
            return this.zzapz.isResuming();
        }
        catch (RemoteException remoteException) {
            zzaoQ.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isResuming", zzm.class.getSimpleName()});
            return false;
        }
    }

    public boolean isSuspended() {
        zzac.zzdn((String)"Must be called from the main thread.");
        try {
            return this.zzapz.isSuspended();
        }
        catch (RemoteException remoteException) {
            zzaoQ.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"isSuspended", zzm.class.getSimpleName()});
            return false;
        }
    }

    protected final void notifySessionStarted(String string2) {
        try {
            this.zzapz.notifySessionStarted(string2);
        }
        catch (RemoteException remoteException) {
            zzaoQ.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"notifySessionStarted", zzm.class.getSimpleName()});
        }
    }

    protected final void notifyFailedToStartSession(int n) {
        try {
            this.zzapz.notifyFailedToStartSession(n);
        }
        catch (RemoteException remoteException) {
            zzaoQ.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"notifyFailedToStartSession", zzm.class.getSimpleName()});
        }
    }

    protected final void notifySessionEnded(int n) {
        try {
            this.zzapz.notifySessionEnded(n);
        }
        catch (RemoteException remoteException) {
            zzaoQ.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"notifySessionEnded", zzm.class.getSimpleName()});
        }
    }

    protected final void notifySessionResumed(boolean bl) {
        try {
            this.zzapz.notifySessionResumed(bl);
        }
        catch (RemoteException remoteException) {
            zzaoQ.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"notifySessionResumed", zzm.class.getSimpleName()});
        }
    }

    protected final void notifyFailedToResumeSession(int n) {
        try {
            this.zzapz.notifyFailedToResumeSession(n);
        }
        catch (RemoteException remoteException) {
            zzaoQ.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"notifyFailedToResumeSession", zzm.class.getSimpleName()});
        }
    }

    protected final void notifySessionSuspended(int n) {
        try {
            this.zzapz.notifySessionSuspended(n);
        }
        catch (RemoteException remoteException) {
            zzaoQ.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"notifySessionSuspended", zzm.class.getSimpleName()});
        }
    }

    public final zzd zzsp() {
        try {
            return this.zzapz.zzsp();
        }
        catch (RemoteException remoteException) {
            zzaoQ.zzb((Throwable)remoteException, "Unable to call %s on %s.", new Object[]{"getWrappedObject", zzm.class.getSimpleName()});
            return null;
        }
    }

    private class zza
    extends zzq.zza {
        private zza() {
        }

        @Override
        public int zzsd() {
            return 10084208;
        }

        @Override
        public zzd zzss() {
            return zze.zzA((Object)Session.this);
        }

        @Override
        public void start(Bundle bundle) {
            Session.this.start(bundle);
        }

        @Override
        public void resume(Bundle bundle) {
            Session.this.resume(bundle);
        }

        @Override
        public void end(boolean bl) {
            Session.this.end(bl);
        }

        @Override
        public long getSessionRemainingTimeMs() {
            return Session.this.getSessionRemainingTimeMs();
        }
    }
}

