/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.internal.featurehighlight;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.support.v4.view.GestureDetectorCompat;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.R;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzb;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzc;
import com.google.android.gms.cast.framework.internal.featurehighlight.zzd;
import com.google.android.gms.cast.framework.internal.featurehighlight.zze;
import com.google.android.gms.internal.zzbim;
import com.google.android.gms.internal.zzbir;

public final class zza
extends ViewGroup {
    private final int[] zzapV = new int[2];
    private final Rect zzapW = new Rect();
    private final Rect zzapX = new Rect();
    private final zze zzapY;
    private final zzc zzapZ;
    private zzb zzaqa;
    private View targetView;
    @Nullable
    private View zzaqb;
    @Nullable
    private Animator zzaqc;
    private final zzd zzaqd;
    private final GestureDetectorCompat zzaqe;
    @Nullable
    private GestureDetectorCompat zzaqf;
    private zza zzaqg;
    private boolean zzaqh;

    public zza(Context context) {
        super(context);
        this.setId(R.id.cast_featurehighlight_view);
        this.setWillNotDraw(false);
        this.zzapZ = new zzc(context);
        this.zzapZ.setCallback((Drawable.Callback)this);
        this.zzapY = new zze(context);
        this.zzapY.setCallback((Drawable.Callback)this);
        this.zzaqd = new zzd(this);
        GestureDetector.SimpleOnGestureListener simpleOnGestureListener = new GestureDetector.SimpleOnGestureListener(){

            public boolean onSingleTapUp(MotionEvent motionEvent) {
                float f;
                float f2 = motionEvent.getX();
                if (!zza.this.zzc(f2, f = motionEvent.getY()) || !zza.this.zzapY.zzd(f2, f)) {
                    zza.this.zzaqg.dismiss();
                }
                return true;
            }
        };
        this.zzaqe = new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)simpleOnGestureListener);
        this.zzaqe.setIsLongpressEnabled(false);
        this.setVisibility(8);
    }

    public void zza(zzb zzb2) {
        this.zzaqa = zzbir.zzw(zzb2);
        this.addView(zzb2.asView(), 0);
    }

    public void zza(final View view, @Nullable View view2, final boolean bl, final zza zza2) {
        this.targetView = zzbir.zzw(view);
        this.zzaqb = view2;
        this.zzaqg = zzbir.zzw(zza2);
        GestureDetector.SimpleOnGestureListener simpleOnGestureListener = new GestureDetector.SimpleOnGestureListener(this){

            public boolean onSingleTapUp(MotionEvent motionEvent) {
                if (view.getParent() != null) {
                    view.performClick();
                }
                if (bl) {
                    zza2.zzsE();
                }
                return true;
            }
        };
        this.zzaqf = new GestureDetectorCompat(this.getContext(), (GestureDetector.OnGestureListener)simpleOnGestureListener);
        this.zzaqf.setIsLongpressEnabled(false);
        this.setVisibility(4);
    }

    protected void onMeasure(int n, int n2) {
        int n3 = View.MeasureSpec.getSize((int)n);
        int n4 = View.MeasureSpec.getSize((int)n2);
        this.setMeasuredDimension(zza.resolveSize((int)n3, (int)n), zza.resolveSize((int)n4, (int)n2));
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        if (this.targetView == null) {
            throw new IllegalStateException("Target view must be set before layout");
        }
        if (this.targetView.getParent() != null) {
            this.zza(this.zzapV, this.targetView);
        }
        this.zzapW.set(this.zzapV[0], this.zzapV[1], this.zzapV[0] + this.targetView.getWidth(), this.zzapV[1] + this.targetView.getHeight());
        if (this.zzaqb != null) {
            this.zza(this.zzapV, this.zzaqb);
            this.zzapX.set(this.zzapV[0], this.zzapV[1], this.zzapV[0] + this.zzaqb.getMeasuredWidth(), this.zzapV[1] + this.zzaqb.getMeasuredHeight());
        } else {
            this.zzapX.set(n, n2, n3, n4);
        }
        this.zzapY.setBounds(this.zzapX);
        this.zzapZ.setBounds(this.zzapX);
        this.zzaqd.zza(this.zzapW, this.zzapX);
    }

    protected void onDraw(Canvas canvas) {
        canvas.save();
        if (this.zzaqb != null) {
            canvas.clipRect(this.zzapX);
        }
        this.zzapY.draw(canvas);
        this.zzapZ.draw(canvas);
        if (this.targetView != null) {
            if (this.targetView.getParent() != null) {
                Bitmap bitmap = Bitmap.createBitmap((int)this.targetView.getWidth(), (int)this.targetView.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Canvas canvas2 = new Canvas(bitmap);
                this.targetView.draw(canvas2);
                int n = this.zzapY.getColor();
                int n2 = Color.red((int)n);
                int n3 = Color.green((int)n);
                int n4 = Color.blue((int)n);
                for (int i = 0; i < bitmap.getHeight(); ++i) {
                    for (int j = 0; j < bitmap.getWidth(); ++j) {
                        int n5 = bitmap.getPixel(j, i);
                        if (Color.alpha((int)n5) == 0) continue;
                        n5 = Color.argb((int)Color.alpha((int)n5), (int)n2, (int)n3, (int)n4);
                        bitmap.setPixel(j, i, n5);
                    }
                }
                canvas.drawBitmap(bitmap, (float)this.zzapW.left, (float)this.zzapW.top, null);
            }
        } else {
            throw new IllegalStateException("Neither target view nor drawable was set");
        }
        canvas.restore();
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attributeSet);
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.MarginLayoutParams(-2, -2);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new ViewGroup.MarginLayoutParams(layoutParams);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof ViewGroup.MarginLayoutParams;
    }

    protected boolean verifyDrawable(Drawable drawable) {
        return super.verifyDrawable(drawable) || drawable == this.zzapY || drawable == this.zzapZ || drawable == null;
    }

    public void zzh(final @Nullable Runnable runnable) {
        this.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

            public void onLayoutChange(View view, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
                if (runnable != null) {
                    runnable.run();
                }
                zza.this.zzsH();
                zza.this.removeOnLayoutChangeListener(this);
            }
        });
    }

    public void zzsH() {
        if (this.targetView == null) {
            throw new IllegalStateException("Target view must be set before animation");
        }
        this.setVisibility(0);
        this.zza(this.zzsM());
    }

    public void zzi(@Nullable Runnable runnable) {
        this.zza(this.zzl(runnable));
    }

    public void zzj(@Nullable Runnable runnable) {
        this.zza(this.zzk(runnable));
    }

    public void zzbX(@ColorInt int n) {
        this.zzapY.setColor(n);
    }

    @Nullable
    Drawable zzsI() {
        return null;
    }

    View zzsJ() {
        return this.zzaqa.asView();
    }

    zze zzsK() {
        return this.zzapY;
    }

    zzc zzsL() {
        return this.zzapZ;
    }

    private void zza(int[] nArray, View view) {
        this.getLocationInWindow(nArray);
        int n = nArray[0];
        int n2 = nArray[1];
        view.getLocationInWindow(nArray);
        nArray[0] = nArray[0] - n;
        nArray[1] = nArray[1] - n2;
    }

    private void zza(Animator animator) {
        if (this.zzaqc != null) {
            this.zzaqc.cancel();
        }
        this.zzaqc = animator;
        this.zzaqc.start();
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n = motionEvent.getActionMasked();
        if (n == 0) {
            this.zzaqh = this.zzapW.contains((int)motionEvent.getX(), (int)motionEvent.getY());
        }
        if (this.zzaqh) {
            MotionEvent motionEvent2 = motionEvent;
            if (this.zzaqf != null) {
                this.zzaqf.onTouchEvent(motionEvent);
                if (n == 1) {
                    motionEvent2 = MotionEvent.obtain((MotionEvent)motionEvent);
                    motionEvent2.setAction(3);
                }
            }
            if (this.targetView.getParent() != null) {
                this.targetView.onTouchEvent(motionEvent2);
            }
        } else {
            this.zzaqe.onTouchEvent(motionEvent);
        }
        return true;
    }

    private boolean zzc(float f, float f2) {
        return this.zzapX.contains(Math.round(f), Math.round(f2));
    }

    private Animator zzsM() {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.zzaqa.asView(), (String)"alpha", (float[])new float[]{0.0f, 1.0f}).setDuration(350L);
        objectAnimator.setInterpolator((TimeInterpolator)zzbim.zzTk());
        float f = this.zzapW.exactCenterX() - this.zzapY.getCenterX();
        float f2 = this.zzapW.exactCenterY() - this.zzapY.getCenterY();
        Animator animator = this.zzapY.zze(f, f2);
        Animator animator2 = this.zzapZ.zzsM();
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{objectAnimator, animator, animator2});
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                zza.this.zzaqc = zza.this.zzsN();
                zza.this.zzaqc.start();
            }
        });
        return animatorSet;
    }

    private Animator zzk(final @Nullable Runnable runnable) {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.zzaqa.asView(), (String)"alpha", (float[])new float[]{0.0f}).setDuration(200L);
        objectAnimator.setInterpolator((TimeInterpolator)zzbim.zzTl());
        Animator animator = this.zzapY.zzsO();
        Animator animator2 = this.zzapZ.zzsO();
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{objectAnimator, animator, animator2});
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                zza.this.setVisibility(8);
                zza.this.zzaqc = null;
                if (runnable != null) {
                    runnable.run();
                }
            }
        });
        return animatorSet;
    }

    private Animator zzl(final @Nullable Runnable runnable) {
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)this.zzaqa.asView(), (String)"alpha", (float[])new float[]{0.0f}).setDuration(200L);
        objectAnimator.setInterpolator((TimeInterpolator)zzbim.zzTl());
        float f = this.zzapW.exactCenterX() - this.zzapY.getCenterX();
        float f2 = this.zzapW.exactCenterY() - this.zzapY.getCenterY();
        Animator animator = this.zzapY.zzf(f, f2);
        Animator animator2 = this.zzapZ.zzsP();
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{objectAnimator, animator, animator2});
        animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                zza.this.setVisibility(8);
                zza.this.zzaqc = null;
                if (runnable != null) {
                    runnable.run();
                }
            }
        });
        return animatorSet;
    }

    private Animator zzsN() {
        return this.zzapZ.zzsN();
    }

    public static interface zza {
        public void zzsE();

        public void dismiss();
    }
}

