/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.internal.featurehighlight;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.v4.graphics.ColorUtils;
import android.util.TypedValue;
import com.google.android.gms.R;
import com.google.android.gms.common.util.zzs;
import com.google.android.gms.internal.zzbim;
import com.google.android.gms.internal.zzbin;

class zze
extends Drawable {
    private final int zzaqB;
    private final int zzaqC;
    private final int zzaqD;
    private final Rect zzapW = new Rect();
    private final Rect zzaqv = new Rect();
    private final Paint zzapR = new Paint();
    private float zzapS;
    private float zzaqu = 1.0f;
    private float centerX;
    private float centerY;
    private float zzaqE = 0.0f;
    private float zzaqF = 0.0f;
    private int zzaqG = 244;

    public zze(Context context) {
        if (zzs.zzyI()) {
            this.setColor(zze.zzag(context));
        } else {
            this.setColor(context.getResources().getColor(R.color.cast_libraries_material_featurehighlight_outer_highlight_default_color));
        }
        this.zzapR.setAntiAlias(true);
        this.zzapR.setStyle(Paint.Style.FILL);
        Resources resources = context.getResources();
        this.zzaqB = resources.getDimensionPixelSize(R.dimen.cast_libraries_material_featurehighlight_center_threshold);
        this.zzaqC = resources.getDimensionPixelSize(R.dimen.cast_libraries_material_featurehighlight_center_horizontal_offset);
        this.zzaqD = resources.getDimensionPixelSize(R.dimen.cast_libraries_material_featurehighlight_outer_padding);
    }

    public void draw(Canvas canvas) {
        canvas.drawCircle(this.centerX + 0.0f, this.centerY + 0.0f, this.zzapS * this.zzaqu, this.zzapR);
    }

    public void setAlpha(int n) {
        this.zzapR.setAlpha(n);
        this.invalidateSelf();
    }

    public int getAlpha() {
        return this.zzapR.getAlpha();
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.zzapR.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    public int getOpacity() {
        return -3;
    }

    @ColorInt
    public int getColor() {
        return this.zzapR.getColor();
    }

    public void setColor(@ColorInt int n) {
        this.zzapR.setColor(n);
        this.zzaqG = this.zzapR.getAlpha();
        this.invalidateSelf();
    }

    public void zzb(Rect rect, Rect rect2) {
        this.zzapW.set(rect);
        this.zzaqv.set(rect2);
        float f = rect.exactCenterX();
        float f2 = rect.exactCenterY();
        Rect rect3 = this.getBounds();
        float f3 = Math.min(f2 - (float)rect3.top, (float)rect3.bottom - f2);
        if (f3 < (float)this.zzaqB) {
            this.centerX = f;
            this.centerY = f2;
        } else {
            boolean bl = f <= rect3.exactCenterX();
            this.centerX = bl ? rect2.exactCenterX() + (float)this.zzaqC : rect2.exactCenterX() - (float)this.zzaqC;
            this.centerY = rect2.exactCenterY();
        }
        this.zzapS = (float)this.zzaqD + Math.max(this.zza(this.centerX, this.centerY, rect), this.zza(this.centerX, this.centerY, rect2));
        this.invalidateSelf();
    }

    public float getCenterX() {
        return this.centerX;
    }

    public float getCenterY() {
        return this.centerY;
    }

    public boolean zzd(float f, float f2) {
        float f3 = zzbin.zzb(f, f2, this.centerX, this.centerY);
        return f3 < this.zzapS;
    }

    private float zza(float f, float f2, Rect rect) {
        return (float)Math.ceil(zzbin.zza(f, f2, rect.left, rect.top, rect.right, rect.bottom));
    }

    @TargetApi(value=21)
    private static int zzag(Context context) {
        TypedValue typedValue = new TypedValue();
        context.getTheme().resolveAttribute(16843827, typedValue, true);
        return ColorUtils.setAlphaComponent((int)typedValue.data, (int)244);
    }

    public Animator zze(float f, float f2) {
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{0.0f, 1.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofFloat((String)"translationX", (float[])new float[]{f, 0.0f});
        PropertyValuesHolder propertyValuesHolder3 = PropertyValuesHolder.ofFloat((String)"translationY", (float[])new float[]{f2, 0.0f});
        PropertyValuesHolder propertyValuesHolder4 = PropertyValuesHolder.ofInt((String)"alpha", (int[])new int[]{0, this.zzaqG});
        ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2, propertyValuesHolder3, propertyValuesHolder4});
        objectAnimator.setInterpolator((TimeInterpolator)zzbim.zzTk());
        return objectAnimator.setDuration(350L);
    }

    public Animator zzf(float f, float f2) {
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{0.0f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofInt((String)"alpha", (int[])new int[]{0});
        PropertyValuesHolder propertyValuesHolder3 = PropertyValuesHolder.ofFloat((String)"translationX", (float[])new float[]{0.0f, f});
        PropertyValuesHolder propertyValuesHolder4 = PropertyValuesHolder.ofFloat((String)"translationY", (float[])new float[]{0.0f, f2});
        ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder3, propertyValuesHolder4, propertyValuesHolder2});
        objectAnimator.setInterpolator((TimeInterpolator)zzbim.zzTl());
        return objectAnimator.setDuration(200L);
    }

    public Animator zzsO() {
        PropertyValuesHolder propertyValuesHolder = PropertyValuesHolder.ofFloat((String)"scale", (float[])new float[]{1.125f});
        PropertyValuesHolder propertyValuesHolder2 = PropertyValuesHolder.ofInt((String)"alpha", (int[])new int[]{0});
        ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)((Object)this), (PropertyValuesHolder[])new PropertyValuesHolder[]{propertyValuesHolder, propertyValuesHolder2});
        objectAnimator.setInterpolator((TimeInterpolator)zzbim.zzTl());
        return objectAnimator.setDuration(200L);
    }
}

