/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast.framework.media;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.google.android.gms.cast.AdBreakInfo;
import com.google.android.gms.cast.Cast;
import com.google.android.gms.cast.CastDevice;
import com.google.android.gms.cast.MediaInfo;
import com.google.android.gms.cast.MediaQueueItem;
import com.google.android.gms.cast.MediaStatus;
import com.google.android.gms.cast.TextTrackStyle;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.internal.zzyi;
import com.google.android.gms.internal.zzyl;
import com.google.android.gms.internal.zzyv;
import com.google.android.gms.internal.zzyw;
import com.google.android.gms.internal.zzyx;
import com.google.android.gms.internal.zzzv;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

public class RemoteMediaClient
implements Cast.MessageReceivedCallback {
    private final Object zzrN;
    private final Handler mHandler;
    private final zzyv zzanU;
    private final zza zzary;
    private final Cast.CastApi zzaph;
    private GoogleApiClient zzarz;
    private final List<Listener> mListeners = new CopyOnWriteArrayList<Listener>();
    private final Map<ProgressListener, zzd> zzarA = new ConcurrentHashMap<ProgressListener, zzd>();
    private final Map<Long, zzd> zzarB = new ConcurrentHashMap<Long, zzd>();
    private ParseAdsInfoCallback zzarC;
    public static final String NAMESPACE = zzyv.NAMESPACE;
    public static final int RESUME_STATE_UNCHANGED = 0;
    public static final int RESUME_STATE_PLAY = 1;
    public static final int RESUME_STATE_PAUSE = 2;
    public static final int STATUS_SUCCEEDED = 0;
    public static final int STATUS_FAILED = 2100;
    public static final int STATUS_REPLACED = 2103;

    public RemoteMediaClient(@NonNull zzyv zzyv2, @NonNull Cast.CastApi castApi) {
        this.zzrN = new Object();
        this.mHandler = new Handler(Looper.getMainLooper());
        this.zzary = new zza();
        this.zzaph = castApi;
        this.zzanU = (zzyv)zzac.zzw((Object)zzyv2);
        this.zzanU.zza(new zzyv.zza(){

            public void onStatusUpdated() {
                this.zztj();
                RemoteMediaClient.this.zzti();
                for (Listener listener : RemoteMediaClient.this.mListeners) {
                    listener.onStatusUpdated();
                }
            }

            public void onMetadataUpdated() {
                this.zztj();
                for (Listener listener : RemoteMediaClient.this.mListeners) {
                    listener.onMetadataUpdated();
                }
            }

            public void onQueueStatusUpdated() {
                for (Listener listener : RemoteMediaClient.this.mListeners) {
                    listener.onQueueStatusUpdated();
                }
            }

            public void onPreloadStatusUpdated() {
                for (Listener listener : RemoteMediaClient.this.mListeners) {
                    listener.onPreloadStatusUpdated();
                }
            }

            public void onAdBreakStatusUpdated() {
                for (Listener listener : RemoteMediaClient.this.mListeners) {
                    listener.onAdBreakStatusUpdated();
                }
            }

            private void zztj() {
                MediaStatus mediaStatus;
                if (RemoteMediaClient.this.zzarC != null && (mediaStatus = RemoteMediaClient.this.getMediaStatus()) != null) {
                    mediaStatus.zzak(RemoteMediaClient.this.zzarC.parseIsPlayingAdFromMediaStatus(mediaStatus));
                    List<AdBreakInfo> list = RemoteMediaClient.this.zzarC.parseAdBreaksFromMediaStatus(mediaStatus);
                    MediaInfo mediaInfo = RemoteMediaClient.this.getMediaInfo();
                    if (mediaInfo != null) {
                        mediaInfo.zzy(list);
                    }
                }
            }
        });
        this.zzanU.zza((zzyw)this.zzary);
    }

    public void zzd(GoogleApiClient googleApiClient) throws IOException {
        if (this.zzarz == googleApiClient) {
            return;
        }
        if (this.zzarz != null) {
            this.zzanU.zzua();
            this.zzaph.removeMessageReceivedCallbacks(this.zzarz, this.getNamespace());
            this.zzary.zzc(null);
            this.mHandler.removeCallbacksAndMessages(null);
        }
        this.zzarz = googleApiClient;
        if (this.zzarz != null) {
            this.zzaph.setMessageReceivedCallbacks(this.zzarz, this.getNamespace(), (Cast.MessageReceivedCallback)this);
            this.zzary.zzc(this.zzarz);
        }
    }

    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo) {
        return this.load(mediaInfo, true, 0L, null, null);
    }

    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, boolean bl) {
        return this.load(mediaInfo, bl, 0L, null, null);
    }

    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, boolean bl, long l) {
        return this.load(mediaInfo, bl, l, null, null);
    }

    public PendingResult<MediaChannelResult> load(MediaInfo mediaInfo, boolean bl, long l, JSONObject jSONObject) {
        return this.load(mediaInfo, bl, l, null, jSONObject);
    }

    public PendingResult<MediaChannelResult> load(final MediaInfo mediaInfo, final boolean bl, final long l, final long[] lArray, final JSONObject jSONObject) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zzth();
        return this.zza(new zzb(this.zzarz){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaClient.this.zzrN;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.zzanU.zza(this.zzaoC, mediaInfo, bl, l, lArray, jSONObject);
                    }
                    catch (IOException | IllegalStateException exception) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> pause() {
        return this.pause(null);
    }

    public PendingResult<MediaChannelResult> pause(final JSONObject jSONObject) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zzth();
        return this.zza(new zzb(this.zzarz){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaClient.this.zzrN;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.zzanU.zza(this.zzaoC, jSONObject);
                    }
                    catch (zzyv.zzb | IOException throwable) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> stop() {
        return this.stop(null);
    }

    public PendingResult<MediaChannelResult> stop(final JSONObject jSONObject) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zzth();
        return this.zza(new zzb(this.zzarz){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaClient.this.zzrN;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.zzanU.zzb(this.zzaoC, jSONObject);
                    }
                    catch (zzyv.zzb | IOException throwable) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> play() {
        return this.play(null);
    }

    public PendingResult<MediaChannelResult> play(final JSONObject jSONObject) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zzth();
        return this.zza(new zzb(this.zzarz){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaClient.this.zzrN;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.zzanU.zzc(this.zzaoC, jSONObject);
                    }
                    catch (zzyv.zzb | IOException throwable) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> seek(long l) {
        return this.seek(l, 0, null);
    }

    public PendingResult<MediaChannelResult> seek(long l, int n) {
        return this.seek(l, n, null);
    }

    public PendingResult<MediaChannelResult> seek(final long l, final int n, final JSONObject jSONObject) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zzth();
        return this.zza(new zzb(this.zzarz){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaClient.this.zzrN;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.zzanU.zza(this.zzaoC, l, n, jSONObject);
                    }
                    catch (zzyv.zzb | IOException throwable) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setStreamVolume(double d) throws IllegalArgumentException {
        return this.setStreamVolume(d, null);
    }

    public PendingResult<MediaChannelResult> setStreamVolume(final double d, final JSONObject jSONObject) throws IllegalArgumentException {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zzth();
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            throw new IllegalArgumentException(new StringBuilder(41).append("Volume cannot be ").append(d).toString());
        }
        return this.zza(new zzb(this.zzarz){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaClient.this.zzrN;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.zzanU.zza(this.zzaoC, d, jSONObject);
                    }
                    catch (zzyv.zzb | IOException | IllegalArgumentException throwable) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setStreamMute(boolean bl) {
        return this.setStreamMute(bl, null);
    }

    public PendingResult<MediaChannelResult> setStreamMute(final boolean bl, final JSONObject jSONObject) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zzth();
        return this.zza(new zzb(this.zzarz){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaClient.this.zzrN;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.zzanU.zza(this.zzaoC, bl, jSONObject);
                    }
                    catch (zzyv.zzb | IOException throwable) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> requestStatus() {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zzth();
        return this.zza(new zzb(this.zzarz){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaClient.this.zzrN;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.zzanU.zza(this.zzaoC);
                    }
                    catch (IOException iOException) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setActiveMediaTracks(final long[] lArray) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zzth();
        if (lArray == null) {
            throw new IllegalArgumentException("trackIds cannot be null");
        }
        return this.zza(new zzb(this.zzarz){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaClient.this.zzrN;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.zzanU.zza(this.zzaoC, lArray);
                    }
                    catch (zzyv.zzb | IOException throwable) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> setTextTrackStyle(final TextTrackStyle textTrackStyle) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zzth();
        if (textTrackStyle == null) {
            throw new IllegalArgumentException("trackStyle cannot be null");
        }
        return this.zza(new zzb(this.zzarz){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaClient.this.zzrN;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.zzanU.zza(this.zzaoC, textTrackStyle);
                    }
                    catch (zzyv.zzb | IOException throwable) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueLoad(MediaQueueItem[] mediaQueueItemArray, int n, int n2, JSONObject jSONObject) throws IllegalArgumentException {
        return this.queueLoad(mediaQueueItemArray, n, n2, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueLoad(final MediaQueueItem[] mediaQueueItemArray, final int n, final int n2, final long l, final JSONObject jSONObject) throws IllegalArgumentException {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zzth();
        return this.zza(new zzb(this.zzarz){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaClient.this.zzrN;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.zzanU.zza(this.zzaoC, mediaQueueItemArray, n, n2, l, jSONObject);
                    }
                    catch (IOException iOException) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueInsertItems(final MediaQueueItem[] mediaQueueItemArray, final int n, final JSONObject jSONObject) throws IllegalArgumentException {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zzth();
        return this.zza(new zzb(this.zzarz){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaClient.this.zzrN;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.zzanU.zza(this.zzaoC, mediaQueueItemArray, n, 0, -1, -1L, jSONObject);
                    }
                    catch (zzyv.zzb | IOException throwable) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueAppendItem(MediaQueueItem mediaQueueItem, JSONObject jSONObject) throws IllegalArgumentException {
        return this.queueInsertItems(new MediaQueueItem[]{mediaQueueItem}, 0, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueInsertAndPlayItem(MediaQueueItem mediaQueueItem, int n, JSONObject jSONObject) {
        return this.queueInsertAndPlayItem(mediaQueueItem, n, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueInsertAndPlayItem(final MediaQueueItem mediaQueueItem, final int n, final long l, final JSONObject jSONObject) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zzth();
        return this.zza(new zzb(this.zzarz){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaClient.this.zzrN;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.zzanU.zza(this.zzaoC, new MediaQueueItem[]{mediaQueueItem}, n, 0, 0, l, jSONObject);
                    }
                    catch (zzyv.zzb | IOException throwable) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueUpdateItems(final MediaQueueItem[] mediaQueueItemArray, final JSONObject jSONObject) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zzth();
        return this.zza(new zzb(this.zzarz){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaClient.this.zzrN;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.zzanU.zza(this.zzaoC, 0, -1L, mediaQueueItemArray, 0, null, jSONObject);
                    }
                    catch (zzyv.zzb | IOException throwable) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueRemoveItems(final int[] nArray, final JSONObject jSONObject) throws IllegalArgumentException {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zzth();
        return this.zza(new zzb(this.zzarz){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaClient.this.zzrN;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.zzanU.zza(this.zzaoC, nArray, jSONObject);
                    }
                    catch (zzyv.zzb | IOException throwable) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueReorderItems(final int[] nArray, final int n, final JSONObject jSONObject) throws IllegalArgumentException {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zzth();
        return this.zza(new zzb(this.zzarz){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaClient.this.zzrN;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.zzanU.zza(this.zzaoC, nArray, n, jSONObject);
                    }
                    catch (zzyv.zzb | IOException throwable) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queuePrev(final JSONObject jSONObject) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zzth();
        return this.zza(new zzb(this.zzarz){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaClient.this.zzrN;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.zzanU.zza(this.zzaoC, 0, -1L, null, -1, null, jSONObject);
                    }
                    catch (zzyv.zzb | IOException throwable) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueNext(final JSONObject jSONObject) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zzth();
        return this.zza(new zzb(this.zzarz){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaClient.this.zzrN;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.zzanU.zza(this.zzaoC, 0, -1L, null, 1, null, jSONObject);
                    }
                    catch (zzyv.zzb | IOException throwable) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueSetRepeatMode(final int n, final JSONObject jSONObject) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zzth();
        return this.zza(new zzb(this.zzarz){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaClient.this.zzrN;
                synchronized (object) {
                    try {
                        RemoteMediaClient.this.zzanU.zza(this.zzaoC, 0, -1L, null, 0, Integer.valueOf(n), jSONObject);
                    }
                    catch (zzyv.zzb | IOException throwable) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueRemoveItem(final int n, final JSONObject jSONObject) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zzth();
        return this.zza(new zzb(this.zzarz){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaClient.this.zzrN;
                synchronized (object) {
                    if (RemoteMediaClient.this.zzbR(n) == -1) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(0)));
                        return;
                    }
                    try {
                        RemoteMediaClient.this.zzanU.zza(this.zzaoC, new int[]{n}, jSONObject);
                    }
                    catch (zzyv.zzb | IOException throwable) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueJumpToItem(int n, JSONObject jSONObject) {
        return this.queueJumpToItem(n, -1L, jSONObject);
    }

    public PendingResult<MediaChannelResult> queueJumpToItem(final int n, final long l, final JSONObject jSONObject) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zzth();
        return this.zza(new zzb(this.zzarz){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaClient.this.zzrN;
                synchronized (object) {
                    if (RemoteMediaClient.this.zzbR(n) == -1) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(0)));
                        return;
                    }
                    try {
                        RemoteMediaClient.this.zzanU.zza(this.zzaoC, n, l, null, 0, null, jSONObject);
                    }
                    catch (zzyv.zzb | IOException throwable) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    public PendingResult<MediaChannelResult> queueMoveItemToNewIndex(final int n, final int n2, final JSONObject jSONObject) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zzth();
        return this.zza(new zzb(this.zzarz){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void zza(zzyl zzyl2) {
                Object object = RemoteMediaClient.this.zzrN;
                synchronized (object) {
                    int n4 = RemoteMediaClient.this.zzbR(n);
                    if (n4 == -1) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(0)));
                        return;
                    }
                    if (n2 < 0) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2001, String.format(Locale.ROOT, "Invalid request: Invalid newIndex %d.", n2))));
                        return;
                    }
                    if (n4 == n2) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(0)));
                        return;
                    }
                    int n22 = n2 > n4 ? n2 + 1 : n2;
                    MediaQueueItem mediaQueueItem = RemoteMediaClient.this.getMediaStatus().getQueueItem(n22);
                    int n3 = 0;
                    if (mediaQueueItem != null) {
                        n3 = mediaQueueItem.getItemId();
                    }
                    try {
                        RemoteMediaClient.this.zzanU.zza(this.zzaoC, new int[]{n}, n3, jSONObject);
                    }
                    catch (zzyv.zzb | IOException throwable) {
                        this.zzb((MediaChannelResult)this.zzc(new Status(2100)));
                    }
                }
            }
        });
    }

    private int zzbR(int n) {
        zzac.zzdn((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        for (int i = 0; i < mediaStatus.getQueueItemCount(); ++i) {
            if (mediaStatus.getQueueItem(i).getItemId() != n) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getApproximateStreamPosition() {
        Object object = this.zzrN;
        synchronized (object) {
            zzac.zzdn((String)"Must be called from the main thread.");
            return this.zzanU.getApproximateStreamPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStreamDuration() {
        Object object = this.zzrN;
        synchronized (object) {
            zzac.zzdn((String)"Must be called from the main thread.");
            return this.zzanU.getStreamDuration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaStatus getMediaStatus() {
        Object object = this.zzrN;
        synchronized (object) {
            zzac.zzdn((String)"Must be called from the main thread.");
            return this.zzanU.getMediaStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaInfo getMediaInfo() {
        Object object = this.zzrN;
        synchronized (object) {
            zzac.zzdn((String)"Must be called from the main thread.");
            return this.zzanU.getMediaInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPlayerState() {
        Object object = this.zzrN;
        synchronized (object) {
            zzac.zzdn((String)"Must be called from the main thread.");
            MediaStatus mediaStatus = this.getMediaStatus();
            return mediaStatus != null ? mediaStatus.getPlayerState() : 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIdleReason() {
        Object object = this.zzrN;
        synchronized (object) {
            zzac.zzdn((String)"Must be called from the main thread.");
            MediaStatus mediaStatus = this.getMediaStatus();
            return mediaStatus != null ? mediaStatus.getIdleReason() : 0;
        }
    }

    public boolean isLiveStream() {
        zzac.zzdn((String)"Must be called from the main thread.");
        MediaInfo mediaInfo = this.getMediaInfo();
        return mediaInfo != null && mediaInfo.getStreamType() == 2;
    }

    public boolean isPlaying() {
        zzac.zzdn((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.getPlayerState() == 2;
    }

    public boolean isPaused() {
        zzac.zzdn((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && (mediaStatus.getPlayerState() == 3 || this.isLiveStream() && this.getIdleReason() == 2);
    }

    public boolean isBuffering() {
        zzac.zzdn((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.getPlayerState() == 4;
    }

    public boolean isLoadingNextItem() {
        zzac.zzdn((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.getLoadingItemId() != 0;
    }

    public MediaQueueItem getCurrentItem() {
        zzac.zzdn((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus == null ? null : mediaStatus.getQueueItemById(mediaStatus.getCurrentItemId());
    }

    public MediaQueueItem getLoadingItem() {
        zzac.zzdn((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus == null ? null : mediaStatus.getQueueItemById(mediaStatus.getLoadingItemId());
    }

    public MediaQueueItem getPreloadedItem() {
        zzac.zzdn((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus == null ? null : mediaStatus.getQueueItemById(mediaStatus.getPreloadedItemId());
    }

    public void togglePlayback() {
        zzac.zzdn((String)"Must be called from the main thread.");
        int n = this.getPlayerState();
        if (n == 4 || n == 2) {
            this.pause();
        } else {
            this.play();
        }
    }

    public boolean hasMediaSession() {
        zzac.zzdn((String)"Must be called from the main thread.");
        return this.isBuffering() || this.isPlaying() || this.isPaused() || this.isLoadingNextItem();
    }

    public void addListener(Listener listener) {
        zzac.zzdn((String)"Must be called from the main thread.");
        if (listener != null) {
            this.mListeners.add(listener);
        }
    }

    public void removeListener(Listener listener) {
        zzac.zzdn((String)"Must be called from the main thread.");
        if (listener != null) {
            this.mListeners.remove(listener);
        }
    }

    public boolean addProgressListener(ProgressListener progressListener, long l) {
        zzac.zzdn((String)"Must be called from the main thread.");
        if (progressListener == null || this.zzarA.containsKey(progressListener)) {
            return false;
        }
        zzd zzd2 = this.zzarB.get(l);
        if (zzd2 == null) {
            zzd2 = new zzd(l);
            this.zzarB.put(l, zzd2);
        }
        zzd2.zza(progressListener);
        this.zzarA.put(progressListener, zzd2);
        if (this.hasMediaSession()) {
            zzd2.start();
        }
        return true;
    }

    public void removeProgressListener(ProgressListener progressListener) {
        zzac.zzdn((String)"Must be called from the main thread.");
        zzd zzd2 = this.zzarA.remove(progressListener);
        if (zzd2 != null) {
            zzd2.zzb(progressListener);
            if (!zzd2.zztl()) {
                this.zzarB.remove(zzd2.zztk());
                zzd2.stop();
            }
        }
    }

    public void setParseAdsInfoCallback(ParseAdsInfoCallback parseAdsInfoCallback) {
        zzac.zzdn((String)"Must be called from the main thread.");
        this.zzarC = parseAdsInfoCallback;
    }

    public boolean isPlayingAd() {
        zzac.zzdn((String)"Must be called from the main thread.");
        MediaStatus mediaStatus = this.getMediaStatus();
        return mediaStatus != null && mediaStatus.isPlayingAd();
    }

    public String getNamespace() {
        zzac.zzdn((String)"Must be called from the main thread.");
        return this.zzanU.getNamespace();
    }

    public void onMessageReceived(CastDevice castDevice, String string2, String string3) {
        this.zzanU.zzcO(string3);
    }

    private void zzth() throws IllegalStateException {
        if (this.zzarz == null) {
            throw new IllegalStateException("No connection");
        }
    }

    private zzb zza(zzb zzb2) {
        try {
            this.zzarz.zzb((zzzv.zza)zzb2);
            return zzb2;
        }
        catch (IllegalStateException illegalStateException) {
            try {
                zzb2.zzb((MediaChannelResult)zzb2.zzc(new Status(2100)));
                return zzb2;
            }
            catch (Throwable throwable) {
                return zzb2;
            }
        }
    }

    private void zza(Set<ProgressListener> set) {
        block5: {
            HashSet<ProgressListener> hashSet;
            block6: {
                block4: {
                    if (this.isBuffering() || this.isPaused()) {
                        return;
                    }
                    hashSet = new HashSet<ProgressListener>(set);
                    if (!this.isPlaying()) break block4;
                    for (ProgressListener progressListener : hashSet) {
                        progressListener.onProgressUpdated(this.getApproximateStreamPosition(), this.getStreamDuration());
                    }
                    break block5;
                }
                if (!this.isLoadingNextItem()) break block6;
                MediaQueueItem mediaQueueItem = this.getLoadingItem();
                if (mediaQueueItem == null || mediaQueueItem.getMedia() == null) break block5;
                for (ProgressListener progressListener : hashSet) {
                    progressListener.onProgressUpdated(0L, mediaQueueItem.getMedia().getStreamDuration());
                }
                break block5;
            }
            for (ProgressListener progressListener : hashSet) {
                progressListener.onProgressUpdated(0L, 0L);
            }
        }
    }

    private void zzti() {
        for (zzd zzd2 : this.zzarB.values()) {
            if (this.hasMediaSession() && !zzd2.isStarted()) {
                zzd2.start();
            } else if (!this.hasMediaSession() && zzd2.isStarted()) {
                zzd2.stop();
            }
            if (!zzd2.isStarted() || !this.isBuffering() && !this.isPaused() && !this.isLoadingNextItem()) continue;
            this.zza(zzd2.zzarH);
        }
    }

    private class zzd {
        private final Set<ProgressListener> zzarH = new HashSet<ProgressListener>();
        private final long zzarI;
        private final Runnable zzarJ;
        private boolean zzarK;

        public zzd(long l) {
            this.zzarI = l;
            this.zzarJ = new TimerTask(){

                @Override
                public void run() {
                    RemoteMediaClient.this.zza(zzd.this.zzarH);
                    RemoteMediaClient.this.mHandler.postDelayed((Runnable)this, zzd.this.zzarI);
                }
            };
        }

        public long zztk() {
            return this.zzarI;
        }

        public void zza(ProgressListener progressListener) {
            this.zzarH.add(progressListener);
        }

        public void zzb(ProgressListener progressListener) {
            this.zzarH.remove(progressListener);
        }

        public boolean zztl() {
            return !this.zzarH.isEmpty();
        }

        public void start() {
            RemoteMediaClient.this.mHandler.removeCallbacks(this.zzarJ);
            this.zzarK = true;
            RemoteMediaClient.this.mHandler.postDelayed(this.zzarJ, this.zzarI);
        }

        public void stop() {
            RemoteMediaClient.this.mHandler.removeCallbacks(this.zzarJ);
            this.zzarK = false;
        }

        public boolean isStarted() {
            return this.zzarK;
        }
    }

    static abstract class zzb
    extends zzyi<MediaChannelResult> {
        zzyx zzaoC = new zzyx(){

            public void zzC(long l) {
                zzb.this.zzb((MediaChannelResult)zzb.this.zzc(new Status(2103)));
            }

            public void zza(long l, int n, Object object) {
                JSONObject jSONObject = null;
                if (object instanceof JSONObject) {
                    jSONObject = (JSONObject)object;
                }
                zzb.this.zzb(new zzc(new Status(n), jSONObject));
            }
        };

        zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        public MediaChannelResult zzr(final Status status) {
            return new MediaChannelResult(this){

                public Status getStatus() {
                    return status;
                }

                @Override
                public JSONObject getCustomData() {
                    return null;
                }
            };
        }

        protected void zza(zzyl zzyl2) {
        }

        public /* synthetic */ Result zzc(Status status) {
            return this.zzr(status);
        }
    }

    private static final class zzc
    implements MediaChannelResult {
        private final Status zzahq;
        private final JSONObject zzalI;

        zzc(Status status, JSONObject jSONObject) {
            this.zzahq = status;
            this.zzalI = jSONObject;
        }

        public Status getStatus() {
            return this.zzahq;
        }

        @Override
        public JSONObject getCustomData() {
            return this.zzalI;
        }
    }

    public static interface MediaChannelResult
    extends Result {
        public JSONObject getCustomData();
    }

    private class com.google.android.gms.cast.framework.media.RemoteMediaClient$zza
    implements zzyw {
        private GoogleApiClient zzaoy;
        private long zzaoz = 0L;

        public void zzc(GoogleApiClient googleApiClient) {
            this.zzaoy = googleApiClient;
        }

        public long zzsc() {
            return ++this.zzaoz;
        }

        public void zza(String string2, String string3, long l, String string4) throws IOException {
            if (this.zzaoy == null) {
                throw new IOException("No GoogleApiClient available");
            }
            for (Listener listener : RemoteMediaClient.this.mListeners) {
                listener.onSendingRemoteMediaRequest();
            }
            RemoteMediaClient.this.zzaph.sendMessage(this.zzaoy, string2, string3).setResultCallback((ResultCallback)new zza(l));
        }

        private final class zza
        implements ResultCallback<Status> {
            private final long zzaoA;

            zza(long l) {
                this.zzaoA = l;
            }

            public void zzp(@NonNull Status status) {
                if (!status.isSuccess()) {
                    RemoteMediaClient.this.zzanU.zzb(this.zzaoA, status.getStatusCode());
                }
            }

            public /* synthetic */ void onResult(@NonNull Result result) {
                this.zzp((Status)result);
            }
        }
    }

    public static interface ParseAdsInfoCallback {
        public boolean parseIsPlayingAdFromMediaStatus(MediaStatus var1);

        public List<AdBreakInfo> parseAdBreaksFromMediaStatus(MediaStatus var1);
    }

    public static interface ProgressListener {
        public void onProgressUpdated(long var1, long var3);
    }

    public static interface Listener {
        public void onStatusUpdated();

        public void onMetadataUpdated();

        public void onQueueStatusUpdated();

        public void onPreloadStatusUpdated();

        public void onSendingRemoteMediaRequest();

        public void onAdBreakStatusUpdated();
    }
}

